/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.util;

import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.util.LocalVariablesSorter;
import com.sun.btrace.util.TimeStampHelper;

public class TimeStampGenerator
extends LocalVariablesSorter {
    public static final String TIME_STAMP_NAME = "$btrace$time$stamp";
    private static final String CONSTRUCTOR = "<init>";
    private int[] ts_index;
    private int[] exitOpcodes;
    private int capturingIndex = -1;
    private boolean capturing = false;
    private boolean generatingIndex = false;
    private boolean entryCalled = false;
    private String methodName;
    private String className;

    public TimeStampGenerator(String className, int access, String name, String desc, MethodVisitor mv) {
        this(new int[]{-1, -1}, className, access, name, desc, mv, new int[]{177, 172, 174, 175, 173, 176});
    }

    public TimeStampGenerator(int[] tsindex, String className, int access, String name, String desc, MethodVisitor mv, int[] exitOpcodes) {
        super(access, desc, mv);
        this.methodName = name;
        this.className = className;
        this.ts_index = tsindex;
        this.exitOpcodes = new int[exitOpcodes.length];
        System.arraycopy(exitOpcodes, 0, this.exitOpcodes, 0, exitOpcodes.length);
    }

    @Override
    public void visitCode() {
        this.ts_index[0] = -1;
        this.ts_index[1] = -1;
        this.capturing = false;
        this.capturingIndex = -1;
        this.entryCalled = false;
        super.visitCode();
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.check();
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.check();
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitInsn(int opcode) {
        this.check();
        if (this.ts_index[1] == -1) {
            for (int exitOpcode : this.exitOpcodes) {
                if (exitOpcode != opcode) continue;
                if (this.ts_index[0] == -1 || this.ts_index[1] != -1) break;
                this.generateTS(1);
                break;
            }
        }
        super.visitInsn(opcode);
        if (this.ts_index[1] != -1) {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    this.ts_index[1] = -1;
                }
            }
        }
    }

    @Override
    public void visitIntInsn(int opcode, int var) {
        this.check();
        super.visitIntInsn(opcode, var);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.check();
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.check();
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.check();
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.check();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.generatingIndex) {
            super.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        if (!this.capturing && name.equals(TIME_STAMP_NAME) && desc.equals("()J")) {
            this.capturing = true;
            ++this.capturingIndex;
        }
        if (this.capturingIndex == -1) {
            if (!CONSTRUCTOR.equals(this.methodName) || !CONSTRUCTOR.equals(name)) {
                this.check();
            } else if (this.entryCalled) {
                this.check();
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc);
        if (this.capturingIndex == -1 && CONSTRUCTOR.equals(this.methodName) && CONSTRUCTOR.equals(name) & !this.entryCalled) {
            this.check();
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.check();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.check();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type2) {
        this.check();
        super.visitTryCatchBlock(start, end, handler, type2);
    }

    @Override
    public void visitTypeInsn(int opcode, String type2) {
        this.check();
        super.visitTypeInsn(opcode, type2);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.check();
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (opcode == 55 && !this.generatingIndex) {
            if (this.capturing) {
                this.ts_index[this.capturingIndex] = this.remap(var, Type.LONG_TYPE);
            }
            this.capturing = false;
        }
        super.visitVarInsn(opcode, var);
    }

    private void check() {
        this.entryCalled = true;
        this.capturing = false;
        this.generateTS(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTS(int index) {
        if (this.ts_index[index] > -1) {
            return;
        }
        try {
            this.generatingIndex = true;
            TimeStampHelper.generateTimeStampAccess(this, this.className);
            int varIndex = this.newLocal(Type.LONG_TYPE);
            int remappedIndex = this.remap(varIndex, Type.LONG_TYPE);
            this.visitVarInsn(Type.LONG_TYPE.getOpcode(54), varIndex);
            this.ts_index[index] = remappedIndex;
        }
        finally {
            this.generatingIndex = false;
        }
    }
}

