/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.ejb.base.io.SerializableJNDIContext;
import com.sun.ejb.base.io.SerializableS1ASEJBHomeReference;
import com.sun.ejb.base.io.SerializableS1ASEJBObjectReference;
import com.sun.ejb.containers.RemoteBusinessWrapperBase;
import com.sun.ejb.spi.io.IndirectlySerializable;
import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactory;
import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactoryFactory;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.glassfish.internal.api.Globals;
import org.omg.CORBA.Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EJBObjectOutputStream
extends ObjectOutputStream {
    protected static final Logger _ejbLogger = LogDomains.getLogger(EJBObjectOutputStream.class, "javax.enterprise.system.container.ejb");
    static final int EJBID_OFFSET = 0;
    static final int INSTANCEKEYLEN_OFFSET = 8;
    static final int INSTANCEKEY_OFFSET = 12;
    private static final byte HOME_KEY = -1;
    private ObjectInputOutputStreamFactory outputStreamHelper;

    EJBObjectOutputStream(OutputStream out, boolean replaceObject) throws IOException {
        super(out);
        if (replaceObject) {
            this.enableReplaceObject(replaceObject);
        }
        this.outputStreamHelper = ObjectInputOutputStreamFactoryFactory.getFactory();
    }

    @Override
    protected java.lang.Object replaceObject(java.lang.Object obj) throws IOException {
        java.lang.Object result = obj;
        ProtocolManager protocolMgr = this.getProtocolManager();
        if (obj instanceof IndirectlySerializable) {
            result = ((IndirectlySerializable)obj).getSerializableObjectFactory();
        } else if (obj instanceof RemoteBusinessWrapperBase) {
            result = this.getRemoteBusinessObjectFactory((RemoteBusinessWrapperBase)obj);
        } else if (protocolMgr != null && protocolMgr.isStub(obj) && protocolMgr.isLocal(obj)) {
            Object target = (Object)obj;
            result = this.getSerializableEJBReference(target, protocolMgr, null);
        } else if (obj instanceof Serializable) {
            result = obj;
        } else if (obj instanceof Context) {
            result = new SerializableJNDIContext((Context)obj);
        } else {
            if (_ejbLogger.isLoggable(Level.FINE)) {
                _ejbLogger.log(Level.FINE, "EJBObjectInputStream_handling_non_serializable_object", obj.getClass().getName());
            }
            result = obj;
        }
        return result;
    }

    @Override
    public void annotateClass(Class<?> cl) throws IOException {
        this.outputStreamHelper.annotateClass(this, cl);
    }

    private ProtocolManager getProtocolManager() {
        GlassFishORBHelper orbHelper = Globals.getDefaultHabitat().getComponent(GlassFishORBHelper.class);
        return orbHelper.isORBInitialized() ? orbHelper.getProtocolManager() : null;
    }

    private Serializable getRemoteBusinessObjectFactory(RemoteBusinessWrapperBase remoteBusinessWrapper) throws IOException {
        Object target = (Object)((java.lang.Object)remoteBusinessWrapper.getStub());
        return this.getSerializableEJBReference(target, this.getProtocolManager(), remoteBusinessWrapper.getBusinessInterfaceName());
    }

    private Serializable getSerializableEJBReference(Object obj, ProtocolManager protocolMgr, String remoteBusinessInterface) throws IOException {
        Serializable result = (Serializable)((java.lang.Object)obj);
        try {
            byte[] oid = protocolMgr.getObjectID(obj);
            long containerId = -1L;
            int keyLength = -1;
            if (oid != null && oid.length > 12) {
                containerId = Utility.bytesToLong(oid, 0);
                keyLength = Utility.bytesToInt(oid, 8);
                if (oid.length == keyLength + 12) {
                    boolean isHomeReference;
                    boolean bl = isHomeReference = keyLength == 1 && oid[12] == -1;
                    if (isHomeReference) {
                        result = new SerializableS1ASEJBHomeReference(containerId);
                    } else {
                        SerializableS1ASEJBObjectReference serRef = new SerializableS1ASEJBObjectReference(containerId, oid, keyLength, remoteBusinessInterface);
                        result = serRef;
                    }
                }
            }
        }
        catch (Exception ex) {
            _ejbLogger.log(Level.WARNING, "Exception while getting serializable object", ex);
            IOException ioEx = new IOException("Exception during extraction of instance key");
            ioEx.initCause(ex);
            throw ioEx;
        }
        return result;
    }
}

