/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBTimerTask;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.ejb.containers.TimerSchedule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

class RuntimeTimerState {
    private static final Logger logger = EjbContainerUtilImpl.getInstance().getLogger();
    private static final int CREATED = 0;
    private static final int SCHEDULED = 1;
    private static final int BEING_DELIVERED = 2;
    private static final int CANCELLED = 3;
    private int state_ = 0;
    private TimerPrimaryKey timerId_;
    private Date initialExpiration_;
    private long intervalDuration_;
    private long containerId_;
    private Object timedObjectPrimaryKey_;
    private boolean persistent_ = true;
    private Serializable info_;
    private TimerSchedule schedule_;
    private boolean expired_ = false;
    private BaseContainer container_;
    private EJBTimerTask currentTask_ = null;
    private int numExpirations_;
    private int numFailedDeliveries_;

    RuntimeTimerState(TimerPrimaryKey timerId, Date initialExpiration, long intervalDuration, BaseContainer container, Object timedObjectPkey, TimerSchedule schedule, Serializable info, boolean persistent) {
        this(timerId, initialExpiration, intervalDuration, container.getContainerId(), container, timedObjectPkey, schedule, info, persistent);
    }

    RuntimeTimerState(TimerPrimaryKey timerId, Date initialExpiration, long intervalDuration, long containerId, BaseContainer container, Object timedObjectPkey, TimerSchedule schedule, Serializable info, boolean persistent) {
        Calendar next;
        this.timerId_ = timerId;
        this.initialExpiration_ = initialExpiration;
        this.intervalDuration_ = intervalDuration;
        this.timedObjectPrimaryKey_ = timedObjectPkey;
        this.persistent_ = persistent;
        this.info_ = info;
        this.container_ = container;
        this.schedule_ = schedule;
        this.containerId_ = containerId;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "RuntimeTimerState " + this.timerId_ + " created");
        }
        if (schedule != null && !schedule.isValid(next = schedule.getNextTimeout())) {
            logger.log(Level.INFO, "Schedule: " + schedule.getScheduleAsString() + " already expired");
            this.expired();
        }
    }

    TimerPrimaryKey getTimerId() {
        return this.timerId_;
    }

    Date getInitialExpiration() {
        return this.initialExpiration_;
    }

    BaseContainer getContainer() {
        return this.container_;
    }

    long getContainerId() {
        return this.containerId_;
    }

    Object getTimedObjectPrimaryKey() {
        return this.timedObjectPrimaryKey_;
    }

    long getIntervalDuration() {
        return this.intervalDuration_;
    }

    TimerSchedule getTimerSchedule() {
        return this.schedule_;
    }

    void scheduled(EJBTimerTask timerTask) {
        if (logger.isLoggable(Level.FINER)) {
            this.printStateTransition(this.state_, 1);
        }
        this.currentTask_ = timerTask;
        this.state_ = 1;
        this.numFailedDeliveries_ = 0;
    }

    void rescheduled(EJBTimerTask timerTask) {
        if (logger.isLoggable(Level.FINER)) {
            this.printStateTransition(this.state_, 1);
        }
        this.currentTask_ = timerTask;
        this.state_ = 1;
        ++this.numFailedDeliveries_;
    }

    void restoredToDelivered() {
        if (logger.isLoggable(Level.FINER)) {
            this.printStateTransition(this.state_, 2);
        }
        this.currentTask_ = null;
        this.state_ = 2;
    }

    void delivered() {
        if (logger.isLoggable(Level.FINER)) {
            this.printStateTransition(this.state_, 2);
        }
        this.currentTask_ = null;
        if (this.numFailedDeliveries_ == 0) {
            ++this.numExpirations_;
        }
        this.state_ = 2;
    }

    void cancelled() {
        if (logger.isLoggable(Level.FINER)) {
            this.printStateTransition(this.state_, 3);
        }
        this.currentTask_ = null;
        this.state_ = 3;
    }

    String stateToString() {
        return this.stateToString(this.state_);
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "CREATED";
            }
            case 1: {
                return "SCHEDULED";
            }
            case 2: {
                return "BEING_DELIVERED";
            }
            case 3: {
                return "CANCELLED";
            }
        }
        return state + " NOT FOUND";
    }

    private void printStateTransition(int fromState, int toState) {
        logger.log(Level.FINER, this.timerId_ + ": " + this.stateToString(fromState) + " to " + this.stateToString(toState));
    }

    int getNumExpirations() {
        return this.numExpirations_;
    }

    int getNumFailedDeliveries() {
        return this.numFailedDeliveries_;
    }

    EJBTimerTask getCurrentTimerTask() {
        return this.currentTask_;
    }

    String getTimedObjectEjbName() {
        return this.container_.getEjbDescriptor().getName();
    }

    String getTimedObjectApplicationName() {
        EjbDescriptor ejbDesc = this.container_.getEjbDescriptor();
        Application app = ejbDesc.getApplication();
        return app != null ? app.getRegistrationName() : "";
    }

    boolean timedObjectIsEntity() {
        return this.timedObjectPrimaryKey_ != null;
    }

    boolean isActive() {
        return this.state_ != 3;
    }

    boolean isCancelled() {
        return this.state_ == 3;
    }

    boolean isCreated() {
        return this.state_ == 0;
    }

    boolean isBeingDelivered() {
        return this.state_ == 2;
    }

    boolean isScheduled() {
        return this.state_ == 1;
    }

    boolean isRescheduled() {
        return this.isScheduled() && this.numFailedDeliveries_ > 0;
    }

    Date getNextTimeout() {
        if (!this.isScheduled() && !this.isRescheduled()) {
            throw new IllegalStateException();
        }
        return this.currentTask_.getTimeout();
    }

    long getTimeRemaining() {
        Date timeout = this.getNextTimeout();
        Date now = new Date();
        return timeout.getTime() - now.getTime();
    }

    void expired() {
        this.expired_ = true;
    }

    boolean isExpired() {
        return this.expired_;
    }

    boolean isPeriodic() {
        return this.schedule_ != null || this.intervalDuration_ > 0L;
    }

    boolean isPersistent() {
        return this.persistent_;
    }

    Serializable getInfo() {
        return this.info_;
    }

    public int hashCode() {
        return this.timerId_.hashCode();
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof RuntimeTimerState) {
            equal = this.timerId_.equals(((RuntimeTimerState)other).timerId_);
        }
        return equal;
    }

    public String toString() {
        Object pk;
        StringBuffer buffer = new StringBuffer();
        buffer.append("'" + this.getTimerId() + "' ");
        buffer.append("'TimedObject = " + this.getTimedObjectEjbName() + "' ");
        buffer.append("'Application = " + this.getTimedObjectApplicationName() + "' ");
        buffer.append("'" + this.stateToString() + "' ");
        buffer.append("'" + (this.isPeriodic() ? "PERIODIC' " : "SINGLE-ACTION' "));
        buffer.append("'Container ID = " + this.containerId_ + "' ");
        buffer.append("'" + this.getInitialExpiration() + "' ");
        buffer.append("'" + this.getIntervalDuration() + "' ");
        TimerSchedule ts = this.getTimerSchedule();
        if (ts != null) {
            buffer.append("'" + ts.getScheduleAsString() + "' ");
        }
        if ((pk = this.getTimedObjectPrimaryKey()) != null) {
            buffer.append("'" + pk + "' ");
        }
        return buffer.toString();
    }
}

