/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.servermgmt.NodeKeystoreManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="_change-master-password-node")
@Scoped(value=PerLookup.class)
public class ChangeNodeMasterPasswordCommand
extends LocalInstanceCommand {
    @Param(name="nodedir", optional=true)
    protected String nodeDir;
    @Param(name="node", primary=true)
    protected String node;
    @Param(name="savemasterpassword", optional=true, defaultValue="false")
    protected boolean savemp;
    private static final String MASTER_PASSWORD_ALIAS = "master-password";
    private static final LocalStringsImpl strings = new LocalStringsImpl(ChangeNodeMasterPasswordCommand.class);
    private String newPassword;
    private String oldPassword;

    @Override
    protected int executeCommand() throws CommandException {
        try {
            File serverDir = new File(this.nodeDir, this.node);
            if (serverDir == null || !serverDir.isDirectory()) {
                throw new CommandException(strings.get("bad.node.dir", serverDir));
            }
            String serverName = this.getServerDirs().getServerName();
            HostAndPort adminAddress = this.getAdminAddress(serverName);
            if (this.isRunning(adminAddress.getHost(), adminAddress.getPort())) {
                throw new CommandException(strings.get("instance.is.running", serverName));
            }
            this.oldPassword = super.readPassword(strings.get("old.mp"));
            if (this.oldPassword == null) {
                throw new CommandException(strings.get("no.console"));
            }
            boolean valid = true;
            for (String instanceDir : this.getInstanceDirs(this.nodeDirChild)) {
                valid &= this.verifyInstancePassword(new File(this.nodeDirChild, instanceDir));
            }
            if (!valid) {
                throw new CommandException(strings.get("incorrect.old.mp"));
            }
            CommandModelData.ParamModelData nmpo = new CommandModelData.ParamModelData("New_Master_Password", String.class, false, null);
            nmpo.description = strings.get("new.mp");
            nmpo.param._password = true;
            this.newPassword = super.getPassword(nmpo, null, true);
            for (String instanceDir : this.getInstanceDirs(this.nodeDirChild)) {
                this.encryptKeystore(instanceDir);
            }
            if (this.savemp) {
                this.createMasterPasswordFile();
            }
            return 0;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), e);
        }
    }

    private boolean verifyInstancePassword(File instanceDir) {
        File mp = new File(new File(instanceDir, "config"), "cacerts.jks");
        return this.loadAndVerifyKeystore(mp, this.oldPassword);
    }

    @Override
    public int execute(String ... argv) throws CommandException {
        this.checkOneAndOnly = false;
        return super.execute(argv);
    }

    protected void createMasterPasswordFile() throws CommandException {
        File pwdFile = new File(this.getServerDirs().getAgentDir(), MASTER_PASSWORD_ALIAS);
        try {
            PasswordAdapter p = new PasswordAdapter(pwdFile.getAbsolutePath(), MASTER_PASSWORD_ALIAS.toCharArray());
            p.setPasswordForAlias(MASTER_PASSWORD_ALIAS, this.newPassword.getBytes());
            pwdFile.setReadable(true);
            pwdFile.setWritable(true);
        }
        catch (Exception ex) {
            throw new CommandException(strings.get("masterPasswordFileNotCreated", pwdFile), ex);
        }
    }

    public void encryptKeystore(String f) throws CommandException {
        RepositoryConfig nodeConfig = new RepositoryConfig(this.nodeDir, this.node, f);
        NodeKeystoreManager km = new NodeKeystoreManager();
        try {
            km.encryptKeystore(nodeConfig, this.oldPassword, this.newPassword);
        }
        catch (Exception e) {
            throw new CommandException(strings.get("Keystore.not.encrypted"), e);
        }
    }

    private ArrayList<String> getInstanceDirs(File parent) throws CommandException {
        ArrayList<String> instancesList = new ArrayList<String>();
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandException(strings.get("Instance.noInstanceDirs", parent));
        }
        for (File f : files) {
            if (f.getName().equals("agent")) continue;
            instancesList.add(f.getName());
        }
        return instancesList;
    }
}

