/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.SSHCommandsBase;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="setup-ssh")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public final class SetupSshKey
extends SSHCommandsBase {
    @Param(optional=true)
    private String sshpublickeyfile;
    @Param(optional=true, defaultValue="false")
    private boolean generatekey;
    @Inject
    private Habitat habitat;

    public SetupSshKey() {
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
    }

    protected void validate() throws CommandException {
        Globals.setDefaultHabitat(this.habitat);
        this.sshuser = this.resolver.resolve(this.sshuser);
        if (this.sshkeyfile == null) {
            String existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.sshkeyfile = SSHUtil.getDefaultKeyFile();
                if (this.promptForKeyGeneration()) {
                    this.generatekey = true;
                }
            } else {
                this.promptPass = true;
                this.sshkeyfile = existingKey;
                if (this.isEncryptedKey()) {
                    this.sshkeypassphrase = this.getSSHPassphrase(false);
                }
            }
        } else {
            this.validateKeyFile(this.sshkeyfile);
            if (this.isEncryptedKey()) {
                this.sshkeypassphrase = this.getSSHPassphrase(false);
            }
        }
        if (this.sshpublickeyfile != null) {
            this.validateKeyFile(this.sshpublickeyfile);
        }
    }

    protected int executeCommand() throws CommandException {
        SSHLauncher sshL = this.habitat.getComponent(SSHLauncher.class);
        String previousPassword = null;
        boolean status = false;
        for (String node : this.hosts) {
            boolean res;
            block13: {
                sshL.init(this.sshuser, node, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
                if (this.generatekey || this.promptPass) {
                    if (this.sshkeyfile != null || SSHUtil.getExistingKeyFile() != null) {
                        try {
                            if (sshL.checkConnection()) {
                                logger.info(Strings.get("SSHAlreadySetup", this.sshuser, node));
                                continue;
                            }
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    if (previousPassword != null) {
                        status = sshL.checkPasswordAuth();
                    }
                    if (!status) {
                        previousPassword = this.sshpassword = this.getSSHPassword(node);
                    }
                }
                try {
                    sshL.setupKey(node, this.sshpublickeyfile, this.generatekey, this.sshpassword);
                }
                catch (IOException ce) {
                    throw new CommandException(Strings.get("KeySetupFailed", ce.getMessage()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                res = false;
                try {
                    res = sshL.checkConnection();
                }
                catch (IOException ioe) {
                    if (!logger.isLoggable(Level.FINER)) break block13;
                    ioe.printStackTrace();
                }
            }
            if (res) continue;
            throw new CommandException(Strings.get("ConnFailed"));
        }
        return 0;
    }

    private void validateKeyFile(String file) throws CommandException {
        File f = new File(file);
        if (!f.exists()) {
            throw new CommandException(Strings.get("KeyDoesNotExist", file));
        }
        this.promptPass = true;
    }

    private boolean promptForKeyGeneration() {
        if (this.generatekey) {
            return true;
        }
        if (!this.programOpts.isInteractive()) {
            return false;
        }
        Console cons = System.console();
        if (cons != null) {
            String val = null;
            do {
                cons.printf("%s", Strings.get("GenerateKeyPairPrompt", this.sshuser, Arrays.toString(this.hosts)));
                val = cons.readLine();
                if (val == null || !val.equalsIgnoreCase("yes") && !val.equalsIgnoreCase("y")) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Generate key!");
                }
                return true;
            } while ((val == null || !val.equalsIgnoreCase("no") && !val.equalsIgnoreCase("n")) && val != null && !this.isValidAnswer(val));
        }
        return false;
    }
}

