/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.LoggerHelper;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipWriter;
import java.io.File;

class ZipStorage {
    private BackupRequest request;

    ZipStorage(BackupRequest req) throws BackupException {
        if (req == null) {
            throw new BackupException("backup-res.NoBackupRequest", this.getClass().getName() + ".ctor");
        }
        this.request = req;
    }

    void store() throws BackupException {
        File backupFileDir = null;
        backupFileDir = this.request.configOnly ? new File(this.request.domainDir, "config") : this.request.domainDir;
        String zipName = FileUtils.safeGetCanonicalPath(this.request.backupFile);
        String domainDirName = FileUtils.safeGetCanonicalPath(backupFileDir);
        FileListerRelative lister = new FileListerRelative(backupFileDir);
        lister.keepEmptyDirectories();
        String[] files = lister.getFiles();
        LoggerHelper.fine("Writing " + zipName);
        try {
            ZipWriter writer = new ZipWriter(zipName, domainDirName, files);
            if (BackupRequest.excludeDirs != null) {
                if (BackupRequest.excludeDirs.length > 0) {
                    writer.excludeDirs(BackupRequest.excludeDirs);
                }
            }
            writer.safeWrite();
        }
        catch (ZipFileException zfe) {
            throw new BackupException("backup-res.ZipBackupError", zfe, zipName);
        }
    }

    void write() throws BackupException {
    }
}

