/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.CopyConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.config.serverbeans.customvalidators.NotDuplicateTargetName;
import com.sun.enterprise.config.serverbeans.customvalidators.NotTargetKeyword;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Payload;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.DeletionDecorator;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
@NotDuplicateTargetName(message="{cluster.duplicate.name}", payload={Cluster.class})
public interface Cluster
extends ConfigBeanProxy,
Injectable,
PropertyBag,
Named,
SystemPropertyBag,
ReferenceContainer,
RefContainer,
Payload {
    @Override
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Override
    @NotTargetKeyword(message="{cluster.reserved.name}", payload={Cluster.class})
    @Pattern(regexp="[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_\\.;]*", message="{cluster.invalid.name}", payload={Cluster.class})
    public String getName();

    @Attribute
    @NotNull
    @Pattern(regexp="[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_\\.;]*")
    public String getConfigRef();

    @Param(name="config", optional=true)
    @I18n(value="generic.config")
    public void setConfigRef(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class, required=true)
    @NotNull
    public String getGmsEnabled();

    @Param(name="gmsenabled", optional=true)
    public void setGmsEnabled(String var1) throws PropertyVetoException;

    @Attribute
    @Min(value=2048L)
    @Max(value=32000L)
    @NotNull
    public String getGmsMulticastPort();

    @Param(name="multicastport", optional=true, alias="heartbeatport")
    public void setGmsMulticastPort(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getGmsMulticastAddress();

    @Param(name="multicastaddress", optional=true, alias="heartbeataddress")
    public void setGmsMulticastAddress(String var1) throws PropertyVetoException;

    @Attribute
    public String getGmsBindInterfaceAddress();

    @Param(name="bindaddress", optional=true)
    public void setGmsBindInterfaceAddress(String var1) throws PropertyVetoException;

    @Deprecated
    @Attribute
    public String getHeartbeatEnabled();

    @Deprecated
    public void setHeartbeatEnabled(String var1) throws PropertyVetoException;

    @Attribute
    @Deprecated
    public String getHeartbeatPort();

    @Deprecated
    public void setHeartbeatPort(String var1) throws PropertyVetoException;

    @Attribute
    @Deprecated
    public String getHeartbeatAddress();

    @Deprecated
    public void setHeartbeatAddress(String var1) throws PropertyVetoException;

    @Element
    public List<ServerRef> getServerRef();

    @Override
    @Element
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal system props")
    @Param(name="systemproperties", optional=true)
    public List<SystemProperty> getSystemProperty();

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Complete PropertyDesc for legal props")
    @PropertiesDesc(props={@PropertyDesc(name="GMS_LISTENER_PORT", defaultValue="9090", description="GMS listener port")})
    @Element
    @Param(name="properties", optional=true)
    public List<Property> getProperty();

    @Override
    @DuckTyped
    public String getReference();

    @DuckTyped
    public List<Server> getInstances();

    @DuckTyped
    public ServerRef getServerRefByRef(String var1);

    @Override
    @DuckTyped
    public boolean isCluster();

    @Override
    @DuckTyped
    public boolean isServer();

    @Override
    @DuckTyped
    public boolean isDas();

    @Override
    @DuckTyped
    public boolean isInstance();

    @DuckTyped
    public ApplicationRef getApplicationRef(String var1);

    @DuckTyped
    public ResourceRef getResourceRef(String var1);

    @DuckTyped
    public boolean isResourceRefExists(String var1);

    @DuckTyped
    public void createResourceRef(String var1, String var2) throws TransactionFailure;

    @DuckTyped
    public void deleteResourceRef(String var1) throws TransactionFailure;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class DeleteDecorator
    implements DeletionDecorator<Clusters, Cluster> {
        @Param(name="nodeagent", optional=true, obsolete=true)
        String nodeagent;
        @Param(name="autohadboverride", optional=true, obsolete=true)
        String autohadboverride;
        @Inject
        private Domain domain;
        @Inject
        Configs configs;
        @Inject
        private ServerEnvironment env;

        @Override
        public void decorate(AdminCommandContext context, Clusters parent, Cluster child) throws PropertyVetoException, TransactionFailure {
            Logger logger = LogDomains.getLogger(Cluster.class, "javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Cluster.class);
            ActionReport report = context.getActionReport();
            String instanceConfig = child.getConfigRef();
            Config config = this.configs.getConfigByName(instanceConfig);
            Transaction t = Transaction.getTransaction(parent);
            List<ServerRef> serverRefs = child.getServerRef();
            StringBuffer namesOfServers = new StringBuffer();
            if (serverRefs.size() > 0) {
                for (ServerRef serverRef : serverRefs) {
                    namesOfServers.append(new StringBuffer(serverRef.getRef()).append(','));
                }
                String msg = localStrings.getLocalString("Cluster.hasInstances", "Cluster {0} contains server instances {1} and must not contain any instances", child.getName(), namesOfServers.toString());
                logger.log(Level.SEVERE, msg);
                throw new TransactionFailure(msg);
            }
            if (config == null || this.domain.getReferenceContainersOf(config).size() > 1 || !instanceConfig.equals(child.getName() + "-config")) {
                return;
            }
            try {
                File configConfigDir = new File(this.env.getConfigDirPath(), config.getName());
                FileUtils.whack(configConfigDir);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (t != null) {
                    Configs c = t.enroll(this.configs);
                    List<Config> configList = c.getConfig();
                    configList.remove(config);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, localStrings.getLocalString("deleteConfigFailed", "Unable to remove config {0}", instanceConfig), ex);
                String msg = ex.getMessage() != null ? ex.getMessage() : localStrings.getLocalString("deleteConfigFailed", "Unable to remove config {0}", instanceConfig);
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(ex);
                throw ex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class Decorator
    implements CreationDecorator<Cluster> {
        @Param(name="config", optional=true)
        String configRef = null;
        @Param(optional=true, obsolete=true)
        String hosts = null;
        @Param(optional=true, obsolete=true)
        String haagentport;
        @Param(optional=true, obsolete=true)
        String haadminpassword = null;
        @Param(optional=true, obsolete=true)
        String haadminpasswordfile = null;
        @Param(optional=true, obsolete=true)
        String devicesize = null;
        @Param(optional=true, obsolete=true)
        String haproperty = null;
        @Param(optional=true, obsolete=true)
        String autohadb = null;
        @Param(optional=true, obsolete=true)
        String portbase = null;
        @Inject
        Habitat habitat;
        @Inject
        ServerEnvironment env;
        @Inject
        Domain domain;
        @Inject
        CommandRunner runner;

        @Override
        public void decorate(AdminCommandContext context, Cluster instance) throws TransactionFailure, PropertyVetoException {
            Logger logger = LogDomains.getLogger(Cluster.class, "javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Cluster.class);
            Transaction t = Transaction.getTransaction(instance);
            CopyConfig command = (CopyConfig)this.runner.getCommand("copy-config", context.getActionReport(), context.getLogger());
            if (command == null) {
                throw new TransactionFailure(localStrings.getLocalString("cannot.execute.command", "Cluster software is not installed"));
            }
            String instanceName = instance.getName();
            if (instance.getGmsBindInterfaceAddress() == null) {
                instance.setGmsBindInterfaceAddress(String.format("${GMS-BIND-INTERFACE-ADDRESS-%s}", instanceName));
            }
            if (instance.getGmsMulticastAddress() == null) {
                instance.setGmsMulticastAddress(this.generateHeartbeatAddress());
            }
            if (instance.getGmsMulticastPort() == null) {
                instance.setGmsMulticastPort(Integer.toString(this.generateHeartbeatPort()));
            }
            Property gmsListenerPort = instance.createChild(Property.class);
            gmsListenerPort.setName("GMS_LISTENER_PORT");
            gmsListenerPort.setValue(String.format("${GMS_LISTENER_PORT-%s}", instanceName));
            instance.getProperty().add(gmsListenerPort);
            if (this.configRef == null) {
                Config config = this.habitat.getComponent(Config.class, "default-config");
                if (config == null) {
                    config = this.habitat.getAllByContract(Config.class).iterator().next();
                    logger.warning(localStrings.getLocalString(Cluster.class, "Cluster.no_default_config_found", "No default config found, using config {0} as the default config for the cluster {1}", config.getName(), instance.getName()));
                }
                Configs configs = this.domain.getConfigs();
                Configs writableConfigs = t.enroll(configs);
                String configName = instance.getName() + "-config";
                instance.setConfigRef(configName);
                command.copyConfig(writableConfigs, config, configName, logger);
            } else {
                Config specifiedConfig = this.domain.getConfigs().getConfigByName(this.configRef);
                if (specifiedConfig == null) {
                    throw new TransactionFailure(localStrings.getLocalString("noSuchConfig", "Configuration {0} does not exist.", this.configRef));
                }
            }
            for (Resource resource : this.domain.getResources().getResources()) {
                if (!resource.getObjectType().equals("system-all") && !resource.getObjectType().equals("system-instance")) continue;
                String name = null;
                if (resource instanceof BindableResource) {
                    name = ((BindableResource)resource).getJndiName();
                }
                if (resource instanceof Named) {
                    name = ((Named)((Object)resource)).getName();
                }
                if (name == null) {
                    throw new TransactionFailure("Cannot add un-named resources to the new server instance");
                }
                ResourceRef newResourceRef = instance.createChild(ResourceRef.class);
                newResourceRef.setRef(name);
                instance.getResourceRef().add(newResourceRef);
            }
            for (Application application : this.domain.getApplications().getApplications()) {
                if (!application.getObjectType().equals("system-all") && !application.getObjectType().equals("system-instance")) continue;
                ApplicationRef newAppRef = instance.createChild(ApplicationRef.class);
                newAppRef.setRef(application.getName());
                instance.getApplicationRef().add(newAppRef);
            }
            if (this.hosts != null || this.haagentport != null || this.haadminpassword != null || this.haadminpasswordfile != null || this.devicesize != null || this.haproperty != null || this.autohadb != null || this.portbase != null) {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.WARNING);
                context.getActionReport().setMessage("Obsolete options used.");
            }
        }

        private int generateHeartbeatPort() {
            long MIN_GMS_MULTICAST_PORT = 2048L;
            long MAX_GMS_MULTICAST_PORT = 32000L;
            long portInterval = 29952L;
            return new Long(Math.round(Math.random() * (double)portInterval) + 2048L).intValue();
        }

        private String generateHeartbeatAddress() {
            int MAX_GMS_MULTICAST_ADDRESS_SUBRANGE = 255;
            StringBuffer heartbeatAddressBfr = new StringBuffer("228.9.");
            heartbeatAddressBfr.append(Math.round(Math.random() * 255.0)).append('.').append(Math.round(Math.random() * 255.0));
            return heartbeatAddressBfr.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Duck {
        public static boolean isCluster(Cluster me) {
            return true;
        }

        public static boolean isServer(Cluster me) {
            return false;
        }

        public static boolean isInstance(Cluster me) {
            return false;
        }

        public static boolean isDas(Cluster me) {
            return false;
        }

        public static String getReference(Cluster cluster) {
            return cluster.getConfigRef();
        }

        public static List<Server> getInstances(Cluster cluster) {
            Dom clusterDom = Dom.unwrap(cluster);
            Domain domain = clusterDom.getHabitat().getComponent(Domain.class);
            ArrayList<Server> instances = new ArrayList<Server>();
            for (ServerRef sRef : cluster.getServerRef()) {
                Server svr = domain.getServerNamed(sRef.getRef());
                if (svr == null) continue;
                instances.add(domain.getServerNamed(sRef.getRef()));
            }
            return instances;
        }

        public static ServerRef getServerRefByRef(Cluster c, String name) {
            for (ServerRef ref : c.getServerRef()) {
                if (!ref.getRef().equals(name)) continue;
                return ref;
            }
            return null;
        }

        public static ApplicationRef getApplicationRef(Cluster cluster, String appName) {
            for (ApplicationRef appRef : cluster.getApplicationRef()) {
                if (!appRef.getRef().equals(appName)) continue;
                return appRef;
            }
            return null;
        }

        public static ResourceRef getResourceRef(Cluster cluster, String refName) {
            for (ResourceRef ref : cluster.getResourceRef()) {
                if (!ref.getRef().equals(refName)) continue;
                return ref;
            }
            return null;
        }

        public static boolean isResourceRefExists(Cluster cluster, String refName) {
            return Duck.getResourceRef(cluster, refName) != null;
        }

        public static void deleteResourceRef(Cluster cluster, String refName) throws TransactionFailure {
            final ResourceRef ref = Duck.getResourceRef(cluster, refName);
            if (ref != null) {
                ConfigSupport.apply(new SingleConfigCode<Cluster>(){

                    @Override
                    public Object run(Cluster param) {
                        return param.getResourceRef().remove(ref);
                    }
                }, cluster);
            }
        }

        public static void createResourceRef(Cluster cluster, final String enabled, final String refName) throws TransactionFailure {
            ConfigSupport.apply(new SingleConfigCode<Cluster>(){

                @Override
                public Object run(Cluster param) throws PropertyVetoException, TransactionFailure {
                    ResourceRef newResourceRef = param.createChild(ResourceRef.class);
                    newResourceRef.setEnabled(enabled);
                    newResourceRef.setRef(refName);
                    param.getResourceRef().add(newResourceRef);
                    return newResourceRef;
                }
            }, cluster);
        }
    }
}

