/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.customvalidators.ResourcePoolReferenceConstraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePoolReferenceValidator
implements ConstraintValidator<ResourcePoolReferenceConstraint, BindableResource> {
    @Override
    public void initialize(ResourcePoolReferenceConstraint constraint) {
    }

    @Override
    public boolean isValid(BindableResource resource, ConstraintValidatorContext constraintValidatorContext) {
        Resources resources = (Resources)resource.getParent();
        if (resources.getParent() instanceof Domain || !(resources.getParent() instanceof Domain) && resources.getResources().size() > 0) {
            if (resource instanceof ConnectorResource) {
                ConnectorResource cr = (ConnectorResource)resource;
                return resources.getResourceByName(ConnectorConnectionPool.class, cr.getPoolName()) != null;
            }
            if (resource instanceof JdbcResource) {
                JdbcResource jr = (JdbcResource)resource;
                return resources.getResourceByName(JdbcConnectionPool.class, jr.getPoolName()) != null;
            }
        }
        return true;
    }
}

