/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.enterprise.connectors.work.WorkCoordinator;
import com.sun.enterprise.connectors.work.context.WorkContextHandler;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OneWork
implements Work {
    private final javax.resource.spi.work.Work work;
    private final WorkCoordinator coordinator;
    private long nqTime;
    private WorkContextHandler contextHandler;
    private static final Logger logger = LogDomains.getLogger(OneWork.class, "javax.enterprise.resource.resourceadapter");
    private StringManager localStrings = StringManager.getManager(OneWork.class);
    private String name = "Resource adapter work";
    private boolean nameSet = false;
    private ClassLoader tcc = null;

    OneWork(javax.resource.spi.work.Work work, WorkCoordinator coordinator, WorkContextHandler contextHandler, ClassLoader tcc) {
        this.work = work;
        this.coordinator = coordinator;
        this.contextHandler = contextHandler;
        this.tcc = tcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        ClassLoader callerCL = Thread.currentThread().getContextClassLoader();
        if (this.tcc != null && this.tcc != callerCL) {
            Thread.currentThread().setContextClassLoader(this.tcc);
        }
        try {
            this.coordinator.preInvoke();
            boolean timedOut = this.coordinator.isTimedOut();
            if (this.coordinator.proceed()) {
                try {
                    this.coordinator.setupContext(this);
                    this.log("Start of Work");
                }
                catch (Throwable e) {
                    this.coordinator.setException(e);
                }
            }
            if (this.coordinator.proceed()) {
                try {
                    this.work.run();
                    this.log("Work Executed");
                }
                catch (Throwable t) {
                    this.log("Execution has thrown exception " + t.getMessage());
                    this.coordinator.setException(t);
                }
            }
            if (!timedOut) {
                this.coordinator.postInvoke();
            }
            this.log("End of Work");
            Object var5_5 = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != callerCL) {
                Thread.currentThread().setContextClassLoader(callerCL);
            }
            this.tcc = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != callerCL) {
                Thread.currentThread().setContextClassLoader(callerCL);
            }
            this.tcc = null;
            throw throwable;
        }
    }

    public void log(String message) {
        if (this.nameSet) {
            Object[] args = new Object[]{this.name, message};
            String msg = this.localStrings.getString("log.work.hint", args);
            logger.log(Level.INFO, msg);
        }
    }

    public void setEnqueueTime(long tme) {
        this.nqTime = tme;
    }

    public long getEnqueueTime() {
        return this.nqTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.nameSet = true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.nameSet) {
            result.append("[Work : " + this.name + "] ");
        }
        result.append(this.work.toString());
        return result.toString();
    }
}

