/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiEnvironmentRefsGroupDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ManagedBeanVisitor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBeanDescriptor
extends JndiEnvironmentRefsGroupDescriptor {
    private String name;
    private String beanClassName;
    private BundleDescriptor enclosingBundle;
    private Object interceptorBuilder = null;
    private Collection beanInstances = new HashSet();
    private Map<Object, Object> beanSupportingInfo = new HashMap<Object, Object>();
    private List<InterceptorDescriptor> classInterceptorChain = new LinkedList<InterceptorDescriptor>();
    private Set<LifecycleCallbackDescriptor> aroundInvokeDescs = new HashSet<LifecycleCallbackDescriptor>();
    private Map<MethodDescriptor, List<InterceptorDescriptor>> methodInterceptorsMap = new HashMap<MethodDescriptor, List<InterceptorDescriptor>>();

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public void setBeanClassName(String className) {
        this.beanClassName = className;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public void setBundle(BundleDescriptor bundle) {
        this.enclosingBundle = bundle;
        super.setBundleDescriptor(bundle);
    }

    public BundleDescriptor getBundle() {
        return this.enclosingBundle;
    }

    public void setInterceptorBuilder(Object b) {
        this.interceptorBuilder = b;
    }

    public Object getInterceptorBuilder() {
        return this.interceptorBuilder;
    }

    public boolean hasInterceptorBuilder() {
        return this.interceptorBuilder != null;
    }

    public void addBeanInstanceInfo(Object o) {
        this.addBeanInstanceInfo(o, null);
    }

    public void addBeanInstanceInfo(Object o, Object supportingInfo) {
        this.beanInstances.add(o);
        if (supportingInfo != null) {
            this.beanSupportingInfo.put(o, supportingInfo);
        }
    }

    public Collection getBeanInstances() {
        return new HashSet(this.beanInstances);
    }

    public Object getSupportingInfoForBeanInstance(Object o) {
        return this.beanSupportingInfo.get(o);
    }

    public void clearBeanInstanceInfo(Object beanInstance) {
        this.beanInstances.remove(beanInstance);
        this.beanSupportingInfo.remove(beanInstance);
    }

    public void clearAllBeanInstanceInfo() {
        this.beanInstances.clear();
        this.beanSupportingInfo.clear();
        this.interceptorBuilder = null;
    }

    public Set<String> getAllInterceptorClasses() {
        HashSet<String> classes = new HashSet<String>();
        for (InterceptorDescriptor interceptorDescriptor : this.classInterceptorChain) {
            classes.add(interceptorDescriptor.getInterceptorClassName());
        }
        for (List list : this.methodInterceptorsMap.values()) {
            for (Object o : list) {
                InterceptorDescriptor interceptor = (InterceptorDescriptor)o;
                classes.add(interceptor.getInterceptorClassName());
            }
        }
        return classes;
    }

    public void setClassInterceptorChain(List<InterceptorDescriptor> chain) {
        this.classInterceptorChain = new LinkedList<InterceptorDescriptor>(chain);
    }

    public void setMethodLevelInterceptorChain(MethodDescriptor m, List<InterceptorDescriptor> chain) {
        this.methodInterceptorsMap.put(m, chain);
    }

    public List<InterceptorDescriptor> getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType type2) {
        LinkedList<InterceptorDescriptor> callbackInterceptors = new LinkedList<InterceptorDescriptor>();
        for (InterceptorDescriptor next : this.classInterceptorChain) {
            if (next.getCallbackDescriptors(type2).size() <= 0) continue;
            callbackInterceptors.add(next);
        }
        if (this.hasCallbackDescriptor(type2)) {
            InterceptorDescriptor beanClassCallbackInfo = new InterceptorDescriptor();
            beanClassCallbackInfo.setFromBeanClass(true);
            beanClassCallbackInfo.addCallbackDescriptors(type2, this.getCallbackDescriptors(type2));
            beanClassCallbackInfo.setInterceptorClassName(this.getBeanClassName());
            callbackInterceptors.add(beanClassCallbackInfo);
        }
        return callbackInterceptors;
    }

    public Set<LifecycleCallbackDescriptor> getAroundInvokeDescriptors() {
        return this.aroundInvokeDescs;
    }

    public void addAroundInvokeDescriptor(LifecycleCallbackDescriptor aroundInvokeDesc) {
        String className = aroundInvokeDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getAroundInvokeDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getAroundInvokeDescriptors().add(aroundInvokeDesc);
        }
    }

    public LifecycleCallbackDescriptor getAroundInvokeDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getAroundInvokeDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public boolean hasAroundInvokeMethod() {
        return this.getAroundInvokeDescriptors().size() > 0;
    }

    public List<InterceptorDescriptor> getAroundInvokeInterceptors(Method m) {
        MethodDescriptor mDesc = new MethodDescriptor(m);
        List<InterceptorDescriptor> aroundInvokeInterceptors = this.methodInterceptorsMap.get(mDesc);
        if (aroundInvokeInterceptors == null) {
            aroundInvokeInterceptors = new LinkedList<InterceptorDescriptor>();
            for (InterceptorDescriptor desc : this.classInterceptorChain) {
                if (!desc.hasAroundInvokeDescriptor()) continue;
                aroundInvokeInterceptors.add(desc);
            }
        }
        if (this.hasAroundInvokeMethod()) {
            EjbInterceptor interceptorInfo = new EjbInterceptor();
            interceptorInfo.setFromBeanClass(true);
            interceptorInfo.addAroundInvokeDescriptors(this.getAroundInvokeDescriptors());
            interceptorInfo.setInterceptorClassName(this.beanClassName);
            aroundInvokeInterceptors.add(interceptorInfo);
        }
        return aroundInvokeInterceptors;
    }

    public String getGlobalJndiName() {
        String appName = null;
        Application app = this.enclosingBundle.getApplication();
        if (!app.isVirtual()) {
            appName = this.enclosingBundle.getApplication().getAppName();
        }
        String modName = this.enclosingBundle.getModuleDescriptor().getModuleName();
        StringBuffer javaGlobalPrefix = new StringBuffer("java:global/");
        if (appName != null) {
            javaGlobalPrefix.append(appName);
            javaGlobalPrefix.append("/");
        }
        javaGlobalPrefix.append(modName);
        javaGlobalPrefix.append("/");
        String componentName = this.isNamed() ? this.name : "___internal_managed_bean_" + this.beanClassName;
        javaGlobalPrefix.append(componentName);
        return javaGlobalPrefix.toString();
    }

    public String getAppJndiName() {
        String modName = this.enclosingBundle.getModuleDescriptor().getModuleName();
        StringBuffer javaAppPrefix = new StringBuffer("java:app/");
        javaAppPrefix.append(modName);
        javaAppPrefix.append("/");
        String componentName = this.isNamed() ? this.name : "___internal_managed_bean_" + this.beanClassName;
        javaAppPrefix.append(componentName);
        return javaAppPrefix.toString();
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
    }

    public void validate() {
        this.visit(new ApplicationValidator());
    }

    public void visit(ManagedBeanVisitor aVisitor) {
        aVisitor.accept(this);
        for (EjbReference aRef : this.getEjbReferenceDescriptors()) {
            aVisitor.accept(aRef);
        }
        for (EnvironmentProperty envProp : this.getEnvironmentProperties()) {
            aVisitor.accept(envProp);
        }
        for (Object next : this.getResourceReferenceDescriptors()) {
            aVisitor.accept((ResourceReferenceDescriptor)next);
        }
        for (Object next : this.getJmsDestinationReferenceDescriptors()) {
            aVisitor.accept((JmsDestinationReferenceDescriptor)next);
        }
        for (Object next : this.getMessageDestinationReferenceDescriptors()) {
            aVisitor.accept((MessageDestinationReferencer)next);
        }
        Set serviceRefs = this.getServiceReferenceDescriptors();
        Iterator itr = serviceRefs.iterator();
        while (itr.hasNext()) {
            aVisitor.accept((ServiceReferenceDescriptor)itr.next());
        }
    }

    @Override
    public List<InjectionCapable> getInjectableResourcesByClass(String className) {
        LinkedList<EnvironmentProperty> injectables = new LinkedList<EnvironmentProperty>();
        for (EnvironmentProperty envEntry : this.getEnvironmentProperties()) {
            if (!envEntry.hasAValue()) continue;
            injectables.add(envEntry);
        }
        injectables.addAll(this.getEjbReferenceDescriptors());
        injectables.addAll(this.getServiceReferenceDescriptors());
        injectables.addAll(this.getResourceReferenceDescriptors());
        injectables.addAll(this.getJmsDestinationReferenceDescriptors());
        injectables.addAll(this.getMessageDestinationReferenceDescriptors());
        injectables.addAll(this.getEntityManagerFactoryReferenceDescriptors());
        injectables.addAll(this.getEntityManagerReferenceDescriptors());
        LinkedList<InjectionCapable> injectablesByClass = new LinkedList<InjectionCapable>();
        for (InjectionCapable injectionCapable : injectables) {
            if (!injectionCapable.isInjectable()) continue;
            for (InjectionTarget target : injectionCapable.getInjectionTargets()) {
                if (!target.getClassName().equals(className)) continue;
                injectablesByClass.add(injectionCapable);
            }
        }
        return injectablesByClass;
    }

    @Override
    public InjectionInfo getInjectionInfoByClass(Class clazz) {
        String className = clazz.getName();
        LifecycleCallbackDescriptor postConstructDesc = this.getPostConstructDescriptorByClass(className);
        String postConstructMethodName = postConstructDesc != null ? postConstructDesc.getLifecycleCallbackMethod() : null;
        LifecycleCallbackDescriptor preDestroyDesc = this.getPreDestroyDescriptorByClass(className);
        String preDestroyMethodName = preDestroyDesc != null ? preDestroyDesc.getLifecycleCallbackMethod() : null;
        InjectionInfo injectionInfo = new InjectionInfo(className, postConstructMethodName, preDestroyMethodName, this.getInjectableResourcesByClass(className));
        return injectionInfo;
    }

    @Override
    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getPostConstructDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    @Override
    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getPreDestroyDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }
}

