/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.ClassFile;
import com.sun.enterprise.deployment.annotation.introspection.ConstantPoolInfo;
import com.sun.enterprise.deployment.annotation.introspection.DefaultAnnotationScanner;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.logging.LogDomains;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.JavaEEScanner;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleScanner<T>
extends JavaEEScanner
implements Scanner<T>,
PostConstruct {
    private static final int DEFAULT_ENTRY_BUFFER_SIZE = 8192;
    @Inject
    DefaultAnnotationScanner defaultScanner;
    protected File archiveFile = null;
    protected ClassLoader classLoader = null;
    protected ClassFile classFile = null;
    protected Parser classParser = null;
    private Set<URI> scannedURI = new HashSet<URI>();
    private boolean processAllClasses = Boolean.getBoolean("com.sun.enterprise.deployment.annotation.processAllClasses");
    private Set<String> entries = new HashSet<String>();
    protected Logger logger = LogDomains.getLogger(DeploymentUtils.class, "javax.enterprise.system.tools.deployment");

    public void process(ReadableArchive archiveFile, T bundleDesc, ClassLoader classLoader, Parser parser) throws IOException {
        File file = new File(archiveFile.getURI());
        if (parser != null) {
            this.classParser = parser;
        } else {
            ParsingContext.Builder builder = new ParsingContext.Builder();
            builder.logger(this.logger);
            ParsingContext pc = builder.build();
            this.classParser = new Parser(pc);
        }
        this.process(file, bundleDesc, classLoader);
        this.completeProcess(bundleDesc, archiveFile);
        this.calculateResults();
    }

    protected void completeProcess(T bundleDescr, ReadableArchive archive) throws IOException {
        this.addLibraryJars(bundleDescr, archive);
    }

    protected void calculateResults() {
        try {
            this.classParser.awaitTermination();
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Annotation scanning interrupted", e);
            return;
        }
        Level logLevel = System.getProperty("glassfish.deployment.dump.scanning") != null ? Level.INFO : Level.FINE;
        boolean shouldLog = this.logger.isLoggable(logLevel);
        ParsingContext context = this.classParser.getContext();
        for (String annotation : this.defaultScanner.getAnnotations()) {
            Type type2 = context.getTypes().getBy(annotation);
            if (type2 == null) continue;
            if (type2 instanceof AnnotationType) {
                AnnotationType at = (AnnotationType)type2;
                for (AnnotatedElement ae : at.allAnnotatedTypes()) {
                    ExtensibleType<?> t = ae instanceof Member ? ((Member)((Object)ae)).getDeclaringType() : (ExtensibleType<?>)ae;
                    if (!t.wasDefinedIn(this.scannedURI)) continue;
                    if (shouldLog) {
                        this.logger.log(logLevel, "Adding " + t.getName() + " since " + ae.getName() + " is annotated with " + at.getName());
                    }
                    this.entries.add(t.getName());
                }
                continue;
            }
            if (type2 instanceof InterfaceModel) {
                InterfaceModel im = (InterfaceModel)type2;
                for (ClassModel cm : im.allImplementations()) {
                    if (shouldLog) {
                        this.logger.log(logLevel, "Adding " + cm.getName() + " since it is implementing " + im.getName());
                    }
                    this.entries.add(cm.getName());
                }
                continue;
            }
            this.logger.log(Level.SEVERE, "Inconsistent type definition, " + annotation + " is neither an annotation nor an interface");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Done with results");
        }
    }

    @Override
    public void postConstruct() {
        this.classFile = new ClassFile(new ConstantPoolInfo(this.defaultScanner));
    }

    protected void addScanClassName(String className) {
        if (className != null && className.length() != 0) {
            this.entries.add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addScanJar(File jarFile) throws IOException {
        block9: {
            try {
                if (!jarFile.exists()) {
                    return;
                }
                this.scannedURI.add(jarFile.toURI());
                if (this.processAllClasses) {
                    JarFile jf = null;
                    try {
                        jf = new JarFile(jarFile);
                        Enumeration<JarEntry> entriesEnum = jf.entries();
                        while (entriesEnum.hasMoreElements()) {
                            JarEntry je = entriesEnum.nextElement();
                            if (!je.getName().endsWith(".class")) continue;
                            this.addEntry(je);
                        }
                        break block9;
                    }
                    finally {
                        if (jf != null) {
                            jf.close();
                        }
                    }
                }
                this.classParser.parse(jarFile, null);
            }
            catch (ZipException ze) {
                this.logger.log(Level.WARNING, ze.getMessage() + ": file path: " + jarFile.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addScanURI(URI jarURI) {
        this.scannedURI.add(jarURI);
        ZipInputStream jis = null;
        try {
            JarEntry je;
            InputStream jarInputStream = jarURI.toURL().openStream();
            if (jarInputStream == null) {
                return;
            }
            jis = new JarInputStream(jarInputStream);
            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null) {
                int bytesRead;
                if (!je.getName().endsWith(".class")) continue;
                if (this.processAllClasses) {
                    this.addEntry(je);
                    continue;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[je.getSize() > -1L ? (int)je.getSize() : 8192];
                while ((bytesRead = jis.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                if (!this.classFile.containsAnnotation(baos.toByteArray())) continue;
                this.addEntry(je);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, ex.getMessage() + ": file path: " + jarURI.toASCIIString(), ex);
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, jarURI.toASCIIString(), ex);
                }
            }
        }
    }

    private void addEntry(JarEntry je) {
        String className = je.getName().replace('/', '.');
        className = className.substring(0, className.length() - 6);
        this.entries.add(className);
    }

    private void addEntry(File top, File f) {
        String fileName = f.getPath();
        fileName = fileName.substring(top.getPath().length() + 1);
        String className = fileName.replace(File.separatorChar, '.');
        className = className.substring(0, className.length() - 6);
        this.entries.add(className);
    }

    protected void addScanDirectory(File directory) throws IOException {
        this.scannedURI.add(directory.toURI());
        if (this.processAllClasses) {
            this.initScanDirectory(directory, directory);
        } else {
            this.classParser.parse(directory, null);
        }
    }

    private void initScanDirectory(File top, File directory) throws IOException {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isFile()) {
                String fileName = file.getPath();
                if (!fileName.endsWith(".class")) continue;
                this.addEntry(top, file);
                continue;
            }
            this.initScanDirectory(top, file);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Set<Class> getElements() {
        HashSet<Class> elements = new HashSet<Class>();
        if (this.getClassLoader() == null) {
            AnnotationUtils.getLogger().severe("Class loader null");
            return elements;
        }
        for (String className : this.entries) {
            if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
                AnnotationUtils.getLogger().fine("Getting " + className);
            }
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (NoClassDefFoundError err) {
                AnnotationUtils.getLogger().log(Level.WARNING, "Error in annotation processing: " + err);
            }
            catch (ClassNotFoundException cnfe) {
                AnnotationUtils.getLogger().log(Level.WARNING, "Cannot load " + className + " reason : " + cnfe.getMessage(), cnfe);
            }
        }
        return elements;
    }

    protected void addLibraryJars(T bundleDesc, ReadableArchive moduleArchive) throws IOException {
        List<Object> libraryURLs = new ArrayList();
        if (bundleDesc instanceof BundleDescriptor) {
            libraryURLs = DOLUtils.getLibraryJars((BundleDescriptor)bundleDesc, moduleArchive);
        }
        for (URL url : libraryURLs) {
            try {
                File libFile = new File(url.toURI());
                if (libFile.isFile()) {
                    this.addScanURI(libFile.toURI());
                    continue;
                }
                if (!libFile.isDirectory()) continue;
                this.addScanDirectory(libFile);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, ex.getMessage());
            }
        }
    }

    @Override
    public Types getTypes() {
        return this.classParser.getContext().getTypes();
    }
}

