/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.nonce;

import com.sun.enterprise.security.auth.nonce.Nonce;
import com.sun.enterprise.security.auth.nonce.NonceCache;
import com.sun.enterprise.security.auth.nonce.NonceManager;
import com.sun.logging.LogDomains;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultNonceManager
extends NonceManager {
    private static final boolean USE_DAEMON_THREAD = true;
    private static final Timer nonceCleanupTimer = new Timer(true);
    private NonceCache nonceCache = null;
    private static final Logger logger = LogDomains.getLogger(DefaultNonceManager.class, "javax.enterprise.system.core.security");

    public boolean validateNonce(Nonce nonce) throws NonceManager.NonceException {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String created = new GregorianCalendar(utc).getTime().toString();
        return this.validateNonce(nonce, created);
    }

    public boolean validateNonce(Nonce nonce, String created) throws NonceManager.NonceException {
        if (this.nonceCache == null || this.nonceCache != null && this.nonceCache.wasCanceled()) {
            this.initNonceCache(this.getMaxNonceAge());
        }
        if (!this.nonceCache.isScheduled()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "About to Store a new Nonce, but Reclaimer not Scheduled, so scheduling one" + this.nonceCache);
            }
            this.setNonceCacheCleanup();
        }
        return this.nonceCache.validateAndCacheNonce(nonce, created);
    }

    public boolean hasNonce(Nonce nonce) {
        if (this.nonceCache == null || this.nonceCache != null && this.nonceCache.wasCanceled()) {
            this.initNonceCache(this.getMaxNonceAge());
        }
        return this.nonceCache.hasNonce(nonce);
    }

    private synchronized void setNonceCacheCleanup() {
        if (!this.nonceCache.isScheduled()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Scheduling Nonce Reclaimer task...... for " + this + ":" + this.nonceCache);
            }
            nonceCleanupTimer.schedule((TimerTask)this.nonceCache, this.nonceCache.getMaxNonceAge(), this.nonceCache.getMaxNonceAge());
            this.nonceCache.scheduled(true);
        }
    }

    private synchronized void initNonceCache(long maxNonceAge) {
        if (this.nonceCache == null) {
            this.nonceCache = new NonceCache(maxNonceAge);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Creating NonceCache for first time....." + this.nonceCache);
            }
        } else if (this.nonceCache.wasCanceled()) {
            this.nonceCache = new NonceCache(maxNonceAge);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Re-creating NonceCache because it was canceled....." + this.nonceCache);
            }
        }
    }
}

