/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.pam;

import com.sun.appserv.security.AppservRealm;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;

@Service
public final class PamRealm
extends AppservRealm {
    public static final String AUTH_TYPE = "pam";
    private static final String PAM_SERVICE = "sshd";

    public synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String jaasCtx = props.getProperty("jaas-context");
        if (jaasCtx == null) {
            throw new BadRealmException("No jaas-context defined");
        }
        this.setProperty("jaas-context", jaasCtx);
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getGroupNames(String username) throws NoSuchUserException {
        try {
            Set<String> groupsSet = Collections.EMPTY_SET;
            groupsSet = new PAM(PAM_SERVICE).getGroupsOfUser(username);
            return Collections.enumeration(groupsSet);
        }
        catch (PAMException ex) {
            Logger.getLogger(PamRealm.class.getName()).log(Level.SEVERE, "pam_exception_getgroupsofuser", ex);
            return null;
        }
    }

    public String getPamService() {
        return PAM_SERVICE;
    }
}

