/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.types.Property;

@Service(name="change-admin-password")
@Scoped(value=PerLookup.class)
@I18n(value="change.admin.password")
@ExecuteOn(value={RuntimeType.DAS})
public class ChangeAdminPassword
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ChangeAdminPassword.class);
    @Param(name="password", password=true)
    private String oldpassword;
    @Param(name="newpassword", password=true)
    private String newpassword;
    @Param(name="username", primary=true)
    private String userName;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;
    @Inject
    private RealmsManager realmsManager;
    private static final String ADMIN_REALM = "admin-realm";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List<Config> configList = this.configs.getConfig();
        Config config = configList.get(0);
        SecurityService securityService = config.getSecurityService();
        AuthRealm fileAuthRealm = null;
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            if (!authRealm.getName().equals(ADMIN_REALM)) continue;
            fileAuthRealm = authRealm;
            break;
        }
        if (fileAuthRealm == null) {
            report.setMessage(localStrings.getLocalString("change.admin.password.adminrealmnotfound", "Server Error: There is no admin realm to perform this operation"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String fileRealmClassName = fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("change.admin.password.adminrealmnotsupported", "Configured admin realm is not supported."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("change.admin.password.keyfilenotfound", "There is no physical file associated with admin realm"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        FileRealm fr = null;
        try {
            this.realmsManager.createRealms(config);
            fr = (FileRealm)this.realmsManager.getFromLoadedRealms(config.getName(), fileAuthRealm.getName());
            if (fr == null) {
                throw new NoSuchRealmException(fileAuthRealm.getName());
            }
        }
        catch (NoSuchRealmException e) {
            report.setMessage(localStrings.getLocalString("change.admin.password.realmnotsupported", "Configured admin realm does not exist.") + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        try {
            Enumeration en = fr.getGroupNames(this.userName);
            int size = 0;
            while (en.hasMoreElements()) {
                ++size;
                en.nextElement();
            }
            String[] groups = new String[size];
            en = fr.getGroupNames(this.userName);
            for (int i = 0; i < size; ++i) {
                groups[i] = (String)en.nextElement();
            }
            fr.updateUser(this.userName, this.userName, this.newpassword.toCharArray(), groups);
            fr.writeKeyFile(keyFile);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("change.admin.password.userupdatefailed", "Password change failed for user named {0}", this.userName) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

