/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-auth-realms")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.auth.realm")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.CLUSTERED_INSTANCE})
public class ListAuthRealm
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListAuthRealm.class);
    @Param(name="target", primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;
    @Inject
    private RealmsManager realmsManager;

    public void execute(AdminCommandContext context) {
        Cluster cluster;
        Server targetServer;
        ActionReport report = context.getActionReport();
        Config tmp = null;
        try {
            tmp = this.configs.getConfigByName(this.target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            this.config = tmp;
        }
        if ((targetServer = this.domain.getServerNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        SecurityService securityService = this.config.getSecurityService();
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(authRealm.getName());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

