/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.grizzly.util.net.SSLSupport;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class GlassfishSSLSupport
implements SSLSupport {
    private static final Logger logger = LogDomains.getLogger(GlassfishSSLSupport.class, "javax.enterprise.system.core.security");
    private final SSLSocket socket;
    private final SSLEngine engine;
    private SSLSession session;

    public GlassfishSSLSupport(SSLSocket socket) {
        this.socket = socket;
        this.engine = null;
        this.session = socket.getSession();
    }

    public GlassfishSSLSupport(SSLEngine engine) {
        this.socket = null;
        this.engine = engine;
        if (engine != null) {
            this.session = engine.getSession();
        }
    }

    public String getCipherSuite() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getCipherSuite();
    }

    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    public Object[] getPeerCertificateChain(boolean force) throws IOException {
        if (this.session == null) {
            return null;
        }
        javax.security.cert.X509Certificate[] certs = null;
        certs = this.session.getPeerCertificateChain();
        if (certs == null) {
            certs = new javax.security.cert.X509Certificate[]{};
        }
        if (certs.length == 0 && force) {
            this.session.invalidate();
            this.handshake();
            this.session = this.socket == null ? this.engine.getSession() : this.socket.getSession();
        }
        return this.getX509Certs();
    }

    public Integer getKeySize() throws IOException {
        if (this.session == null) {
            return null;
        }
        Integer keySize = (Integer)this.session.getValue("javax.servlet.request.key_size");
        if (keySize == null) {
            int size = 0;
            String cipherSuite = this.session.getCipherSuite();
            for (int i = 0; i < ciphers.length; ++i) {
                if (cipherSuite.indexOf(GlassfishSSLSupport.ciphers[i].phrase) < 0) continue;
                size = GlassfishSSLSupport.ciphers[i].keySize;
                break;
            }
            keySize = size;
            this.session.putValue("javax.servlet.request.key_size", keySize);
        }
        return keySize;
    }

    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] sessionId = this.session.getId();
        if (sessionId == null) {
            return null;
        }
        StringBuilder Id2 = new StringBuilder();
        for (byte b : sessionId) {
            String digit = Integer.toHexString(b);
            if (digit.length() < 2) {
                Id2.append('0');
            } else if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            Id2.append(digit);
        }
        return Id2.toString();
    }

    private void handshake() throws IOException {
        this.socket.setNeedClientAuth(true);
        this.socket.startHandshake();
    }

    private Object[] getX509Certs() {
        javax.security.cert.X509Certificate[] certs = null;
        try {
            certs = this.session.getPeerCertificateChain();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (certs == null) {
            certs = new javax.security.cert.X509Certificate[]{};
        }
        Object[] x509Certs = new X509Certificate[certs.length];
        for (int i = 0; i < x509Certs.length; ++i) {
            try {
                byte[] buffer = certs[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINE, "Cert #{0} = {1}", new Object[]{i, x509Certs[i]});
                continue;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Error translating " + certs[i], ex);
                return null;
            }
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }
}

