/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.process.ProcessStreamDrainerWorker;

public class ProcessStreamDrainer {
    private final Process process;
    private final ProcessStreamDrainerWorker outWorker;
    private final ProcessStreamDrainerWorker errWorker;
    private final Thread errThread;
    private final Thread outThread;
    private final String processName;
    private final boolean redirectStandardStreams;
    private static final String ERROR_DRAINER = "StderrDrainer";
    private static final String OUT_DRAINER = "StdoutDrainer";

    public static ProcessStreamDrainer drain(String processName, Process process) {
        ProcessStreamDrainer psd = new ProcessStreamDrainer(processName, process, false, false);
        psd.drain();
        return psd;
    }

    public static ProcessStreamDrainer save(String processName, Process process) {
        ProcessStreamDrainer psd = new ProcessStreamDrainer(processName, process, false, true);
        psd.drain();
        return psd;
    }

    public static ProcessStreamDrainer redirect(String processName, Process process) {
        ProcessStreamDrainer psd = new ProcessStreamDrainer(processName, process, true, false);
        psd.drain();
        return psd;
    }

    public final void waitFor() throws InterruptedException {
        this.errThread.join();
        this.outThread.join();
    }

    public final String getOutString() {
        return this.outWorker.getString();
    }

    public final String getErrString() {
        return this.errWorker.getString();
    }

    public final String getOutErrString() {
        return this.outWorker.getString() + this.errWorker.getString();
    }

    private ProcessStreamDrainer(String processName, Process process, boolean redirect, boolean save) {
        if (process == null) {
            throw new NullPointerException("Internal Error: null Process object");
        }
        this.process = process;
        this.processName = processName == null || processName.length() <= 0 ? "UnknownProcessName" : processName;
        this.redirectStandardStreams = redirect;
        this.outWorker = this.redirectStandardStreams ? new ProcessStreamDrainerWorker(process.getInputStream(), System.out, save) : new ProcessStreamDrainerWorker(process.getInputStream(), null, save);
        this.outThread = new Thread((Runnable)this.outWorker, processName + "-" + OUT_DRAINER);
        this.outThread.setDaemon(true);
        this.errWorker = this.redirectStandardStreams ? new ProcessStreamDrainerWorker(process.getErrorStream(), System.err, save) : new ProcessStreamDrainerWorker(process.getErrorStream(), null, save);
        this.errThread = new Thread((Runnable)this.errWorker, processName + "-" + ERROR_DRAINER);
        this.errThread.setDaemon(true);
    }

    private void drain() {
        this.outThread.start();
        this.errThread.start();
    }
}

