/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="delete-instance")
@I18n(value="delete.instance")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class DeleteInstanceCommand
implements AdminCommand {
    private static final String NL = System.getProperty("line.separator");
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    private Servers servers;
    @Inject
    private Nodes nodes;
    @Param(name="instance_name", primary=true)
    private String instanceName;
    @Param(defaultValue="false")
    private boolean terse;
    private Server instance;
    private String noderef;
    private String nodedir;
    private Logger logger;
    private AdminCommandContext ctx;
    private String instanceHost;
    private Node theNode = null;
    private StringBuilder humanVersionOfCommand = new StringBuilder();

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.ctx = context;
        this.logger = context.logger;
        String msg = "";
        boolean fsfailure = false;
        boolean configfailure = false;
        this.instance = this.servers.getServer(this.instanceName);
        if (this.instance == null) {
            msg = Strings.get("start.instance.noSuchInstance", this.instanceName);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.instanceHost = this.instance.getAdminHost();
        if (this.instance.isRunning()) {
            msg = Strings.get("instance.shutdown", this.instanceName);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.noderef = this.instance.getNodeRef();
        if (!StringUtils.ok(this.noderef)) {
            msg = Strings.get("missingNodeRef", this.instanceName);
            fsfailure = true;
        } else {
            this.theNode = this.nodes.getNode(this.noderef);
            if (this.theNode == null) {
                msg = Strings.get("noSuchNode", this.noderef);
                fsfailure = true;
            }
        }
        if (!fsfailure) {
            this.nodedir = this.theNode.getNodeDirAbsolute();
            this.deleteInstanceFilesystem(context);
            report = context.getActionReport();
            if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                fsfailure = true;
            }
            msg = report.getMessage();
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_unregister-instance", report);
        ParameterMap map = new ParameterMap();
        map.add("DEFAULT", this.instanceName);
        ci.parameters(map);
        ci.execute();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS && report.getActionExitCode() != ActionReport.ExitCode.WARNING) {
            configfailure = true;
            msg = fsfailure ? msg + NL + report.getMessage() : report.getMessage();
        }
        if (configfailure && fsfailure) {
            msg = msg + NL + NL + Strings.get("delete.instance.failed", this.instanceName, this.instanceHost);
        } else if (configfailure && !fsfailure) {
            msg = msg + NL + NL + Strings.get("delete.instance.config.failed", this.instanceName, this.instanceHost);
        } else if (!configfailure && fsfailure) {
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        }
        if (configfailure) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
        }
    }

    public void deleteInstanceFilesystem(AdminCommandContext context) {
        NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
        Server dasServer = this.servers.getServer("server");
        String dasHost = dasServer.getAdminHost();
        String dasPort = Integer.toString(dasServer.getAdminPort());
        ArrayList<String> command = new ArrayList<String>();
        String humanCommand = null;
        command.add("_delete-instance-filesystem");
        if (this.nodedir != null) {
            command.add("--nodedir");
            command.add(this.nodedir);
        }
        command.add("--node");
        command.add(this.noderef);
        command.add(this.instanceName);
        humanCommand = this.makeCommandHuman(command);
        String firstErrorMessage = Strings.get("delete.instance.filesystem.failed", this.instanceName, this.noderef, this.theNode.getNodeHost());
        StringBuilder output = new StringBuilder();
        nodeUtils.runAdminCommandOnNode(this.theNode, command, this.ctx, firstErrorMessage, humanCommand, output);
        ActionReport report = this.ctx.getActionReport();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            return;
        }
        String msg = Strings.get("delete.instance.success", this.instanceName, this.theNode.getNodeHost());
        if (!this.terse) {
            msg = StringUtils.cat(NL, output.toString().trim(), msg);
        }
        report.setMessage(msg);
    }

    private String makeCommandHuman(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        fullCommand.append("asadmin ");
        for (String s : command) {
            if (s.equals("_delete-instance-filesystem")) {
                fullCommand.append(" ");
                fullCommand.append("delete-local-instance");
                continue;
            }
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

