/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.Date;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.gms.bootstrap.HealthHistory;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="get-health")
@I18n(value="get.health.command")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class GetHealthCommand
implements AdminCommand {
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment env;
    @Inject
    GMSAdapterService gmsAdapterService;
    @Param(optional=false, primary=true)
    @I18n(value="get.health.cluster.name")
    private String clusterName;
    private ActionReport report;
    private Logger logger;
    private GMSAdapter gmsAdapter;

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        this.logger.log(Level.INFO, Strings.get("get.health.called", this.clusterName));
        if (!this.checkEnvAndParams()) {
            return;
        }
        this.gmsAdapter = this.gmsAdapterService.getGMSAdapterByName(this.clusterName);
        if (this.gmsAdapter != null) {
            this.getHealthWithGMS();
        } else {
            this.setFail(Strings.get("get.health.noGMS", this.clusterName));
        }
    }

    private boolean checkEnvAndParams() {
        if (!this.env.isDas()) {
            return this.setFail(Strings.get("get.health.onlyRunsOnDas"));
        }
        Cluster cluster = this.domain.getClusterNamed(this.clusterName);
        if (cluster == null) {
            return this.setFail(Strings.get("get.health.noCluster", this.clusterName));
        }
        return true;
    }

    private void getHealthWithGMS() {
        StringBuilder result = new StringBuilder();
        HealthHistory history = this.gmsAdapter.getHealthHistory();
        if (history == null) {
            this.setFail(Strings.get("get.health.noHistoryError"));
            return;
        }
        if (history.getInstances().isEmpty()) {
            this.report.setMessage(Strings.get("get.health.no.instances", this.clusterName));
            return;
        }
        TreeSet<String> names = new TreeSet<String>(history.getInstances());
        for (String name : names) {
            HealthHistory.InstanceHealth ih = history.getHealthByInstance(name);
            if (-1L == ih.time) {
                result.append(Strings.get("get.health.instance.state", new Object[]{name, ih.state}));
            } else {
                result.append(Strings.get("get.health.instance.state.since", new Object[]{name, ih.state, new Date(ih.time).toString()}));
            }
            result.append("\n");
        }
        String rawResult = result.toString();
        this.report.setMessage(rawResult.substring(0, rawResult.lastIndexOf("\n")));
    }

    private boolean setFail(String message) {
        this.logger.log(Level.WARNING, message);
        this.report.setMessage(message);
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        return false;
    }
}

