/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="ping-node-ssh")
@I18n(value="ping.node.ssh")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
public class PingNodeSshCommand
implements AdminCommand {
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    private Nodes nodes;
    @Param(name="name", primary=true)
    private String name;
    @Param(optional=true, name="validate", alias="full", defaultValue="false")
    private boolean validate;
    private static final String NL = System.getProperty("line.separator");
    private Logger logger = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuilder msg = new StringBuilder();
        Node theNode = null;
        this.logger = context.getLogger();
        NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
        theNode = this.nodes.getNode(this.name);
        if (theNode == null) {
            String m = Strings.get("noSuchNode", this.name);
            this.logger.warning(m);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(m);
            return;
        }
        if (!NodeUtils.isSSHNode(theNode)) {
            String m = Strings.get("notSshNode", this.name);
            this.logger.warning(m);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(m);
            return;
        }
        try {
            String version = "";
            if (this.validate) {
                nodeUtils.validate(theNode);
                version = Strings.get("ping.glassfish.version", theNode.getInstallDir(), nodeUtils.getGlassFishVersionOnNode(theNode));
            } else {
                nodeUtils.pingSSHConnection(theNode);
            }
            String m1 = Strings.get("ping.node.success", this.name, theNode.getNodeHost());
            if (StringUtils.ok(version)) {
                m1 = m1 + NL + version;
            }
            report.setMessage(m1.toString());
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (CommandValidationException e) {
            String m1 = Strings.get("ping.node.failure", this.name, theNode.getNodeHost());
            msg.append(StringUtils.cat(NL, m1, e.getMessage()));
            report.setMessage(msg.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

