/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.common.ActionReporter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="plain")
@Scoped(value=PerLookup.class)
public class PlainTextActionReporter
extends ActionReporter {
    public static final String MAGIC = "PlainTextActionReporter";
    private PrintWriter writer;
    private static final String INDENT = "    ";
    private final StringBuilder sb = new StringBuilder();

    public void writeReport(OutputStream os) throws IOException {
        this.writer = new PrintWriter(os);
        this.writer.print(MAGIC);
        if (this.isFailure()) {
            this.writer.print("FAILURE");
            Throwable t = this.getFailureCause();
            if (t != null) {
                this.writer.print(t);
            }
        } else {
            this.writer.print("SUCCESS");
        }
        StringBuilder finalOutput = new StringBuilder();
        this.getCombinedMessages(this, finalOutput);
        String outs = finalOutput.toString();
        if (!StringUtils.ok(outs)) {
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PlainTextActionReporter.class);
            this.writer.print(localStrings.getLocalString("get.mon.no.data", "No monitoring data to report."));
            this.writer.print("\n");
        } else {
            this.writer.print(outs);
        }
        this.writer.flush();
    }

    public String getContentType() {
        return "text/plain";
    }

    public final void appendMessage(String s) {
        this.sb.append(s);
    }

    public final void appendMessageln(String s) {
        this.sb.append(s).append('\n');
    }

    public void setMessage(String message) {
        super.setMessage(message);
        this.sb.delete(0, this.sb.length());
        this.appendMessage(message);
    }

    public final String getMessage() {
        return this.sb.toString();
    }

    protected void getCombinedMessages(ActionReporter aReport, StringBuilder out) {
        PlainTextActionReporter ptr = null;
        try {
            ptr = (PlainTextActionReporter)aReport;
        }
        catch (Exception e) {
            throw new RuntimeException("Internal Error: Sub reports are different types than parent report.");
        }
        String s = ptr.getOutputData();
        if (StringUtils.ok(s)) {
            if (out.length() > 0) {
                out.append('\n');
            }
            out.append(s);
        }
        for (ActionReporter ar : aReport.subActions) {
            this.getCombinedMessages(ar, out);
        }
    }

    private String getOutputData() {
        if (this.superSimple(this.topMessage)) {
            return this.simpleGetOutputData();
        }
        return this.notSoSimpleGetOutputData();
    }

    private boolean superSimple(ActionReport.MessagePart part) {
        List<ActionReport.MessagePart> list = part.getChildren();
        Properties props = part.getProps();
        boolean hasChildren = list != null && !list.isEmpty();
        boolean hasProps = props != null && props.size() > 0;
        return !hasProps && !hasChildren;
    }

    private String simpleGetOutputData() {
        StringBuilder out = new StringBuilder();
        String tm = this.topMessage.getMessage();
        String body = this.sb.toString();
        if (StringUtils.ok(tm) && !StringUtils.ok(body)) {
            body = tm;
        }
        if (StringUtils.ok(body)) {
            out.append(body);
        }
        return out.toString();
    }

    private String notSoSimpleGetOutputData() {
        StringBuilder out = new StringBuilder();
        if (StringUtils.ok(this.actionDescription)) {
            out.append("Description: ").append(this.actionDescription);
        }
        this.write("", this.topMessage, out);
        return out.toString();
    }

    private void write(String indent, ActionReport.MessagePart part, StringBuilder out) {
        out.append(indent).append(part.getMessage()).append('\n');
        this.write(indent + INDENT, part.getProps(), out);
        for (ActionReport.MessagePart child : part.getChildren()) {
            this.write(indent + INDENT, child, out);
        }
    }

    private void write(String indent, Properties props, StringBuilder out) {
        if (props == null || props.size() <= 0) {
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = "" + entry.getKey();
            String val = "" + entry.getValue();
            out.append(indent).append('[').append(key).append('=').append(val).append("\n");
        }
    }
}

