/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.WebappLifecycleListener;
import java.util.Collections;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebListener
class ServletContextSensitiveSingletonStore<S>
implements ServletContextListener {
    private final String key;
    private final String keyForKey;
    private Map<String, Object> appMap;
    private static final String KEY_BASE = ServletContextSensitiveSingletonStore.class.getName();

    public ServletContextSensitiveSingletonStore(String singletonKey) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext extContext = facesContext.getExternalContext();
        if (null != facesContext) {
            this.appMap = extContext.getApplicationMap();
        } else {
            assert (false);
            this.appMap = Collections.emptyMap();
        }
        Object context = extContext.getContext();
        this.keyForKey = KEY_BASE + singletonKey;
        String candidateKey = (String)this.appMap.get(this.keyForKey);
        if (null == candidateKey) {
            this.key = singletonKey + context.hashCode();
            this.appMap.put(this.keyForKey, this.key);
        } else {
            this.key = candidateKey;
        }
    }

    static Object removeSingletonReference(ExternalContext extContext, String singletonKey) {
        Object result = null;
        Map<String, Object> map = extContext.getApplicationMap();
        String keyForKey = KEY_BASE + singletonKey;
        String keyVal = (String)map.get(keyForKey);
        result = map.remove(keyVal);
        map.remove(keyForKey);
        return result;
    }

    static void removeSingletonReference(ServletContext context, String singletonKey) {
        String keyForKey = KEY_BASE + singletonKey;
        String keyVal = (String)context.getAttribute(keyForKey);
        context.removeAttribute(keyVal);
        context.removeAttribute(keyForKey);
    }

    static Object getReferenceToSingleton(ExternalContext extContext, String singletonKey) {
        String keyForKey;
        Object result = null;
        Map<String, Object> map = extContext.getApplicationMap();
        String keyVal = (String)map.get(keyForKey = KEY_BASE + singletonKey);
        if (null != keyVal) {
            result = map.get(keyVal);
        }
        return result;
    }

    static Object getReferenceToSingleton(ServletContext context, String singletonKey) {
        Object result = null;
        String keyForKey = KEY_BASE + singletonKey;
        String keyVal = (String)context.getAttribute(keyForKey);
        if (null != keyVal) {
            result = context.getAttribute(keyVal);
        }
        return result;
    }

    void removeSingletonOnContextDestroyed() {
        ServletContext sc;
        WebappLifecycleListener listener;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext extContext = facesContext.getExternalContext();
        Object context = extContext.getContext();
        if (context instanceof ServletContext && null != (listener = WebappLifecycleListener.getInstance(sc = (ServletContext)context))) {
            listener.getAdditionalListeners().add(this);
        }
    }

    S getReferenceToSingleton() {
        Object result = this.appMap.get(this.key);
        return (S)result;
    }

    S removeSingletonReference() {
        Object result = null;
        if (null != this.appMap) {
            this.appMap.remove(this.keyForKey);
            result = this.appMap.remove(this.key);
        }
        return (S)result;
    }

    void putSingletonReference(S instance) {
        this.appMap.put(this.key, instance);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        this.removeSingletonReference();
        this.appMap = null;
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
    }
}

