/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.composite;

import com.sun.faces.application.view.FaceletViewHandlingStrategy;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.composite.CompositeComponentBeanInfo;
import com.sun.faces.facelets.tag.composite.PropertyHandler;
import com.sun.faces.facelets.tag.composite.PropertyHandlerManager;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;

public class InterfaceHandler
extends TagHandlerImpl {
    private final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private static final String[] ATTRIBUTES_DEV = new String[]{"displayName", "expert", "hidden", "preferred", "shortDescription", "name", "componentType"};
    private static final PropertyHandlerManager INTERFACE_HANDLERS = PropertyHandlerManager.getInstance(ATTRIBUTES_DEV);
    public static final String Name = "interface";

    public InterfaceHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        FacesContext context = ctx.getFacesContext();
        if (FaceletViewHandlingStrategy.isBuildingMetadata(context)) {
            this.imbueComponentWithMetadata(ctx, parent);
            this.nextHandler.apply(ctx, parent);
        } else if (ProjectStage.Development == context.getApplication().getProjectStage()) {
            this.validateComponent(context, parent);
        }
    }

    private void validateComponent(FacesContext context, UIComponent ccParent) throws TagException {
        String key;
        Object requiredValue;
        UIComponent cc = ccParent.getParent();
        if (null == cc) {
            String clientId = ccParent.getClientId(context);
            throw new TagException(this.tag, MessageUtils.getExceptionMessageString("com.sun.faces.COMPONENT_NOT_FOUND_ERROR", clientId + ".getParent()"));
        }
        Tag usingPageTag = ComponentSupport.getTagForComponent(context, cc);
        Map<String, Object> attrs = cc.getAttributes();
        BeanInfo componentMetadata = (BeanInfo)attrs.get("javax.faces.component.BEANINFO_KEY");
        if (null == componentMetadata) {
            String clientId = ccParent.getClientId(context);
            throw new TagException(usingPageTag, MessageUtils.getExceptionMessageString("com.sun.faces.MISSING_COMPONENT_METADATA", clientId));
        }
        PropertyDescriptor[] declaredAttributes = componentMetadata.getPropertyDescriptors();
        boolean found = false;
        boolean required = false;
        StringBuffer buf = null;
        String attrMessage = "";
        String facetMessage = "";
        for (PropertyDescriptor cur : declaredAttributes) {
            required = false;
            requiredValue = cur.getValue("required");
            if (null != requiredValue && requiredValue instanceof ValueExpression) {
                requiredValue = ((ValueExpression)requiredValue).getValue(context.getELContext());
                required = Boolean.parseBoolean(requiredValue.toString());
            }
            if (!required) continue;
            key = cur.getName();
            found = false;
            if (null != cur.getValue("method-signature") && null == cur.getValue("type")) {
                found = null != cc.getValueExpression(key);
            } else {
                found = attrs.containsKey(key);
                if (!found) {
                    Object obj = context.getApplication().evaluateExpressionGet(context, "#{cc.attrs." + key + "}", Object.class);
                    boolean bl = found = null != obj;
                }
            }
            if (found) continue;
            if (null == buf) {
                buf = new StringBuffer();
                buf.append(key);
                continue;
            }
            buf.append(", " + key);
        }
        if (null != buf) {
            attrMessage = MessageUtils.getExceptionMessageString("com.sun.faces.MISSING_COMPONENT_ATTRIBUTE_VALUE", buf.toString());
        }
        buf = null;
        Map declaredFacets = (Map)componentMetadata.getBeanDescriptor().getValue("javax.faces.component.FACETS_KEY");
        if (null != declaredFacets) {
            for (PropertyDescriptor cur : declaredFacets.values()) {
                required = false;
                requiredValue = cur.getValue("required");
                if (null != requiredValue && requiredValue instanceof ValueExpression) {
                    requiredValue = ((ValueExpression)requiredValue).getValue(context.getELContext());
                    required = Boolean.parseBoolean(requiredValue.toString());
                }
                if (!required) continue;
                key = cur.getName();
                if (cc.getFacets().containsKey(key)) continue;
                if (null == buf) {
                    buf = new StringBuffer();
                    buf.append(key);
                    continue;
                }
                buf.append(", " + key);
            }
        }
        if (null != buf) {
            facetMessage = MessageUtils.getExceptionMessageString("com.sun.faces.MISSING_COMPONENT_FACET", buf.toString());
        }
        if (0 < attrMessage.length() || 0 < facetMessage.length()) {
            throw new TagException(usingPageTag, attrMessage + " " + facetMessage);
        }
    }

    private void imbueComponentWithMetadata(FaceletContext ctx, UIComponent parent) {
        if (null == parent || null == (parent = parent.getParent()) || !ComponentHandler.isNew(parent)) {
            return;
        }
        Map<String, Object> attrs = parent.getAttributes();
        CompositeComponentBeanInfo componentBeanInfo = (CompositeComponentBeanInfo)attrs.get("javax.faces.component.BEANINFO_KEY");
        if (componentBeanInfo == null) {
            Resource componentResource;
            componentBeanInfo = new CompositeComponentBeanInfo();
            attrs.put("javax.faces.component.BEANINFO_KEY", componentBeanInfo);
            BeanDescriptor componentDescriptor = new BeanDescriptor(parent.getClass());
            componentBeanInfo.setBeanDescriptor(componentDescriptor);
            for (TagAttribute tagAttribute : this.tag.getAttributes().getAll()) {
                String attributeName = tagAttribute.getLocalName();
                PropertyHandler handler = INTERFACE_HANDLERS.getHandler(ctx, attributeName);
                if (handler == null) continue;
                handler.apply(ctx, attributeName, componentDescriptor, tagAttribute);
            }
            ArrayList targetList = (ArrayList)componentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            if (null == targetList) {
                targetList = new ArrayList();
                componentDescriptor.setValue("javax.faces.view.AttachedObjectTargets", targetList);
            }
            if (null == (componentResource = (Resource)attrs.get("javax.faces.application.Resource.ComponentResource"))) {
                throw new NullPointerException("Unable to find Resource for composite component");
            }
        }
    }
}

