/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.facelets.Facelet;
import com.sun.faces.facelets.FaceletFactory;
import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.tag.MetaRulesetImpl;
import com.sun.faces.facelets.tag.MetadataTargetImpl;
import com.sun.faces.facelets.tag.jsf.ActionSourceRule;
import com.sun.faces.facelets.tag.jsf.ComponentTagHandlerDelegateImpl;
import com.sun.faces.facelets.tag.jsf.EditableValueHolderRule;
import com.sun.faces.facelets.tag.jsf.RenderPropertyRule;
import com.sun.faces.facelets.tag.jsf.ValueHolderRule;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeComponentTagHandler
extends ComponentHandler
implements ComponentTagHandlerDelegateImpl.CreateComponentDelegate {
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private Resource ccResource;
    private UIComponent cc;
    private TagAttribute binding;

    CompositeComponentTagHandler(Resource ccResource, ComponentConfig config) {
        super(config);
        this.ccResource = ccResource;
        this.binding = config.getTag().getAttributes().get("binding");
        ((ComponentTagHandlerDelegateImpl)this.getTagHandlerDelegate()).setCreateCompositeComponentDelegate(this);
    }

    @Override
    public UIComponent createComponent(FaceletContext ctx) {
        FacesContext context = ctx.getFacesContext();
        if (this.binding != null) {
            ValueExpression ve = this.binding.getValueExpression(ctx, UIComponent.class);
            this.cc = (UIComponent)ve.getValue(ctx);
            if (this.cc != null && !UIComponent.isCompositeComponent(this.cc)) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.compcomp.binding.eval.non.compcomp", this.binding.toString());
                }
                this.cc = null;
            }
            if (this.cc == null) {
                this.cc = context.getApplication().createComponent(context, this.ccResource);
                ve.setValue(ctx, this.cc);
            }
        } else {
            this.cc = context.getApplication().createComponent(context, this.ccResource);
        }
        return this.cc;
    }

    @Override
    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        this.setAttributes(ctx, c);
        super.applyNextHandler(ctx, c);
        this.applyCompositeComponent(ctx, c);
        if (ComponentHandler.isNew(c)) {
            FacesContext context = ctx.getFacesContext();
            String viewId = context.getViewRoot().getViewId();
            ViewDeclarationLanguageFactory factory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory("javax.faces.view.ViewDeclarationLanguageFactory");
            ViewDeclarationLanguage vdl = factory.getViewDeclarationLanguage(viewId);
            vdl.retargetAttachedObjects(context, c, CompositeComponentTagHandler.getAttachedObjectHandlers(c, false));
            vdl.retargetMethodExpressions(context, c);
        }
    }

    @Override
    public void setCompositeComponent(UIComponent cc) {
        if (this.cc == null) {
            this.cc = cc;
        }
    }

    @Override
    public void setAttributes(FaceletContext ctx, Object instance) {
        if (instance != null) {
            if (ctx.getFacesContext().isProjectStage(ProjectStage.Development)) {
                Metadata meta = this.createMetaRuleset(instance.getClass()).finish();
                meta.applyMetadata(ctx, instance);
            } else {
                super.setAttributes(ctx, instance);
            }
        }
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type2) {
        Util.notNull("type", type2);
        CompositeComponentMetaRuleset m = new CompositeComponentMetaRuleset(this.getTag(), type2, (BeanInfo)this.cc.getAttributes().get("javax.faces.component.BEANINFO_KEY"));
        ((MetaRuleset)m).ignore("binding").ignore("id");
        ((MetaRuleset)m).addRule(CompositeComponentRule.Instance);
        if (ActionSource.class.isAssignableFrom(type2)) {
            ((MetaRuleset)m).addRule(ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type2)) {
            ((MetaRuleset)m).addRule(ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type2)) {
                ((MetaRuleset)m).ignore("submittedValue");
                ((MetaRuleset)m).ignore("valid");
                ((MetaRuleset)m).addRule(EditableValueHolderRule.Instance);
            }
        }
        if (UISelectOne.class.isAssignableFrom(type2) || UISelectMany.class.isAssignableFrom(type2)) {
            ((MetaRuleset)m).addRule(RenderPropertyRule.Instance);
        }
        return m;
    }

    public static List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component) {
        return CompositeComponentTagHandler.getAttachedObjectHandlers(component, true);
    }

    public static List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component, boolean create) {
        Map<String, Object> attrs = component.getAttributes();
        ArrayList result = (ArrayList)attrs.get("javax.faces.RetargetableHandlers");
        if (result == null) {
            if (create) {
                result = new ArrayList();
                attrs.put("javax.faces.RetargetableHandlers", result);
            } else {
                result = Collections.EMPTY_LIST;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCompositeComponent(FaceletContext ctx, UIComponent c) throws IOException {
        UIPanel facetComponent;
        FacesContext facesContext = ctx.getFacesContext();
        FaceletFactory factory = (FaceletFactory)RequestStateManager.get(facesContext, "com.sun.faces.FACELET_FACTORY");
        VariableMapper orig = ctx.getVariableMapper();
        if (ComponentHandler.isNew(c)) {
            facetComponent = (UIPanel)facesContext.getApplication().createComponent("javax.faces.Panel");
            facetComponent.setRendererType("javax.faces.Group");
            c.getFacets().put("javax.faces.component.COMPOSITE_FACET_NAME", facetComponent);
        } else {
            facetComponent = (UIPanel)c.getFacets().get("javax.faces.component.COMPOSITE_FACET_NAME");
        }
        assert (null != facetComponent);
        try {
            Facelet f = factory.getFacelet(this.ccResource.getURL());
            VariableMapperWrapper wrapper = new VariableMapperWrapper(orig){

                public ValueExpression resolveVariable(String variable) {
                    return super.resolveVariable(variable);
                }
            };
            ctx.setVariableMapper(wrapper);
            f.apply(facesContext, facetComponent);
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }

    private static class CompositeComponentRule
    extends MetaRule {
        private static final CompositeComponentRule Instance = new CompositeComponentRule();

        private CompositeComponentRule() {
        }

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(UIComponent.class)) {
                Class<Object> type2 = meta.getPropertyType(name);
                if (type2 == null) {
                    type2 = Object.class;
                }
                if (!attribute.isLiteral()) {
                    return new CompositeExpressionMetadata(name, type2, attribute);
                }
                return new LiteralAttributeMetadata(name, type2, attribute);
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class CompositeExpressionMetadata
        extends Metadata {
            private String name;
            private Class<?> type;
            private TagAttribute attr;

            public CompositeExpressionMetadata(String name, Class<?> type2, TagAttribute attr) {
                this.name = name;
                this.type = type2;
                this.attr = attr;
            }

            @Override
            public void applyMetadata(FaceletContext ctx, Object instance) {
                ValueExpression ve = this.attr.getValueExpression(ctx, this.type);
                UIComponent cc = (UIComponent)instance;
                assert (UIComponent.isCompositeComponent(cc));
                Map<String, Object> attrs = cc.getAttributes();
                BeanInfo componentMetadata = (BeanInfo)attrs.get("javax.faces.component.BEANINFO_KEY");
                BeanDescriptor desc = componentMetadata.getBeanDescriptor();
                Collection attributesWithDeclaredDefaultValues = (Collection)desc.getValue("javax.faces.component.ATTR_NAMES_WITH_DEFAULT_VALUES");
                if (null != attributesWithDeclaredDefaultValues && attributesWithDeclaredDefaultValues.contains(this.name)) {
                    attrs.remove(this.name);
                }
                cc.setValueExpression(this.name, ve);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class LiteralAttributeMetadata
        extends Metadata {
            private String name;
            private Class<?> type;
            private TagAttribute attribute;

            public LiteralAttributeMetadata(String name, Class<?> type2, TagAttribute attribute) {
                this.name = name;
                this.type = type2;
                this.attribute = attribute;
            }

            @Override
            public void applyMetadata(FaceletContext ctx, Object instance) {
                UIComponent c = (UIComponent)instance;
                c.getAttributes().put(this.name, this.attribute.getObject(ctx, this.type));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompositeComponentMetaRuleset
    extends MetaRulesetImpl {
        private BeanInfo compBeanInfo;
        private Class<?> type;

        public CompositeComponentMetaRuleset(Tag tag, Class<?> type2, BeanInfo compBeanInfo) {
            super(tag, type2);
            this.compBeanInfo = compBeanInfo;
            this.type = type2;
        }

        @Override
        protected MetadataTarget getMetadataTarget() {
            try {
                return new CompositeMetadataTarget(this.type, this.compBeanInfo);
            }
            catch (IntrospectionException ie) {
                throw new FacesException(ie);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class CompositeMetadataTarget
        extends MetadataTargetImpl {
            private BeanInfo compBeanInfo;

            public CompositeMetadataTarget(Class<?> type2, BeanInfo compBeanInfo) throws IntrospectionException {
                super(type2);
                this.compBeanInfo = compBeanInfo;
            }

            @Override
            public Class getPropertyType(String name) {
                PropertyDescriptor compDescriptor = this.findDescriptor(name);
                if (compDescriptor != null) {
                    ValueExpression typeVE = (ValueExpression)compDescriptor.getValue("type");
                    if (typeVE == null) {
                        return Object.class;
                    }
                    String className = (String)typeVE.getValue(FacesContext.getCurrentInstance().getELContext());
                    if (className != null) {
                        className = this.prefix(className);
                        try {
                            return ReflectionUtil.forName(className);
                        }
                        catch (ClassNotFoundException cnfe) {
                            throw new FacesException(cnfe);
                        }
                    }
                    return Object.class;
                }
                return super.getPropertyType(name);
            }

            private PropertyDescriptor findDescriptor(String name) {
                for (PropertyDescriptor pd : this.compBeanInfo.getPropertyDescriptors()) {
                    if (!pd.getName().equals(name)) continue;
                    return pd;
                }
                return null;
            }

            private String prefix(String className) {
                if (className.indexOf(46) == -1 && Character.isUpperCase(className.charAt(0))) {
                    return "java.lang." + className;
                }
                return className;
            }
        }
    }
}

