/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.monitoring;

import com.sun.gjc.util.SQLTrace;
import com.sun.gjc.util.SQLTraceCache;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.resource.common.PoolInfo;

@AMXMetadata(type="jdbcra-mon", group="monitoring")
@ManagedObject
@Description(value="JDBC RA Statistics")
public class JdbcStatsProvider {
    private StringStatisticImpl freqUsedSqlQueries = new StringStatisticImpl("FreqUsedSqlQueries", "List", "Most frequently used sql queries");
    private CountStatisticImpl numStatementCacheHit = new CountStatisticImpl("NumStatementCacheHit", "count", "The total number of Statement Cache hits.");
    private CountStatisticImpl numStatementCacheMiss = new CountStatisticImpl("NumStatementCacheMiss", "count", "The total number of Statement Cache misses.");
    private CountStatisticImpl numPotentialStatementLeak = new CountStatisticImpl("NumPotentialStatementLeak", "count", "The total number of potential Statement leaks");
    private String poolName;
    private PoolInfo poolInfo;
    private SQLTraceCache sqlTraceCache;

    public JdbcStatsProvider(String poolName, String appName, String moduleName, int sqlTraceCacheSize, long timeToKeepQueries) {
        this.poolName = poolName;
        this.poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (sqlTraceCacheSize > 0) {
            this.sqlTraceCache = new SQLTraceCache(poolName, appName, moduleName, sqlTraceCacheSize, timeToKeepQueries);
        }
    }

    @ProbeListener(value="glassfish:jdbcra:statementcache:statementCacheHitEvent")
    public void statementCacheHitEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        PoolInfo poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (this.poolInfo.equals(poolInfo)) {
            this.numStatementCacheHit.increment();
        }
    }

    @ProbeListener(value="glassfish:jdbcra:statementcache:statementCacheMissEvent")
    public void statementCacheMissEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        PoolInfo poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (this.poolInfo.equals(poolInfo)) {
            this.numStatementCacheMiss.increment();
        }
    }

    @ProbeListener(value="glassfish:jdbcra:sqltracing:traceSQLEvent")
    public void traceSQLEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName, @ProbeParam(value="sql") String sql) {
        PoolInfo poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (this.poolInfo.equals(poolInfo) && this.sqlTraceCache != null && sql != null) {
            SQLTrace cacheObj = new SQLTrace(sql, 1, System.currentTimeMillis());
            this.sqlTraceCache.checkAndUpdateCache(cacheObj);
        }
    }

    @ProbeListener(value="glassfish:jdbcra:statementleak:potentialStatementLeakEvent")
    public void potentialStatementLeakEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        PoolInfo poolInfo = new PoolInfo(poolName, appName, moduleName);
        if (this.poolInfo.equals(poolInfo)) {
            this.numPotentialStatementLeak.increment();
        }
    }

    @ManagedAttribute(id="numstatementcachehit")
    public CountStatistic getNumStatementCacheHit() {
        return this.numStatementCacheHit;
    }

    @ManagedAttribute(id="numstatementcachemiss")
    public CountStatistic getNumStatementCacheMiss() {
        return this.numStatementCacheMiss;
    }

    @ManagedAttribute(id="frequsedsqlqueries")
    public StringStatistic getfreqUsedSqlQueries() {
        if (this.sqlTraceCache != null) {
            this.freqUsedSqlQueries.setCurrent(this.sqlTraceCache.getTopQueries());
        }
        return this.freqUsedSqlQueries;
    }

    @ManagedAttribute(id="numpotentialstatementleak")
    public CountStatistic getNumPotentialStatementLeak() {
        return this.numPotentialStatementLeak;
    }

    public SQLTraceCache getSqlTraceCache() {
        return this.sqlTraceCache;
    }
}

