/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.ComplexSelectorHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorHandlerPool;
import com.sun.grizzly.Context;
import com.sun.grizzly.ControllerConfig;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultConnectorHandlerPool;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.Handler;
import com.sun.grizzly.Lifecycle;
import com.sun.grizzly.NIOContext;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ReadController;
import com.sun.grizzly.RoundRobinSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.SelectorHandlerRunner;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.Cloner;
import com.sun.grizzly.util.ConcurrentLinkedQueuePool;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.DataStructures;
import com.sun.grizzly.util.DefaultThreadPool;
import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.Grizzly;
import com.sun.grizzly.util.GrizzlyExecutorService;
import com.sun.grizzly.util.LogMessages;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.State;
import com.sun.grizzly.util.StateHolder;
import com.sun.grizzly.util.SupportStateHolder;
import com.sun.grizzly.util.ThreadPoolConfig;
import com.sun.grizzly.util.Utils;
import com.sun.grizzly.util.WorkerThreadFactory;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
implements Runnable,
Lifecycle,
Copyable,
ConnectorHandlerPool,
AttributeHolder,
SupportStateHolder<State> {
    private int maxAcceptRetries = 5;
    private boolean displayConfiguration = false;
    private volatile int requiredThreadsCount = DefaultThreadPool.DEFAULT_MIN_THREAD_COUNT;
    private ConcurrentLinkedQueuePool<NIOContext> contexts;
    protected ProtocolChainInstanceHandler instanceHandler;
    protected SelectionKeyHandler selectionKeyHandler;
    protected ComplexSelectorHandler multiReadThreadSelectorHandler = null;
    protected ConnectorHandlerPool connectorHandlerPool = null;
    protected final Queue<SelectorHandler> selectorHandlers = DataStructures.getCLQinstance(SelectorHandler.class);
    protected StateHolder<State> stateHolder;
    protected int readThreadsCount = -1;
    protected ReadController[] readThreadControllers;
    protected static Logger logger = Logger.getLogger("grizzly");
    protected ExecutorService threadPool;
    protected final Collection<ControllerStateListener> stateListeners = DataStructures.getCLQinstance(ControllerStateListener.class);
    protected AtomicInteger readySelectorHandlerCounter;
    protected AtomicInteger stoppedSelectorHandlerCounter;
    private boolean handleReadWriteConcurrently = true;
    protected Map<String, Object> attributes;
    private static final Queue<Controller> controllers = DataStructures.getCLQinstance(Controller.class);
    private ExecutorService kernelExecutor;
    static final boolean isLinux = "linux".equalsIgnoreCase(System.getProperty("os.name")) && !System.getProperty("java.version").startsWith("1.7");
    private boolean allowContextCaching = false;
    private boolean useLeaderFollowerStrategy = false;
    private boolean autoConfigure = false;
    private boolean executePendingIOUsingSelectorThread = false;
    private KernelExecutorFactory kernelExecutorFactory = new KernelExecutorFactory.DefaultFactory();

    public Controller() {
        new ControllerConfig().configure(this);
        this.contexts = new ConcurrentLinkedQueuePool<NIOContext>(){

            @Override
            public NIOContext newInstance() {
                return new NIOContext();
            }
        };
        this.stateHolder = new StateHolder(true);
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        if (this.instanceHandler == null) {
            this.instanceHandler = new DefaultProtocolChainInstanceHandler();
        }
        if (this.connectorHandlerPool == null) {
            this.connectorHandlerPool = new DefaultConnectorHandlerPool(this);
        }
        this.kernelExecutor = this.createKernelExecutor();
        controllers.add(this);
    }

    private void ensureAppropriatePoolSize(ExecutorService threadPool) {
        ThreadPoolExecutor jdkThreadPool;
        if (threadPool == null) {
            return;
        }
        if (threadPool instanceof GrizzlyExecutorService) {
            GrizzlyExecutorService grizzlyExecutorService = (GrizzlyExecutorService)threadPool;
            ThreadPoolConfig config = grizzlyExecutorService.getConfiguration();
            if (config.getCorePoolSize() < this.requiredThreadsCount) {
                if (config.getMaxPoolSize() < this.requiredThreadsCount) {
                    config.setMaxPoolSize(this.requiredThreadsCount);
                }
                config.setCorePoolSize(this.requiredThreadsCount);
                grizzlyExecutorService.reconfigure(config);
            }
        } else if (threadPool instanceof ExtendedThreadPool) {
            ExtendedThreadPool extendedThreadPool = (ExtendedThreadPool)threadPool;
            if (extendedThreadPool.getCorePoolSize() < this.requiredThreadsCount) {
                if (extendedThreadPool.getMaximumPoolSize() < this.requiredThreadsCount) {
                    extendedThreadPool.setMaximumPoolSize(this.requiredThreadsCount);
                }
                extendedThreadPool.setCorePoolSize(this.requiredThreadsCount);
            }
        } else if (threadPool instanceof ThreadPoolExecutor && (jdkThreadPool = (ThreadPoolExecutor)threadPool).getCorePoolSize() < this.requiredThreadsCount) {
            if (jdkThreadPool.getMaximumPoolSize() < this.requiredThreadsCount) {
                jdkThreadPool.setMaximumPoolSize(this.requiredThreadsCount);
            }
            jdkThreadPool.setCorePoolSize(this.requiredThreadsCount);
        }
    }

    private void autoConfigureCore() {
        if (this.autoConfigure && this.readThreadsCount == -1) {
            this.readThreadsCount = Runtime.getRuntime().availableProcessors();
            if (this.readThreadsCount > 0) {
                this.recalcRequiredThreadsCount();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Controller auto-configured with 2 ReadController based on underlying cores/processors, with a Thread Pool of required size " + this.requiredThreadsCount);
            }
        }
    }

    public void registerKey(SelectionKey key) {
        this.registerKey(key, 1);
    }

    public void registerKey(SelectionKey key, int ops) {
        this.registerKey(key, ops, this.selectorHandlers.peek().protocol());
    }

    public void registerKey(SelectionKey key, int ops, Protocol protocol) {
        if (this.stateHolder.getState() == State.STOPPED) {
            return;
        }
        this.getSelectorHandler(protocol).register(key, ops);
    }

    public void cancelKey(SelectionKey key) {
        if (this.stateHolder.getState() == State.STOPPED) {
            return;
        }
        SelectorHandler selectorHandler = this.getSelectorHandler(key.selector());
        if (selectorHandler == null) {
            throw new IllegalStateException("SelectionKey is not associated with known SelectorHandler");
        }
        selectorHandler.getSelectionKeyHandler().cancel(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context pollContext() {
        NIOContext ctx = null;
        try {
            if (!this.allowContextCaching) {
                Thread thread = Thread.currentThread();
                if (thread instanceof WorkerThreadImpl) {
                    ctx = (NIOContext)((WorkerThreadImpl)thread).getContext();
                    if (ctx != null) {
                        ((WorkerThreadImpl)thread).setContext(null);
                    } else {
                        ctx = new NIOContext();
                    }
                } else {
                    ctx = new NIOContext();
                }
            } else {
                ctx = this.contexts.poll();
            }
        }
        finally {
            ctx.setController(this);
        }
        return ctx;
    }

    public void configureContext(SelectionKey key, Context.OpType opType, NIOContext ctx, SelectorHandler selectorHandler) {
        ctx.setSelectorHandler(selectorHandler);
        ctx.setThreadPool(selectorHandler.getThreadPool());
        ctx.setAsyncQueueReader(selectorHandler.getAsyncQueueReader());
        ctx.setAsyncQueueWriter(selectorHandler.getAsyncQueueWriter());
        ctx.setSelectionKey(key);
        if (opType != null) {
            ctx.setCurrentOpType(opType);
        } else if (key != null) {
            ctx.configureOpType(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnContext(Context ctx) {
        if (ctx.decrementRefCount() > 0) {
            return;
        }
        if (!this.allowContextCaching) {
            WorkerThreadImpl wti;
            Thread thread = Thread.currentThread();
            if (thread instanceof WorkerThreadImpl && (wti = (WorkerThreadImpl)thread).getContext() == null) {
                ctx.recycle();
                wti.setContext(ctx);
            }
            return;
        }
        try {
            ctx.recycle();
        }
        finally {
            this.contexts.offer((NIOContext)ctx);
        }
    }

    public static Logger logger() {
        return logger;
    }

    public static void setLogger(Logger l) {
        logger = l;
        LoggerUtils.setLogger(l);
    }

    public void setProtocolChainInstanceHandler(ProtocolChainInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        return this.instanceHandler;
    }

    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
    }

    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    public void addSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandlers.add(selectorHandler);
        if (this.stateHolder.getState(false) != null && State.STOPPED != this.stateHolder.getState()) {
            this.addSelectorHandlerOnReadControllers(selectorHandler);
            if (this.readySelectorHandlerCounter != null) {
                this.readySelectorHandlerCounter.incrementAndGet();
            }
            if (this.stoppedSelectorHandlerCounter != null) {
                this.stoppedSelectorHandlerCounter.incrementAndGet();
            }
            this.startSelectorHandlerRunner(selectorHandler);
        }
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.addSelectorHandler(selectorHandler);
    }

    public SelectorHandler getSelectorHandler(Protocol protocol) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.protocol() != protocol) continue;
            return selectorHandler;
        }
        return null;
    }

    public SelectorHandler getSelectorHandler(Selector selector) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.getSelector() != selector) continue;
            return selectorHandler;
        }
        return null;
    }

    public Queue getSelectorHandlers() {
        return this.selectorHandlers;
    }

    public void removeSelectorHandler(SelectorHandler selectorHandler) {
        if (this.selectorHandlers.remove(selectorHandler)) {
            this.removeSelectorHandlerOnReadControllers(selectorHandler);
            selectorHandler.shutdown();
        }
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.ensureAppropriatePoolSize(threadPool);
        this.threadPool = threadPool;
    }

    public int getReadThreadsCount() {
        return this.readThreadsCount;
    }

    public void setReadThreadsCount(int readThreadsCount) {
        this.readThreadsCount = readThreadsCount;
        if (readThreadsCount > 0) {
            this.recalcRequiredThreadsCount();
        }
        this.ensureAppropriatePoolSize(this.threadPool);
    }

    public ConnectorHandlerPool getConnectorHandlerPool() {
        return this.connectorHandlerPool;
    }

    public void setConnectorHandlerPool(ConnectorHandlerPool connectorHandlerPool) {
        this.connectorHandlerPool = connectorHandlerPool;
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (IOException e) {
            this.notifyException(e);
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void copyTo(Copyable copy) {
        Controller copyController = (Controller)copy;
        copyController.contexts = this.contexts;
        copyController.attributes = this.attributes;
        copyController.instanceHandler = this.instanceHandler;
        copyController.threadPool = this.threadPool;
        copyController.readThreadControllers = this.readThreadControllers;
        copyController.readThreadsCount = this.readThreadsCount;
        copyController.selectionKeyHandler = this.selectionKeyHandler;
        copyController.stateHolder = this.stateHolder;
        copyController.executePendingIOUsingSelectorThread = this.executePendingIOUsingSelectorThread;
    }

    public void addStateListener(ControllerStateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public void removeStateListener(ControllerStateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    public void notifyStarted() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStarted();
        }
    }

    public void notifyReady() {
        if (this.readySelectorHandlerCounter.decrementAndGet() == 0) {
            for (ControllerStateListener stateListener : this.stateListeners) {
                stateListener.onReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStopped() {
        if (this.stoppedSelectorHandlerCounter.decrementAndGet() == 0) {
            AtomicInteger atomicInteger = this.stoppedSelectorHandlerCounter;
            synchronized (atomicInteger) {
                this.stoppedSelectorHandlerCounter.notifyAll();
            }
        }
    }

    public void notifyException(Throwable e) {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onException(e);
        }
    }

    public void logVersion() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(LogMessages.INFO_GRIZZLY_START(Grizzly.getRawVersion(), new Date()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.stateHolder.getStateLocker().writeLock().lock();
        try {
            if (this.isStarted()) {
                return;
            }
            this.logVersion();
            if (this.kernelExecutor.isShutdown()) {
                this.kernelExecutor = this.createKernelExecutor();
            }
            this.autoConfigureCore();
            if (this.threadPool == null) {
                this.threadPool = GrizzlyExecutorService.createInstance();
            }
            if (this.threadPool.isShutdown()) {
                this.threadPool = GrizzlyExecutorService.createInstance();
            }
            this.ensureAppropriatePoolSize(this.threadPool);
            State state = this.stateHolder.getState(false);
            if (state == null || state == State.STOPPED) {
                if (this.selectorHandlers.isEmpty()) {
                    TCPSelectorHandler selectorHandler = new TCPSelectorHandler();
                    this.selectorHandlers.add(selectorHandler);
                }
                if (this.readThreadsCount > 0) {
                    this.initReadThreads();
                    this.multiReadThreadSelectorHandler = new RoundRobinSelectorHandler(this.readThreadControllers);
                }
                this.stateHolder.setState(State.STARTED, false);
                this.notifyStarted();
                int selectorHandlerCount = this.selectorHandlers.size();
                this.readySelectorHandlerCounter = new AtomicInteger(selectorHandlerCount);
                this.stoppedSelectorHandlerCounter = new AtomicInteger(selectorHandlerCount);
                Iterator it = this.selectorHandlers.iterator();
                while (it.hasNext() && selectorHandlerCount-- > 0) {
                    SelectorHandler selectorHandler = (SelectorHandler)it.next();
                    if (selectorHandler instanceof TCPSelectorHandler) {
                        ((TCPSelectorHandler)selectorHandler).setExecutePendingIOUsingSelectorThread(this.executePendingIOUsingSelectorThread);
                        ((TCPSelectorHandler)selectorHandler).setMaxAcceptRetries(this.maxAcceptRetries);
                    }
                    this.startSelectorHandlerRunner(selectorHandler);
                }
            }
        }
        finally {
            this.stateHolder.getStateLocker().writeLock().unlock();
        }
        if (this.displayConfiguration) {
            this.displayConfiguration();
        }
        this.waitUntilSelectorHandlersStop();
        if (this.readThreadsCount > 0) {
            this.multiReadThreadSelectorHandler.shutdown();
            this.multiReadThreadSelectorHandler = null;
            for (ReadController readController : this.readThreadControllers) {
                try {
                    ((Controller)readController).stop();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Exception occured when stopping read Controller!", e);
                }
            }
            this.readThreadControllers = null;
        }
        this.selectorHandlers.clear();
        this.threadPool.shutdown();
        this.attributes = null;
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStopped();
        }
    }

    @Override
    public void stop() throws IOException {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean isAsync) throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.stateHolder.getStateLocker().writeLock().lock();
        try {
            State state = this.stateHolder.getState(false);
            if (state == null || state == State.STOPPED) {
                logger.log(Level.FINE, "Controller is already in stopped state");
                return;
            }
            if (!isAsync) {
                this.addStateListener(new ControllerStateListenerAdapter(){

                    public void onException(Throwable e) {
                        Controller.this.removeStateListener(this);
                        latch.countDown();
                    }

                    public void onStopped() {
                        Controller.this.removeStateListener(this);
                        latch.countDown();
                    }
                });
            }
            this.stateHolder.setState(State.STOPPED, false);
        }
        finally {
            this.stateHolder.getStateLocker().writeLock().unlock();
        }
        if (!isAsync) {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.kernelExecutor.shutdownNow();
    }

    @Override
    public void pause() throws IOException {
        this.stateHolder.setState(State.PAUSED);
    }

    @Override
    public void resume() throws IOException {
        if (State.PAUSED != this.stateHolder.getState(false)) {
            throw new IllegalStateException("Controller is not in PAUSED state, but: " + (Object)((Object)this.stateHolder.getState(false)));
        }
        this.stateHolder.setState(State.STARTED);
    }

    @Override
    public StateHolder<State> getStateHolder() {
        return this.stateHolder;
    }

    private void initReadThreads() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(2);
        }
        this.readThreadControllers = new ReadController[this.readThreadsCount];
        for (int i = 0; i < this.readThreadsCount; ++i) {
            ReadController controller = new ReadController();
            this.copyTo(controller);
            controller.setReadThreadsCount(0);
            this.readThreadControllers[i] = controller;
        }
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            this.addSelectorHandlerOnReadControllers(selectorHandler);
        }
        for (ReadController readThreadController : this.readThreadControllers) {
            this.kernelExecutor.execute(readThreadController);
        }
    }

    private void addSelectorHandlerOnReadControllers(SelectorHandler selectorHandler) {
        if (this.readThreadControllers == null || this.readThreadsCount == 0) {
            return;
        }
        if (selectorHandler.getAttributes() == null) {
            selectorHandler.setAttributes(new HashMap<String, Object>(2));
        }
        for (ReadController readController : this.readThreadControllers) {
            SelectorHandler copySelectorHandler = Cloner.clone(selectorHandler);
            try {
                copySelectorHandler.setSelector(Utils.openSelector());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error opening selector!", e);
            }
            readController.addSelectorHandler(copySelectorHandler);
        }
    }

    protected void startSelectorHandlerRunner(SelectorHandler selectorHandler) {
        if (selectorHandler.getThreadPool() == null) {
            selectorHandler.setThreadPool(this.threadPool);
        }
        SelectorHandlerRunner selectorRunner = new SelectorHandlerRunner(this, selectorHandler);
        if (selectorHandler.getSelector() != null) {
            this.notifyReady();
        }
        if (this.useLeaderFollowerStrategy) {
            this.threadPool.execute(selectorRunner);
        } else {
            this.kernelExecutor.execute(selectorRunner);
        }
    }

    private void removeSelectorHandlerOnReadControllers(SelectorHandler selectorHandler) {
        if (this.readThreadControllers == null) {
            return;
        }
        for (ReadController readController : this.readThreadControllers) {
            readController.removeSelectorHandlerClone(selectorHandler);
        }
    }

    public boolean isStarted() {
        return this.stateHolder.getState() == State.STARTED;
    }

    public ConnectorHandler acquireConnectorHandler(Protocol protocol) {
        return this.connectorHandlerPool.acquireConnectorHandler(protocol);
    }

    public void releaseConnectorHandler(ConnectorHandler connectorHandler) {
        this.connectorHandlerPool.releaseConnectorHandler(connectorHandler);
    }

    public boolean isHandleReadWriteConcurrently() {
        return this.handleReadWriteConcurrently;
    }

    public void setHandleReadWriteConcurrently(boolean handleReadWriteConcurrently) {
        this.handleReadWriteConcurrently = handleReadWriteConcurrently;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilSelectorHandlersStop() {
        AtomicInteger atomicInteger = this.stoppedSelectorHandlerCounter;
        synchronized (atomicInteger) {
            while (this.stoppedSelectorHandlerCounter.get() > 0 || !State.STOPPED.equals((Object)this.stateHolder.getState())) {
                try {
                    this.stoppedSelectorHandlerCounter.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public Object removeAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static Controller getHandlerController(Handler handler) {
        if (handler instanceof SelectorHandler) {
            for (Controller controller : controllers) {
                if (!controller.getSelectorHandlers().contains(handler)) continue;
                return controller;
            }
        }
        return null;
    }

    protected void executeUsingKernelExecutor() {
        this.kernelExecutor.submit(this);
    }

    public void executeUsingKernelExecutor(Runnable r) {
        this.kernelExecutor.execute(r);
    }

    protected ExecutorService createKernelExecutor() {
        return this.kernelExecutorFactory.create();
    }

    public boolean isAllowContextCaching() {
        return this.allowContextCaching;
    }

    public void setAllowContextCaching(boolean allowContextCaching) {
        this.allowContextCaching = allowContextCaching;
    }

    public boolean useLeaderFollowerStrategy() {
        return this.useLeaderFollowerStrategy;
    }

    public void useLeaderFollowerStrategy(boolean useLeaderFollowerStrategy) {
        this.useLeaderFollowerStrategy = useLeaderFollowerStrategy;
    }

    public boolean isAutoConfigure() {
        return this.autoConfigure;
    }

    public void setAutoConfigure(boolean autoConfigure) {
        this.autoConfigure = autoConfigure;
    }

    private void recalcRequiredThreadsCount() {
        int selectorHandlersCount = this.selectorHandlers.size();
        int clonesNumber = selectorHandlersCount > 0 ? selectorHandlersCount : 1;
        this.requiredThreadsCount = clonesNumber * (this.readThreadsCount + 1) * 2;
    }

    public boolean isExecutePendingIOUsingSelectorThread() {
        return this.executePendingIOUsingSelectorThread;
    }

    public void setExecutePendingIOUsingSelectorThread(boolean executePendingIOUsingSelectorThread) {
        this.executePendingIOUsingSelectorThread = executePendingIOUsingSelectorThread;
    }

    public KernelExecutorFactory getKernelExecutorFactory() {
        return this.kernelExecutorFactory;
    }

    public void setKernelExecutorFactory(KernelExecutorFactory kernelExecutorFactory) {
        this.kernelExecutorFactory = kernelExecutorFactory;
    }

    public void setMaxAcceptRetries(int maxAcceptRetries) {
        this.maxAcceptRetries = maxAcceptRetries;
    }

    public void setDisplayConfiguration(boolean displayConfiguration) {
        this.displayConfiguration = displayConfiguration;
    }

    private void displayConfiguration() {
        if (this.displayConfiguration) {
            String threadPoolResult = this.threadPool instanceof GrizzlyExecutorService ? ((GrizzlyExecutorService)this.threadPool).getConfiguration().toString() : this.threadPool.toString();
            logger.log(Level.INFO, LogMessages.INFO_GRIZZLY_CONFIGURATION(System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("java.version"), System.getProperty("java.vendor"), threadPoolResult, this.readThreadsCount, this.autoConfigure, this.useLeaderFollowerStrategy, this.selectorHandlers.size(), this.selectionKeyHandler, this.isAllowContextCaching(), this.maxAcceptRetries, this.handleReadWriteConcurrently, this.getProtocolChainInstanceHandler()));
        }
    }

    public static interface KernelExecutorFactory {
        public ExecutorService create();

        public static class DefaultFactory
        implements KernelExecutorFactory {
            public ExecutorService create() {
                return this.create("grizzly-kernel", "Grizzly-kernel-thread");
            }

            protected final ExecutorService create(String threadGroupName, final String threadNamePattern) {
                return Executors.newCachedThreadPool(new WorkerThreadFactory(threadGroupName){
                    private AtomicInteger counter;
                    {
                        super(x0);
                        this.counter = new AtomicInteger();
                    }

                    public Thread newThread(Runnable r) {
                        Thread newThread = super.newThread(r);
                        newThread.setName(threadNamePattern + "(" + this.counter.incrementAndGet() + ")");
                        return newThread;
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        UDP,
        TCP,
        TLS,
        CUSTOM;

    }
}

