/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.suspendable;

import com.sun.grizzly.Controller;
import com.sun.grizzly.suspendable.SuspendableFilter;
import com.sun.grizzly.util.DataStructures;
import com.sun.grizzly.util.Utils;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SuspendableMonitor
implements Runnable {
    private final Selector selector;
    private final Queue<SuspendableFilter.KeyHandler> keysToRegister = DataStructures.getCLQinstance(SuspendableFilter.KeyHandler.class);
    private final Logger logger = Controller.logger();

    public SuspendableMonitor() {
        Selector sel = null;
        try {
            sel = Utils.openSelector();
        }
        catch (IOException ex) {
            throw new RuntimeException("SuspendableMonitor.open()", ex);
        }
        this.selector = sel;
    }

    public void run() {
        while (true) {
            SelectionKey foreignKey = null;
            SuspendableFilter.KeyHandler kh = null;
            int selectorState = 0;
            try {
                try {
                    selectorState = this.selector.select(1000L);
                }
                catch (CancelledKeyException ex) {
                    // empty catch block
                }
                Iterator keys = this.keysToRegister.iterator();
                while (keys.hasNext()) {
                    kh = (SuspendableFilter.KeyHandler)keys.next();
                    SelectableChannel channel = kh.getKey().channel();
                    if (!kh.getKey().isValid() || !channel.isOpen()) continue;
                    foreignKey = channel.register(this.selector, 1, kh);
                    kh.setForeignKey(foreignKey);
                    keys.remove();
                }
                this.expireIdleKeys();
                if (selectorState > 0) continue;
                this.selector.selectedKeys().clear();
                continue;
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "SuspendableMonitor", t);
                try {
                    if (kh != null) {
                        try {
                            this.interrupted(kh.getKey());
                        }
                        catch (Throwable t2) {
                            this.logger.log(Level.SEVERE, "SuspendableMonitor", t2);
                        }
                    }
                    if (selectorState > 0) continue;
                    this.selector.selectedKeys().clear();
                    continue;
                }
                catch (Throwable t2) {
                    this.logger.log(Level.SEVERE, "SuspendableMonitor", t2);
                    continue;
                }
            }
            break;
        }
    }

    protected void expireIdleKeys() {
        Set<SelectionKey> readyKeys = this.selector.keys();
        if (readyKeys.isEmpty()) {
            return;
        }
        long current = System.currentTimeMillis();
        for (SelectionKey key : readyKeys) {
            SuspendableFilter.KeyHandler kh;
            block6: {
                kh = (SuspendableFilter.KeyHandler)key.attachment();
                if (kh == null) {
                    return;
                }
                long expire = kh.getRegistrationTime();
                if (expire == -1L || current - expire < kh.getSuspendableHandler().getExpireTime()) continue;
                kh.setRegistrationTime(-1L);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Expiring: " + key + " attachment: " + key.attachment());
                }
                try {
                    kh.getSuspendableHandler().getSuspendableHandler().expired(kh.getSuspendableHandler().getAttachment());
                }
                catch (Throwable t) {
                    if (!this.logger.isLoggable(Level.FINE) || kh == null) break block6;
                    this.logger.log(Level.FINE, "Interrupting: " + t);
                }
            }
            kh.getSuspendableHandler().getSuspendableFilter().resume(kh.getKey());
        }
    }

    protected void interrupted(SelectionKey key) {
        key.cancel();
        SuspendableFilter.KeyHandler kh = (SuspendableFilter.KeyHandler)key.attachment();
        kh.getSuspendableHandler().getSelectorHandler().getSelectionKeyHandler().cancel(kh.getKey());
        if (this.logger.isLoggable(Level.FINE) && kh != null) {
            this.logger.log(Level.FINE, "Interrupting: " + kh.getKey());
        }
        if (kh != null) {
            kh.getSuspendableHandler().getSuspendableHandler().interupted(kh.getSuspendableHandler().getAttachment());
            kh.getSuspendableHandler().getSuspendableFilter().suspendedKeys.remove(kh.getKey());
        }
    }

    protected void suspend(SuspendableFilter.KeyHandler kh) throws ClosedChannelException {
        try {
            kh.setRegistrationTime(System.currentTimeMillis());
            if (kh.getForeignKey() == null) {
                this.keysToRegister.offer(kh);
                this.selector.wakeup();
            }
        }
        catch (Throwable ex) {
            this.logger.log(Level.SEVERE, "suspend exception: " + kh.getKey(), ex);
        }
    }
}

