/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.tcp.PendingIOhandler;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class WorkerThreadImpl
extends WorkerThread {
    public static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    public static final ByteBufferFactory.ByteBufferType DEFAULT_BYTEBUFFER_TYPE = ByteBufferFactory.ByteBufferType.HEAP_VIEW;
    protected ThreadAttachment threadAttachment;
    private ByteBufferFactory.ByteBufferType byteBufferType = ByteBufferFactory.ByteBufferType.HEAP_VIEW;
    private int initialByteBufferSize;
    private PendingIOhandler pendingIOhandler;
    private Object context;

    public WorkerThreadImpl(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, 8192);
    }

    public WorkerThreadImpl(Runnable runnable) {
        this(null, "workerthread", runnable, 0);
    }

    public WorkerThreadImpl(String name, Runnable runnable) {
        this(null, name, runnable, 0);
    }

    public WorkerThreadImpl(ThreadGroup threadGroup, Runnable runnable, int initialByteBufferSize) {
        super(threadGroup, runnable);
        this.initialByteBufferSize = initialByteBufferSize;
    }

    public WorkerThreadImpl(ExecutorService threadPool, String name) {
        this(threadPool, name, 8192);
    }

    public WorkerThreadImpl(ExecutorService threadPool, String name, int initialByteBufferSize) {
        super(name);
        this.initialByteBufferSize = initialByteBufferSize;
    }

    public WorkerThreadImpl(ExecutorService threadPool, String name, Runnable runnable, int initialByteBufferSize) {
        super(runnable, name);
        this.initialByteBufferSize = initialByteBufferSize;
    }

    protected void createByteBuffer(boolean force) {
        if (force || this.byteBuffer == null) {
            this.byteBuffer = ByteBufferFactory.allocate(this.byteBufferType, this.initialByteBufferSize);
        }
    }

    public ThreadAttachment updateAttachment(int mode) {
        ThreadAttachment currentAttachment = this.getAttachment();
        currentAttachment.reset();
        if ((mode & ThreadAttachment.Mode.BYTE_BUFFER) != 0) {
            currentAttachment.setByteBuffer(this.byteBuffer);
        }
        if ((mode & ThreadAttachment.Mode.SSL_ENGINE) != 0) {
            currentAttachment.setSSLEngine(this.sslEngine);
        }
        if ((mode & ThreadAttachment.Mode.INPUT_BB) != 0) {
            currentAttachment.setInputBB(this.inputBB);
        }
        if ((mode & ThreadAttachment.Mode.OUTPUT_BB) != 0) {
            currentAttachment.setOutputBB(this.outputBB);
        }
        currentAttachment.setMode(mode);
        return currentAttachment;
    }

    public ThreadAttachment getAttachment() {
        if (this.threadAttachment == null) {
            this.threadAttachment = new ThreadAttachment();
            this.threadAttachment.associate();
        }
        return this.threadAttachment;
    }

    public ThreadAttachment detach() {
        ThreadAttachment currentAttachment = this.getAttachment();
        int mode = currentAttachment.getMode();
        this.updateAttachment(mode);
        if ((mode & ThreadAttachment.Mode.BYTE_BUFFER) != 0) {
            this.byteBuffer = null;
        }
        if ((mode & ThreadAttachment.Mode.SSL_ENGINE) != 0) {
            this.sslEngine = null;
        }
        if ((mode & ThreadAttachment.Mode.INPUT_BB) != 0) {
            this.inputBB = null;
        }
        if ((mode & ThreadAttachment.Mode.OUTPUT_BB) != 0) {
            this.outputBB = null;
        }
        this.threadAttachment = null;
        currentAttachment.deassociate();
        return currentAttachment;
    }

    public void attach(ThreadAttachment threadAttachment) {
        threadAttachment.associate();
        int mode = threadAttachment.getMode();
        if ((mode & ThreadAttachment.Mode.BYTE_BUFFER) != 0) {
            this.byteBuffer = threadAttachment.getByteBuffer();
        }
        if ((mode & ThreadAttachment.Mode.SSL_ENGINE) != 0) {
            this.sslEngine = threadAttachment.getSSLEngine();
        }
        if ((mode & ThreadAttachment.Mode.INPUT_BB) != 0) {
            this.inputBB = threadAttachment.getInputBB();
        }
        if ((mode & ThreadAttachment.Mode.OUTPUT_BB) != 0) {
            this.outputBB = threadAttachment.getOutputBB();
        }
        this.threadAttachment = threadAttachment;
    }

    public ByteBufferFactory.ByteBufferType getByteBufferType() {
        return this.byteBufferType;
    }

    public void setByteBufferType(ByteBufferFactory.ByteBufferType byteBufferType) {
        this.byteBufferType = byteBufferType;
    }

    public int getInitialByteBufferSize() {
        return this.initialByteBufferSize;
    }

    public void setInitialByteBufferSize(int initialByteBufferSize) {
        this.initialByteBufferSize = initialByteBufferSize;
    }

    protected void processTask(Callable t) throws Exception {
        if (t != null) {
            t.call();
        }
    }

    public PendingIOhandler getPendingIOhandler() {
        return this.pendingIOhandler;
    }

    public void setPendingIOhandler(PendingIOhandler pendingIOhandler) {
        this.pendingIOhandler = pendingIOhandler;
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public void reset() {
        if (this.threadAttachment != null) {
            this.threadAttachment.deassociate();
            this.threadAttachment = null;
        }
        super.reset();
    }
}

