/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.ClientNetworkHandler;
import com.sun.grizzly.websockets.WebSocketEngine;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class ClientWebSocket
extends BaseWebSocket {
    private static final Logger logger = Logger.getLogger("websocket");
    private final AtomicBoolean connecting = new AtomicBoolean(true);
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final URL address;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public ClientWebSocket(String url, WebSocketListener ... listeners) throws IOException {
        this(url, WebSocketEngine.DEFAULT_TIMEOUT, listeners);
    }

    public ClientWebSocket(String url, long timeout, WebSocketListener ... listeners) throws IOException {
        super(listeners);
        this.address = new URL(url);
        Future<?> future = this.executorService.submit(new Runnable(){

            public void run() {
                ClientWebSocket.this.networkHandler = ClientWebSocket.this.createNetworkHandler();
            }
        });
        try {
            future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public URL getAddress() {
        return this.address;
    }

    public void execute(Runnable runnable) {
        this.executorService.submit(runnable);
    }

    protected ClientNetworkHandler createNetworkHandler() {
        return new ClientNetworkHandler(this);
    }
}

