/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.InjectionResolver;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Creator;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantRequested;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.tracing.TracingThreadLocal;
import org.jvnet.hk2.tracing.TracingUtilities;

public abstract class AbstractCreatorImpl<T>
extends AbstractInhabitantImpl<T>
implements Creator<T> {
    private static final Logger logger = Logger.getLogger(AbstractCreatorImpl.class.getName());
    protected final Class<T> type;
    protected final Habitat habitat;
    private final MultiMap<String, String> metadata;

    public AbstractCreatorImpl(Class<T> type2, Habitat habitat, MultiMap<String, String> metadata) {
        this.type = type2;
        this.habitat = habitat;
        this.metadata = metadata;
    }

    @Override
    public final String typeName() {
        return this.type.getName();
    }

    @Override
    public final Class<T> type() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get(Inhabitant onBehalfOf) throws ComponentException {
        try {
            if (TracingUtilities.isEnabled()) {
                TracingThreadLocal.get().push(this);
            }
            Object o = this.create(onBehalfOf);
            logger.log(Level.FINER, "created object {0}", o);
            this.initialize(o, onBehalfOf);
            Object t = o;
            return t;
        }
        finally {
            if (TracingUtilities.isEnabled()) {
                TracingThreadLocal.get().pop();
            }
        }
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public void initialize(T t, Inhabitant onBehalfOf) throws ComponentException {
        if (t instanceof InhabitantRequested) {
            ((InhabitantRequested)t).setInhabitant(onBehalfOf);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public MultiMap<String, String> metadata() {
        return this.metadata;
    }

    protected void inject(Habitat habitat, T t, Inhabitant<?> onBehalfOf) {
        logger.log(Level.FINER, "injection starting on {0}", t);
        InjectionManager injectionMgr = this.createInjectionManager();
        Collection<InjectionResolver> targets = habitat.getAllByType(InjectionResolver.class);
        assert (!targets.isEmpty());
        injectionMgr.inject(t, onBehalfOf, targets.toArray(new InjectionResolver[targets.size()]));
        if (t instanceof PostConstruct) {
            logger.log(Level.FINER, "calling PostConstruct on {0}", t);
            ((PostConstruct)t).postConstruct();
        }
        logger.log(Level.FINER, "injection finished on {0}", t);
    }

    protected InjectionManager createInjectionManager() {
        return new InjectionManager();
    }
}

