/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import java.util.Iterator;

public final class KeyValuePairParser {
    private String str;
    private int idx;
    private String key;
    private String value;
    private final StringBuilder buf = new StringBuilder();

    public KeyValuePairParser() {
    }

    public KeyValuePairParser(String s) {
        this.set(s);
    }

    public void set(String str) {
        this.str = str;
        this.idx = 0;
    }

    public boolean hasNext() {
        return this.idx < this.str.length();
    }

    private int indexOf(char separator) {
        int i = this.str.indexOf(separator, this.idx + 1);
        if (i < 0) {
            return this.str.length();
        }
        return i;
    }

    private boolean isAt(char ch) {
        return this.idx < this.str.length() && this.str.charAt(this.idx) == ch;
    }

    private char current() {
        return this.str.charAt(this.idx);
    }

    public void parseNext() {
        int del = Math.min(this.indexOf('='), this.indexOf(','));
        this.key = this.str.substring(this.idx, del);
        this.value = null;
        this.idx = del;
        if (this.idx == this.str.length()) {
            return;
        }
        if (this.current() == ',') {
            ++this.idx;
            return;
        }
        assert (this.current() == '=');
        ++this.idx;
        if (this.isAt('\'') || this.isAt('\"')) {
            char quote = this.current();
            ++this.idx;
            this.buf.setLength(0);
            while (true) {
                if (this.isAt(quote)) {
                    this.value = this.buf.toString();
                    this.idx += 2;
                    return;
                }
                if (this.isAt('\\')) {
                    ++this.idx;
                }
                this.buf.append(this.current());
                ++this.idx;
            }
        }
        int end = this.indexOf(',');
        this.value = this.str.substring(this.idx, end);
        this.idx = end + 1;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void rewind() {
        this.idx = 0;
    }

    public String find(String key) {
        while (this.hasNext()) {
            this.parseNext();
            if (!this.getKey().equals(key)) continue;
            return this.getValue();
        }
        return null;
    }

    public Iterable<String> findAll(final String key) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                KeyValuePairParser.this.rewind();
                return new Iterator<String>(){
                    private String next;

                    private void fetch() {
                        if (this.next == null) {
                            this.next = KeyValuePairParser.this.find(key);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        this.fetch();
                        return this.next != null;
                    }

                    @Override
                    public String next() {
                        this.fetch();
                        String r = this.next;
                        this.next = null;
                        return r;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String getLine() {
        return this.str;
    }
}

