/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.spi.monitoring.glassfish;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.jersey.server.impl.uri.rules.ResourceClassRule;
import com.sun.jersey.server.impl.uri.rules.ResourceObjectRule;
import com.sun.jersey.server.impl.uri.rules.SubLocatorRule;
import com.sun.jersey.server.spi.monitoring.glassfish.ApplicationStatsProvider;
import com.sun.jersey.server.spi.monitoring.glassfish.probes.UriRuleProbeProvider;
import com.sun.jersey.server.spi.monitoring.glassfish.ruleevents.AbstractRuleEvent;
import com.sun.jersey.server.spi.monitoring.glassfish.ruleevents.DummyRuleEvent;
import com.sun.jersey.server.spi.monitoring.glassfish.ruleevents.ResourceClassRuleEvent;
import com.sun.jersey.server.spi.monitoring.glassfish.ruleevents.ResourceObjectRuleEvent;
import com.sun.jersey.server.spi.monitoring.glassfish.ruleevents.SubLocatorRuleEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.component.Habitat;

public class GlobalStatsProvider {
    private Map<String, ApplicationStatsProvider> applicationStatsProviders;
    private static GlobalStatsProvider INSTANCE = null;
    private boolean registered = false;
    private ThreadLocal<List<AbstractRuleEvent>> ruleEvents = new ThreadLocal<List<AbstractRuleEvent>>(){

        @Override
        protected List<AbstractRuleEvent> initialValue() {
            return new ArrayList<AbstractRuleEvent>();
        }
    };
    private ThreadLocal<ApplicationStatsProvider> currentApplicationStatProvider = new ThreadLocal();

    private GlobalStatsProvider() {
        this.applicationStatsProviders = new HashMap<String, ApplicationStatsProvider>();
    }

    public static synchronized GlobalStatsProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GlobalStatsProvider();
        }
        return INSTANCE;
    }

    public synchronized void register() {
        if (!this.registered) {
            StatsProviderManager.register("jersey", PluginPoint.SERVER, "", this);
            Logger.getLogger("Jersey-Monitoring").log(Level.INFO, "GlobalStatsProvider registered");
            this.registered = true;
        }
    }

    @ProbeListener(value="glassfish:jersey:server-hidden:requestStart")
    public void requestStart(@ProbeParam(value="requestUri") URI requestUri) {
        ApplicationStatsProvider applicationStatsProvider;
        UriRuleProbeProvider.requestStart(requestUri.toString());
        String applicationName = this.getApplicationName(requestUri.getPath());
        if (!this.applicationStatsProviders.containsKey(applicationName)) {
            applicationStatsProvider = new ApplicationStatsProvider(applicationName);
            this.applicationStatsProviders.put(applicationName, applicationStatsProvider);
            StatsProviderManager.register("jersey", PluginPoint.SERVER, "applications/" + applicationName + "/jersey/resources", applicationStatsProvider);
            Logger.getLogger("Jersey-Monitoring").log(Level.INFO, "ApplicationStatsProvider for application \"" + applicationName + "\" registered");
        } else {
            applicationStatsProvider = this.applicationStatsProviders.get(applicationName);
        }
        this.currentApplicationStatProvider.set(applicationStatsProvider);
    }

    private String getApplicationName(String path) {
        Habitat habitat = Globals.getDefaultHabitat();
        Domain domain = habitat.getInhabitantByType(Domain.class).get();
        List<Application> applicationList = domain.getApplications().getApplications();
        for (Application app : applicationList) {
            if (!path.startsWith(app.getContextRoot() + "/") && !path.equals(app.getContextRoot())) continue;
            return app.getName();
        }
        return null;
    }

    @ProbeListener(value="glassfish:jersey:server-hidden:ruleAccept")
    public void ruleAccept(@ProbeParam(value="ruleName") String ruleName, @ProbeParam(value="path") CharSequence path, @ProbeParam(value="resource") Object resource) {
        UriRuleProbeProvider.ruleAccept(ruleName, ((Object)path).toString(), resource == null ? "null" : resource.getClass().getName());
        AbstractRuleEvent ruleEvent = ruleName.equals(ResourceClassRule.class.getSimpleName()) ? new ResourceClassRuleEvent(ruleName, path, resource, this.ruleEvents.get()) : (ruleName.equals(SubLocatorRule.class.getSimpleName()) ? new SubLocatorRuleEvent(ruleName, path, resource, this.ruleEvents.get()) : (ruleName.equals(ResourceObjectRule.class.getSimpleName()) ? new ResourceObjectRuleEvent(ruleName, path, resource, this.ruleEvents.get()) : new DummyRuleEvent(ruleName, path, resource)));
        this.ruleEvents.get().add(ruleEvent);
    }

    @ProbeListener(value="glassfish:jersey:server-hidden:requestEnd")
    public void requestEnd() {
        for (AbstractRuleEvent ruleEvent : this.ruleEvents.get()) {
            ruleEvent.process(this.currentApplicationStatProvider.get());
        }
        this.ruleEvents.get().clear();
        UriRuleProbeProvider.requestEnd();
    }
}

