/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.spi.monitoring.glassfish;

import com.sun.jersey.server.spi.monitoring.glassfish.ResourceStatisticImpl;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="jersey-application-mon", group="monitoring")
@ManagedObject
public class ResourceStatsProvider {
    private ResourceStatisticImpl rootResourceClassHitCount;
    private ResourceStatisticImpl resourceClassHitCount;
    private final String resourceClassName;

    public ResourceStatsProvider(String resourceClassName) {
        this.resourceClassName = resourceClassName;
    }

    @ManagedAttribute(id="hitcount")
    public MapStatsImpl getHitCount() {
        HashMap<String, ResourceStatisticImpl> map = new HashMap<String, ResourceStatisticImpl>();
        if (this.rootResourceClassHitCount != null) {
            map.put("rootresource", this.rootResourceClassHitCount);
        }
        if (this.resourceClassHitCount != null) {
            map.put("resource", this.resourceClassHitCount);
        }
        return new MapStatsImpl(map);
    }

    public void rootResourceHit() {
        if (this.rootResourceClassHitCount == null) {
            this.rootResourceClassHitCount = new ResourceStatisticImpl("RootResourceHitCount", "count", "Root resource class hit count for " + this.resourceClassName, this.resourceClassName);
        }
        this.rootResourceClassHitCount.increment();
    }

    public void resourceHit() {
        if (this.resourceClassHitCount == null) {
            this.resourceClassHitCount = new ResourceStatisticImpl("ResourceHitCount", "count", "Resource class hit count for " + this.resourceClassName, this.resourceClassName);
        }
        this.resourceClassHitCount.increment();
    }

    @ManagedData
    public class MapStatsImpl
    implements Stats {
        private final Map<String, ResourceStatisticImpl> values;

        public MapStatsImpl(Map<String, ResourceStatisticImpl> values) {
            this.values = values;
        }

        @Override
        public Statistic getStatistic(String s) {
            return this.values.get(s);
        }

        @Override
        public String[] getStatisticNames() {
            return this.values.keySet().toArray(new String[this.values.keySet().size()]);
        }

        @ManagedAttribute
        public ResourceStatisticImpl[] getStatistics() {
            return this.values.values().toArray(new ResourceStatisticImpl[this.values.values().size()]);
        }
    }
}

