/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.logger.LoggerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.tomcat.util.modeler.Registry;
import org.glassfish.web.valve.GlassFishValve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerBase
implements Container,
Lifecycle,
Pipeline,
MBeanRegistration,
Serializable {
    private static java.util.logging.Logger log = java.util.logging.Logger.getLogger(ContainerBase.class.getName());
    protected Map<String, Container> children = new LinkedHashMap<String, Container>();
    protected int debug = 0;
    protected int backgroundProcessorDelay = -1;
    protected boolean checkIfRequestIsSecure = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected ArrayList<ContainerListener> listeners = new ArrayList();
    private ContainerListener[] listenersArray = new ContainerListener[0];
    protected Loader loader = null;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    protected Lock readLock = this.lock.readLock();
    protected Lock writeLock = this.lock.writeLock();
    protected Logger logger = null;
    protected Manager manager = null;
    protected String name = null;
    protected Container parent = null;
    protected ClassLoader parentClassLoader = null;
    protected Pipeline pipeline = new StandardPipeline(this);
    protected boolean hasCustomPipeline = false;
    protected Realm realm = null;
    protected DirContext resources = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean started = false;
    protected boolean initialized = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Thread thread = null;
    private volatile boolean threadDone = false;
    protected boolean notifyContainerListeners = true;
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected ObjectName controller;
    protected transient MBeanServer mserver;

    boolean isNotifyContainerListeners() {
        return this.notifyContainerListeners;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", (Object)oldDebug, (Object)this.debug);
    }

    @Override
    public int getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    @Override
    public String getInfo() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Loader getLoader() {
        try {
            this.readLock.lock();
            if (this.loader != null) {
                Loader loader = this.loader;
                return loader;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            return this.parent.getLoader();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoader(Loader loader) {
        Loader oldLoader;
        try {
            this.writeLock.lock();
            oldLoader = this.loader;
            if (oldLoader == loader) {
                return;
            }
            this.loader = loader;
            if (this.started && oldLoader != null && oldLoader instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldLoader)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "ContainerBase.setLoader: stop: ", e);
                }
            }
            if (loader != null) {
                loader.setContainer(this);
            }
            if (this.started && loader != null && loader instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)loader)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "ContainerBase.setLoader: start: ", e);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.support.firePropertyChange("loader", oldLoader, this.loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Logger getLogger() {
        try {
            this.readLock.lock();
            if (this.logger != null) {
                Logger logger = this.logger;
                return logger;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            return this.parent.getLogger();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLogger(Logger logger) {
        Logger oldLogger;
        try {
            this.writeLock.lock();
            oldLogger = this.logger;
            if (oldLogger == logger) {
                return;
            }
            this.logger = logger;
            if (this.started && oldLogger != null && oldLogger instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldLogger)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "ContainerBase.setLogger: stop: ", e);
                }
            }
            if (logger != null) {
                logger.setContainer(this);
            }
            if (this.started && logger != null && logger instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)logger)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "ContainerBase.setLogger: start: ", e);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.support.firePropertyChange("logger", oldLogger, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manager getManager() {
        try {
            this.readLock.lock();
            if (this.manager != null) {
                Manager manager = this.manager;
                return manager;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            return this.parent.getManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setManager(Manager manager) {
        Manager oldManager;
        try {
            this.writeLock.lock();
            oldManager = this.manager;
            if (oldManager == manager) {
                return;
            }
            this.manager = manager;
            if (this.started && oldManager != null && oldManager instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldManager)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "ContainerBase.setManager: stop: ", e);
                }
            }
            if (manager != null) {
                manager.setContainer(this);
            }
            if (this.started && manager != null && manager instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)manager)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "ContainerBase.setManager: start: ", e);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    @Override
    public Object getMappingObject() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Container container) {
        Container oldParent = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", oldParent, this.parent);
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public boolean hasCustomPipeline() {
        return this.hasCustomPipeline;
    }

    @Override
    public boolean isCheckIfRequestIsSecure() {
        return this.checkIfRequestIsSecure;
    }

    @Override
    public void setCheckIfRequestIsSecure(boolean checkIfRequestIsSecure) {
        this.checkIfRequestIsSecure = checkIfRequestIsSecure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Realm getRealm() {
        try {
            this.readLock.lock();
            if (this.realm != null) {
                Realm realm = this.realm;
                return realm;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            return this.parent.getRealm();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRealm(Realm realm) {
        Realm oldRealm;
        try {
            this.writeLock.lock();
            oldRealm = this.realm;
            if (oldRealm == realm) {
                return;
            }
            this.realm = realm;
            if (this.started && oldRealm != null && oldRealm instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldRealm)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "ContainerBase.setRealm: stop: ", e);
                }
            }
            if (realm != null) {
                realm.setContainer(this);
            }
            if (this.started && realm != null && realm instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)realm)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "ContainerBase.setRealm: start: ", e);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.support.firePropertyChange("realm", oldRealm, this.realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirContext getResources() {
        try {
            this.readLock.lock();
            if (this.resources != null) {
                DirContext dirContext = this.resources;
                return dirContext;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            return this.parent.getResources();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResources(DirContext resources) throws Exception {
        DirContext oldResources;
        try {
            this.writeLock.lock();
            oldResources = this.resources;
            if (oldResources == resources) {
                return;
            }
            Hashtable<String, String> env = new Hashtable<String, String>();
            if (this.getParent() != null) {
                env.put("host", this.getParent().getName());
            }
            env.put("context", this.getName());
            this.resources = new ProxyDirContext(env, resources);
        }
        finally {
            this.writeLock.unlock();
        }
        this.support.firePropertyChange("resources", oldResources, this.resources);
    }

    @Override
    public void addChild(Container child) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAddChild dp = new PrivilegedAddChild(child);
            AccessController.doPrivileged(dp);
        } else {
            this.addChildInternal(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildInternal(Container child) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Add child " + child + " " + this);
        }
        Map<String, Container> map = this.children;
        synchronized (map) {
            if (this.children.get(child.getName()) != null) {
                throw new IllegalArgumentException("addChild:  Child name '" + child.getName() + "' is not unique");
            }
            child.setParent(this);
            if (this.started && child instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)child)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "ContainerBase.addChild: start: ", e);
                    throw new IllegalStateException("ContainerBase.addChild: start: " + e);
                }
            }
            this.children.put(child.getName(), child);
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("addChild", child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContainerListener(ContainerListener listener) {
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
            this.listenersArray = this.listeners.toArray(new ContainerListener[this.listeners.size()]);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container findChild(String name) {
        if (name == null) {
            return null;
        }
        Map<String, Container> map = this.children;
        synchronized (map) {
            return this.children.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container[] findChildren() {
        Map<String, Container> map = this.children;
        synchronized (map) {
            return this.children.values().toArray(new Container[this.children.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerListener[] findContainerListeners() {
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listenersArray;
        }
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.pipeline.invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(Container child) {
        if (child == null) {
            return;
        }
        Map<String, Container> map = this.children;
        synchronized (map) {
            if (this.children.get(child.getName()) == null) {
                return;
            }
            this.children.remove(child.getName());
        }
        if (this.started && child instanceof Lifecycle) {
            try {
                if (child instanceof ContainerBase) {
                    if (((ContainerBase)child).started) {
                        ((Lifecycle)((Object)child)).stop();
                    }
                } else {
                    ((Lifecycle)((Object)child)).stop();
                }
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "ContainerBase.removeChild: stop: ", e);
            }
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeChild", child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContainerListener(ContainerListener listener) {
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
            this.listenersArray = this.listeners.toArray(new ContainerListener[this.listeners.size()]);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void removeLifecycleListeners() {
        this.lifecycle.removeLifecycleListeners();
    }

    @Override
    public synchronized void start() throws LifecycleException {
        LoggerBase lb;
        if (this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.info(sm.getString("containerBase.alreadyStarted", this.logName()));
            }
            return;
        }
        if (this.logger instanceof LoggerBase && (lb = (LoggerBase)this.logger).getObjectName() == null) {
            ObjectName lname = lb.createObjectName();
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.started = true;
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).start();
        }
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)((Object)this.logger)).start();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).start();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).start();
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).start();
        }
        this.startChildren();
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).start();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.threadStart();
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        LoggerBase lb;
        int i;
        if (!this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.info(sm.getString("containerBase.notStarted", this.logName()));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.threadStop();
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).stop();
        }
        Container[] children = this.findChildren();
        for (i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Lifecycle)) continue;
            try {
                ((Lifecycle)((Object)children[i])).stop();
                continue;
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, sm.getString("containerBase.errorStopping", children[i]), t);
            }
        }
        children = this.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.removeChild(children[i]);
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).stop();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).stop();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).stop();
        }
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)((Object)this.logger)).stop();
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).stop();
        }
        if (!(this.logger instanceof LoggerBase) || (lb = (LoggerBase)this.logger).getObjectName() != null) {
            // empty if block
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    public void init() throws Exception {
        ObjectName parentName;
        if (this.getParent() == null && (parentName = this.getParentName()) != null && this.mserver.isRegistered(parentName)) {
            this.mserver.invoke(parentName, "addChild", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
        }
        this.initialized = true;
    }

    public ObjectName getParentName() throws MalformedObjectNameException {
        return null;
    }

    public void destroy() throws Exception {
        Container[] children;
        if (this.started) {
            this.stop();
        }
        this.initialized = false;
        if (this.oname != null) {
            try {
                if (this.controller == this.oname) {
                    Registry.getRegistry(null, null).unregisterComponent(this.oname);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("unregistering " + this.oname);
                    }
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error unregistering ", t);
            }
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        for (Container aChildren : children = this.findChildren()) {
            this.removeChild(aChildren);
        }
        this.removeLifecycleListeners();
        this.setRealm(null);
    }

    @Override
    public synchronized void addValve(GlassFishValve valve) {
        this.pipeline.addValve(valve);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addValve", valve);
        }
    }

    @Override
    public synchronized void addValve(Valve valve) {
        this.pipeline.addValve(valve);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addValve", valve);
        }
    }

    public ObjectName[] getValveObjectNames() {
        return ((StandardPipeline)this.pipeline).getValveObjectNames();
    }

    @Override
    public GlassFishValve getBasic() {
        return this.pipeline.getBasic();
    }

    @Override
    public GlassFishValve[] getValves() {
        return this.pipeline.getValves();
    }

    @Override
    public boolean hasNonBasicValves() {
        return this.pipeline.hasNonBasicValves();
    }

    @Override
    public synchronized void removeValve(GlassFishValve valve) {
        this.pipeline.removeValve(valve);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeValve", valve);
        }
    }

    @Override
    public void setBasic(GlassFishValve valve) {
        this.pipeline.setBasic(valve);
    }

    @Override
    public void backgroundProcess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireContainerEvent(String type2, Object data) {
        ContainerListener[] list = null;
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.listeners.isEmpty()) {
                return;
            }
            list = this.listenersArray;
        }
        ContainerEvent event = new ContainerEvent(this, type2, data);
        for (int i = 0; i < list.length; ++i) {
            list[i].containerEvent(event);
        }
    }

    protected void startChildren() {
        Container[] children = this.findChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Lifecycle)) continue;
            try {
                ((Lifecycle)((Object)children[i])).start();
                continue;
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, sm.getString("containerBase.notStarted", children[i]), t);
                if (children[i] instanceof Context) {
                    ((Context)children[i]).setAvailable(false);
                    continue;
                }
                if (!(children[i] instanceof Wrapper)) continue;
                ((Wrapper)children[i]).setAvailable(Long.MAX_VALUE);
            }
        }
    }

    protected void log(String message) {
        log.info(message);
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(this.logName() + ": " + message, throwable);
        } else {
            log.log(Level.SEVERE, message, throwable);
        }
    }

    protected String logName() {
        String className = this.getClass().getName();
        int period = className.lastIndexOf(".");
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        return className + "[" + this.getName() + "]";
    }

    public ObjectName getJmxName() {
        return this.oname;
    }

    public String getObjectName() {
        if (this.oname != null) {
            return this.oname.toString();
        }
        return null;
    }

    public String getDomain() {
        if (this.domain == null) {
            Container parent;
            for (parent = this; parent != null && !(parent instanceof StandardEngine); parent = parent.getParent()) {
            }
            if (parent instanceof StandardEngine) {
                this.domain = ((StandardEngine)parent).getDomain();
            }
        }
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getType() {
        return this.type;
    }

    protected String getJSR77Suffix() {
        return this.suffix;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        if (name == null) {
            return null;
        }
        this.domain = name.getDomain();
        this.type = name.getKeyProperty("type");
        if (this.type == null) {
            this.type = name.getKeyProperty("j2eeType");
        }
        String j2eeApp = name.getKeyProperty("J2EEApplication");
        String j2eeServer = name.getKeyProperty("J2EEServer");
        if (j2eeApp == null) {
            j2eeApp = "none";
        }
        if (j2eeServer == null) {
            j2eeServer = "none";
        }
        this.suffix = ",J2EEApplication=" + j2eeApp + ",J2EEServer=" + j2eeServer;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public ObjectName[] getChildren() {
        ObjectName[] result = new ObjectName[this.children.size()];
        Iterator<Container> it = this.children.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Container next = it.next();
            if (!(next instanceof ContainerBase)) continue;
            result[i++] = ((ContainerBase)next).getJmxName();
        }
        return result;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Create ObjectName " + domain + " " + parent);
        }
        return null;
    }

    public String getContainerSuffix() {
        ContainerBase container = this;
        Container context = null;
        Container host = null;
        ContainerBase servlet = null;
        StringBuilder suffix = new StringBuilder();
        if (container instanceof StandardHost) {
            host = container;
        } else if (container instanceof StandardContext) {
            host = container.getParent();
            context = container;
        } else if (container instanceof StandardWrapper) {
            context = container.getParent();
            host = context.getParent();
            servlet = container;
        }
        if (context != null) {
            String path = ((StandardContext)context).getEncodedPath();
            suffix.append(",path=").append(path.equals("") ? "/" : path);
        }
        if (host != null) {
            suffix.append(",host=").append(host.getName());
        }
        if (servlet != null) {
            String name = container.getName();
            suffix.append(",servlet=");
            suffix.append(name == "" ? "/" : name);
        }
        return suffix.toString();
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (this.backgroundProcessorDelay <= 0) {
            return;
        }
        this.threadDone = false;
        String threadName = "ContainerBackgroundProcessor[" + this.toString() + "]";
        this.thread = new Thread((Runnable)new ContainerBackgroundProcessor(), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected class ContainerBackgroundProcessor
    implements Runnable {
        protected ContainerBackgroundProcessor() {
        }

        public void run() {
            while (!ContainerBase.this.threadDone) {
                try {
                    Thread.sleep((long)ContainerBase.this.backgroundProcessorDelay * 1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (ContainerBase.this.threadDone) continue;
                Container parent = (Container)ContainerBase.this.getMappingObject();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (parent.getLoader() != null) {
                    cl = parent.getLoader().getClassLoader();
                }
                this.processChildren(parent, cl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processChildren(Container container, ClassLoader cl) {
            try {
                if (container.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(container.getLoader().getClassLoader());
                }
                container.backgroundProcess();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Exception invoking periodic operation: ", t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            Container[] children = container.findChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getBackgroundProcessorDelay() > 0) continue;
                this.processChildren(children[i], cl);
            }
        }
    }

    protected class PrivilegedAddChild
    implements PrivilegedAction {
        private Container child;

        PrivilegedAddChild(Container child) {
            this.child = child;
        }

        public Object run() {
            ContainerBase.this.addChildInternal(this.child);
            return null;
        }
    }
}

