/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Collections;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import org.apache.catalina.core.ServletRegistrationImpl;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicServletRegistrationImpl
extends ServletRegistrationImpl
implements ServletRegistration.Dynamic {
    protected DynamicServletRegistrationImpl(StandardWrapper wrapper, StandardContext ctx) {
        super(wrapper, ctx);
    }

    @Override
    public void setLoadOnStartup(int loadOnStartup) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"load-on-startup", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        this.wrapper.setLoadOnStartup(loadOnStartup);
    }

    @Override
    public void setAsyncSupported(boolean isAsyncSupported) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"async-supported", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        this.wrapper.setIsAsyncSupported(isAsyncSupported);
    }

    @Override
    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        return Collections.unmodifiableSet(Collections.EMPTY_SET);
    }

    @Override
    public void setMultipartConfig(MultipartConfigElement mpConfig) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"multipart-config", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        this.wrapper.setMultipartLocation(mpConfig.getLocation());
        this.wrapper.setMultipartMaxFileSize(mpConfig.getMaxFileSize());
        this.wrapper.setMultipartMaxRequestSize(mpConfig.getMaxRequestSize());
        this.wrapper.setMultipartFileSizeThreshold(mpConfig.getFileSizeThreshold());
    }

    @Override
    public void setRunAsRole(String roleName) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"run-as", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        this.wrapper.setRunAs(roleName);
    }

    protected void setServletClassName(String className) {
        this.wrapper.setServletClassName(className);
    }

    protected void setServletClass(Class<? extends Servlet> clazz) {
        this.wrapper.setServletClass(clazz);
    }
}

