/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.EntityResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.FieldResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ColumnResult;
import org.eclipse.persistence.queries.EntityResult;
import org.eclipse.persistence.queries.FieldResult;
import org.eclipse.persistence.queries.SQLResultSetMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLResultSetMappingMetadata
extends ORMetadata {
    private List<String> m_columnResults = new ArrayList<String>();
    private List<EntityResultMetadata> m_entityResults = new ArrayList<EntityResultMetadata>();
    private String m_name;

    public SQLResultSetMappingMetadata() {
        super("<sql-result-set-mapping>");
    }

    public SQLResultSetMappingMetadata(MetadataAnnotation sqlResultSetMapping, MetadataAccessibleObject accessibleObject) {
        super(sqlResultSetMapping, accessibleObject);
        this.m_name = (String)sqlResultSetMapping.getAttribute("name");
        for (Object entityResult : (Object[])sqlResultSetMapping.getAttributeArray("entities")) {
            this.m_entityResults.add(new EntityResultMetadata((MetadataAnnotation)entityResult, accessibleObject));
        }
        for (Object columnResult : (Object[])sqlResultSetMapping.getAttributeArray("columns")) {
            this.m_columnResults.add((String)((MetadataAnnotation)columnResult).getAttribute("name"));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof SQLResultSetMappingMetadata) {
            SQLResultSetMappingMetadata sqlResultSetMapping = (SQLResultSetMappingMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, sqlResultSetMapping.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_columnResults, sqlResultSetMapping.getColumnResults())) {
                return false;
            }
            return this.valuesMatch(this.m_entityResults, sqlResultSetMapping.getEntityResults());
        }
        return false;
    }

    public List<String> getColumnResults() {
        return this.m_columnResults;
    }

    public List<EntityResultMetadata> getEntityResults() {
        return this.m_entityResults;
    }

    @Override
    public String getIdentifier() {
        return this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_entityResults, accessibleObject);
    }

    public void process(AbstractSession session, ClassLoader loader, MetadataProject project) {
        SQLResultSetMapping mapping = new SQLResultSetMapping(this.getName());
        for (EntityResultMetadata eResult : this.m_entityResults) {
            EntityResult entityResult = new EntityResult(MetadataHelper.getClassForName(eResult.getEntityClass().getName(), loader));
            if (eResult.hasFieldResults()) {
                for (FieldResultMetadata fResult : eResult.getFieldResults()) {
                    FieldResult fieldResult = new FieldResult(fResult.getName(), fResult.getColumn());
                    if (project.useDelimitedIdentifier()) {
                        fieldResult.getColumn().setUseDelimiters(true);
                    } else if (project.getShouldForceFieldNamesToUpperCase() && !fieldResult.getColumn().shouldUseDelimiters()) {
                        fieldResult.getColumn().useUpperCaseForComparisons(true);
                    }
                    entityResult.addFieldResult(fieldResult);
                }
            }
            if (eResult.getDiscriminatorColumn() != null) {
                DatabaseField descriminatorField = new DatabaseField(eResult.getDiscriminatorColumn());
                if (project.useDelimitedIdentifier()) {
                    descriminatorField.setUseDelimiters(true);
                } else if (project.getShouldForceFieldNamesToUpperCase() && !descriminatorField.shouldUseDelimiters()) {
                    descriminatorField.useUpperCaseForComparisons(true);
                }
                entityResult.setDiscriminatorColumn(descriminatorField);
            }
            mapping.addResult(entityResult);
        }
        for (String columnResult : this.m_columnResults) {
            ColumnResult result = new ColumnResult(columnResult);
            if (project.useDelimitedIdentifier()) {
                result.getColumn().setUseDelimiters(true);
            }
            if (project.getShouldForceFieldNamesToUpperCase()) {
                result.getColumn().useUpperCaseForComparisons(true);
            }
            mapping.addResult(result);
        }
        session.getProject().addSQLResultSetMapping(mapping);
    }

    protected void setColumnResults(List<String> columnResults) {
        this.m_columnResults = columnResults;
    }

    public void setEntityResults(List<EntityResultMetadata> entityResults) {
        this.m_entityResults = entityResults;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

