/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree.analysis;

import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.AnalyzerException;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.BasicValue;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.BasicVerifier;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Value;

public class SimpleVerifier
extends BasicVerifier {
    public Value newValue(Type type2) {
        Value v = super.newValue(type2);
        if (v == BasicValue.REFERENCE_VALUE) {
            if (type2.getSort() == 9) {
                v = this.newValue(type2.getElementType());
                String desc = ((BasicValue)v).getType().getDescriptor();
                int i = 0;
                while (i < type2.getDimensions()) {
                    desc = "[" + desc;
                    ++i;
                }
                v = new BasicValue(Type.getType(desc));
            } else {
                v = new BasicValue(type2);
            }
        }
        return v;
    }

    protected boolean isArrayValue(Value value) {
        Type t = ((BasicValue)value).getType();
        if (t != null) {
            return t.getDescriptor().equals("Lnull;") || t.getSort() == 9;
        }
        return false;
    }

    protected Value getElementValue(Value objectArrayValue) throws AnalyzerException {
        Type arrayType = ((BasicValue)objectArrayValue).getType();
        if (arrayType != null) {
            if (arrayType.getSort() == 9) {
                return this.newValue(Type.getType(arrayType.getDescriptor().substring(1)));
            }
            if (arrayType.getDescriptor().equals("Lnull;")) {
                return objectArrayValue;
            }
        }
        throw new AnalyzerException("Not an array type");
    }

    protected boolean isSubTypeOf(Value value, Value expected) {
        Type expectedType = ((BasicValue)expected).getType();
        Type type2 = ((BasicValue)value).getType();
        if (expectedType == null) {
            return type2 == null;
        }
        switch (expectedType.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type2 == expectedType;
            }
            case 9: 
            case 10: {
                if (expectedType.getDescriptor().equals("Lnull;")) {
                    return type2.getSort() == 10 || type2.getSort() == 9;
                }
                Class expectedClass = this.getClass(expectedType);
                if (type2.getDescriptor().equals("Lnull;")) {
                    return !expectedClass.isPrimitive();
                }
                if (type2.getSort() == 10 || type2.getSort() == 9) {
                    Class actualClass = this.getClass(type2);
                    return expectedClass.isAssignableFrom(actualClass);
                }
                return false;
            }
        }
        throw new RuntimeException("Internal error");
    }

    public Value merge(Value v, Value w) {
        if (!v.equals(w)) {
            Type t = ((BasicValue)v).getType();
            Type u = ((BasicValue)w).getType();
            if (!(t == null || t.getSort() != 10 && t.getSort() != 9 || u == null || u.getSort() != 10 && u.getSort() != 9)) {
                Class d;
                if (t.getDescriptor().equals("Lnull;")) {
                    return w;
                }
                if (u.getDescriptor().equals("Lnull;")) {
                    return v;
                }
                Class c = this.getClass(t);
                if (c.isAssignableFrom(d = this.getClass(u))) {
                    return v;
                }
                if (d.isAssignableFrom(c)) {
                    return w;
                }
                do {
                    if (c != null && !c.isInterface()) continue;
                    return BasicValue.REFERENCE_VALUE;
                } while (!(c = c.getSuperclass()).isAssignableFrom(d));
                return this.newValue(Type.getType(c));
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return v;
    }

    protected Class getClass(Type t) {
        try {
            if (t.getSort() == 9) {
                return Class.forName(t.getDescriptor().replace('/', '.'));
            }
            return Class.forName(t.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

