/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.xml;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.util.PrintCodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXClassAdapter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXCodeAdapter
implements CodeVisitor {
    private ContentHandler h;
    private Map labelNames;

    public SAXCodeAdapter(ContentHandler h) {
        this.h = h;
        this.labelNames = new HashMap();
    }

    public final void visitInsn(int opcode) {
        this.addElement(PrintCodeVisitor.OPCODES[opcode], new AttributesImpl());
    }

    public final void visitIntInsn(int opcode, int operand) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "value", "value", "", Integer.toString(operand));
        this.addElement(PrintCodeVisitor.OPCODES[opcode], attrs);
    }

    public final void visitVarInsn(int opcode, int var) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "var", "var", "", Integer.toString(var));
        this.addElement(PrintCodeVisitor.OPCODES[opcode], attrs);
    }

    public final void visitTypeInsn(int opcode, String desc) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "desc", "desc", "", desc);
        this.addElement(PrintCodeVisitor.OPCODES[opcode], attrs);
    }

    public final void visitFieldInsn(int opcode, String owner, String name, String desc) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "owner", "owner", "", owner);
        attrs.addAttribute("", "name", "name", "", name);
        attrs.addAttribute("", "desc", "desc", "", desc);
        this.addElement(PrintCodeVisitor.OPCODES[opcode], attrs);
    }

    public final void visitMethodInsn(int opcode, String owner, String name, String desc) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "owner", "owner", "", owner);
        attrs.addAttribute("", "name", "name", "", name);
        attrs.addAttribute("", "desc", "desc", "", desc);
        this.addElement(PrintCodeVisitor.OPCODES[opcode], attrs);
    }

    public final void visitJumpInsn(int opcode, Label label) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "label", "label", "", this.getLabel(label));
        this.addElement(PrintCodeVisitor.OPCODES[opcode], attrs);
    }

    public final void visitLabel(Label label) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "name", "name", "", this.getLabel(label));
        this.addElement("Label", attrs);
    }

    public final void visitLdcInsn(Object cst) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "cst", "cst", "", SAXClassAdapter.encode(cst.toString()));
        attrs.addAttribute("", "desc", "desc", "", Type.getDescriptor(cst.getClass()));
        this.addElement(PrintCodeVisitor.OPCODES[18], attrs);
    }

    public final void visitIincInsn(int var, int increment) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "var", "var", "", Integer.toString(var));
        attrs.addAttribute("", "inc", "inc", "", Integer.toString(increment));
        this.addElement(PrintCodeVisitor.OPCODES[132], attrs);
    }

    public final void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "min", "min", "", Integer.toString(min));
        attrs.addAttribute("", "max", "max", "", Integer.toString(max));
        attrs.addAttribute("", "dflt", "dflt", "", this.getLabel(dflt));
        String o = PrintCodeVisitor.OPCODES[170];
        this.addStart(o, attrs);
        int i = 0;
        while (i < labels.length) {
            AttributesImpl att2 = new AttributesImpl();
            att2.addAttribute("", "name", "name", "", this.getLabel(labels[i]));
            this.addElement("label", att2);
            ++i;
        }
        this.addEnd(o);
    }

    public final void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "dflt", "dflt", "", this.getLabel(dflt));
        String o = PrintCodeVisitor.OPCODES[171];
        this.addStart(o, att);
        int i = 0;
        while (i < labels.length) {
            AttributesImpl att2 = new AttributesImpl();
            att2.addAttribute("", "name", "name", "", this.getLabel(labels[i]));
            att2.addAttribute("", "key", "key", "", Integer.toString(keys[i]));
            this.addElement("label", att2);
            ++i;
        }
        this.addEnd(o);
    }

    public final void visitMultiANewArrayInsn(String desc, int dims) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "desc", "desc", "", desc);
        attrs.addAttribute("", "dims", "dims", "", Integer.toString(dims));
        this.addElement(PrintCodeVisitor.OPCODES[197], attrs);
    }

    public final void visitTryCatchBlock(Label start, Label end, Label handler, String type2) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "start", "start", "", this.getLabel(start));
        attrs.addAttribute("", "end", "end", "", this.getLabel(end));
        attrs.addAttribute("", "handler", "handler", "", this.getLabel(handler));
        if (type2 != null) {
            attrs.addAttribute("", "type", "type", "", type2);
        }
        this.addElement("TryCatch", attrs);
    }

    public final void visitMaxs(int maxStack, int maxLocals) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "maxStack", "maxStack", "", Integer.toString(maxStack));
        attrs.addAttribute("", "maxLocals", "maxLocals", "", Integer.toString(maxLocals));
        this.addElement("Max", attrs);
        this.addEnd("code");
        this.addEnd("method");
    }

    public final void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "name", "name", "", name);
        attrs.addAttribute("", "desc", "desc", "", desc);
        attrs.addAttribute("", "start", "start", "", this.getLabel(start));
        attrs.addAttribute("", "end", "end", "", this.getLabel(end));
        attrs.addAttribute("", "var", "var", "", Integer.toString(index));
        this.addElement("LocalVar", attrs);
    }

    public final void visitLineNumber(int line, Label start) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "line", "line", "", Integer.toString(line));
        attrs.addAttribute("", "start", "start", "", this.getLabel(start));
        this.addElement("LineNumber", attrs);
    }

    public final void visitAttribute(Attribute attr) {
    }

    private final String getLabel(Label label) {
        String name = (String)this.labelNames.get(label);
        if (name == null) {
            name = Integer.toString(this.labelNames.size());
            this.labelNames.put(label, name);
        }
        return name;
    }

    private final void addElement(String name, Attributes attrs) {
        this.addStart(name, attrs);
        this.addEnd(name);
    }

    private final void addStart(String name, Attributes attrs) {
        try {
            this.h.startElement("", name, name, attrs);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private final void addEnd(String name) {
        try {
            this.h.endElement("", name, name);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex.toString());
        }
    }
}

