/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.SAXException;

public class XMLInlineBinaryHandler
extends UnmarshalRecord {
    NodeValue nodeValue;
    DatabaseMapping mapping;
    boolean isCollection = false;
    Converter converter;
    UnmarshalRecord parent;

    public XMLInlineBinaryHandler(UnmarshalRecord parent, NodeValue nodeValue, DatabaseMapping mapping, Converter converter, boolean isCollection) {
        super(null);
        this.nodeValue = nodeValue;
        this.isCollection = isCollection;
        this.mapping = mapping;
        this.parent = parent;
        this.converter = converter;
        this.setUnmarshaller(parent.getUnmarshaller());
    }

    public void characters(char[] ch, int offset, int length) throws SAXException {
        this.getStringBuffer().append(ch, offset, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        XMLField field = null;
        Object value = this.getStringBuffer().toString();
        this.resetStringBuffer();
        Class attributeClassification = null;
        boolean isSwaRef = false;
        if (this.isCollection) {
            isSwaRef = ((XMLBinaryDataCollectionMapping)this.mapping).isSwaRef();
            field = (XMLField)((XMLBinaryDataCollectionMapping)this.mapping).getField();
            attributeClassification = ((XMLBinaryDataCollectionMapping)this.mapping).getAttributeElementClass();
        } else {
            isSwaRef = ((XMLBinaryDataMapping)this.mapping).isSwaRef();
            field = (XMLField)((XMLBinaryDataMapping)this.mapping).getField();
            attributeClassification = ((XMLBinaryDataMapping)this.mapping).getAttributeClassification();
        }
        if (isSwaRef && this.parent.getUnmarshaller().getAttachmentUnmarshaller() != null) {
            value = attributeClassification != null && attributeClassification == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER ? this.parent.getUnmarshaller().getAttachmentUnmarshaller().getAttachmentAsDataHandler((String)value) : (Object)this.parent.getUnmarshaller().getAttachmentUnmarshaller().getAttachmentAsByteArray((String)value);
            if (this.converter != null) {
                value = this.converter instanceof XMLConverter ? ((XMLConverter)this.converter).convertDataValueToObjectValue(value, this.parent.getSession(), this.parent.getUnmarshaller()) : this.converter.convertDataValueToObjectValue(value, this.parent.getSession());
            }
        } else {
            value = XMLConversionManager.getDefaultXMLManager().convertSchemaBase64ToByteArray(value);
        }
        value = XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(value, attributeClassification, this.parent.getSession());
        if (this.converter != null) {
            value = this.converter instanceof XMLConverter ? ((XMLConverter)this.converter).convertDataValueToObjectValue(value, this.parent.getSession(), this.parent.getUnmarshaller()) : this.converter.convertDataValueToObjectValue(value, this.parent.getSession());
        }
        if (this.isCollection) {
            if (value != null) {
                this.parent.addAttributeValue((ContainerValue)((Object)this.nodeValue), value);
            }
        } else {
            this.parent.setAttributeValue(value, this.mapping);
        }
        if (!field.isSelfField()) {
            this.parent.getXMLReader().setContentHandler(this.parent);
            this.parent.endElement(namespaceURI, localName, qName);
        }
    }
}

