/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLAnyAttributeMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.record.MarshalRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathNode {
    private NodeValue unmarshalNodeValue;
    private NodeValue marshalNodeValue;
    private XPathFragment xPathFragment;
    private XPathNode parent;
    private List<XPathNode> attributeChildren;
    private List<XPathNode> nonAttributeChildren;
    private List<XPathNode> selfChildren;
    private Map<XPathFragment, XPathNode> attributeChildrenMap;
    private Map<XPathFragment, XPathNode> nonAttributeChildrenMap;
    private XMLAnyAttributeMappingNodeValue anyAttributeNodeValue;
    private XPathNode anyAttributeNode;
    private XPathNode textNode;
    private XPathNode anyNode;

    public XPathFragment getXPathFragment() {
        return this.xPathFragment;
    }

    public void setXPathFragment(XPathFragment xPathFragment) {
        this.xPathFragment = xPathFragment;
    }

    public NodeValue getNodeValue() {
        return this.unmarshalNodeValue;
    }

    public void setNodeValue(NodeValue nodeValue) {
        this.marshalNodeValue = nodeValue;
        this.unmarshalNodeValue = nodeValue;
        if (null != nodeValue) {
            nodeValue.setXPathNode(this);
        }
    }

    public NodeValue getUnmarshalNodeValue() {
        return this.unmarshalNodeValue;
    }

    public void setUnmarshalNodeValue(NodeValue nodeValue) {
        if (null != nodeValue) {
            nodeValue.setXPathNode(this);
        }
        this.unmarshalNodeValue = nodeValue;
    }

    public NodeValue getMarshalNodeValue() {
        return this.marshalNodeValue;
    }

    public void setMarshalNodeValue(NodeValue nodeValue) {
        if (null != nodeValue) {
            nodeValue.setXPathNode(this);
        }
        this.marshalNodeValue = nodeValue;
    }

    public XPathNode getParent() {
        return this.parent;
    }

    public void setParent(XPathNode parent) {
        this.parent = parent;
    }

    public List<XPathNode> getAttributeChildren() {
        return this.attributeChildren;
    }

    public List<XPathNode> getNonAttributeChildren() {
        return this.nonAttributeChildren;
    }

    public List<XPathNode> getSelfChildren() {
        return this.selfChildren;
    }

    public Map<XPathFragment, XPathNode> getNonAttributeChildrenMap() {
        return this.nonAttributeChildrenMap;
    }

    public Map<XPathFragment, XPathNode> getAttributeChildrenMap() {
        return this.attributeChildrenMap;
    }

    public void setAnyAttributeNodeValue(XMLAnyAttributeMappingNodeValue nodeValue) {
        this.anyAttributeNodeValue = nodeValue;
    }

    public XMLAnyAttributeMappingNodeValue getAnyAttributeNodeValue() {
        return this.anyAttributeNodeValue;
    }

    public XPathNode getAnyAttributeNode() {
        return this.anyAttributeNode;
    }

    public XPathNode getAnyNode() {
        return this.anyNode;
    }

    public void setAnyNode(XPathNode xPathNode) {
        this.anyNode = xPathNode;
    }

    public XPathNode getTextNode() {
        return this.textNode;
    }

    public void setTextNode(XPathNode xPathNode) {
        this.textNode = xPathNode;
    }

    public boolean equals(Object object) {
        try {
            XPathFragment perfNodeXPathFragment = ((XPathNode)object).getXPathFragment();
            if (this.xPathFragment == perfNodeXPathFragment) {
                return true;
            }
            if (null == this.xPathFragment) {
                return false;
            }
            if (null == perfNodeXPathFragment) {
                return false;
            }
            return this.xPathFragment.equals(perfNodeXPathFragment);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public XPathNode addChild(XPathFragment anXPathFragment, NodeValue aNodeValue, NamespaceResolver namespaceResolver) {
        Map<XPathFragment, XPathNode> childrenMap;
        List<XPathNode> children;
        if (null != anXPathFragment && anXPathFragment.nameIsText() && aNodeValue.isOwningNode(anXPathFragment)) {
            XPathNode textXPathNode = new XPathNode();
            textXPathNode.setParent(this);
            textXPathNode.setXPathFragment(anXPathFragment);
            if (aNodeValue.isMarshalNodeValue()) {
                textXPathNode.setMarshalNodeValue(aNodeValue);
            }
            if (aNodeValue.isUnmarshalNodeValue()) {
                textXPathNode.setUnmarshalNodeValue(aNodeValue);
            }
            this.setTextNode(textXPathNode);
            if (null == this.nonAttributeChildren) {
                this.nonAttributeChildren = new ArrayList<XPathNode>();
            }
            this.nonAttributeChildren.add(textXPathNode);
            return textXPathNode;
        }
        if (anXPathFragment != null && namespaceResolver != null && anXPathFragment.getNamespaceURI() == null && !anXPathFragment.nameIsText()) {
            if (!anXPathFragment.isAttribute()) {
                anXPathFragment.setNamespaceURI(namespaceResolver.resolveNamespacePrefix(anXPathFragment.getPrefix()));
            } else if (anXPathFragment.hasNamespace()) {
                anXPathFragment.setNamespaceURI(namespaceResolver.resolveNamespacePrefix(anXPathFragment.getPrefix()));
            }
        }
        XPathNode xPathNode = new XPathNode();
        xPathNode.setXPathFragment(anXPathFragment);
        if (anXPathFragment != null && anXPathFragment.isAttribute()) {
            if (null == this.attributeChildren) {
                this.attributeChildren = new ArrayList<XPathNode>();
            }
            if (null == this.attributeChildrenMap) {
                this.attributeChildrenMap = new HashMap<XPathFragment, XPathNode>();
            }
            children = this.attributeChildren;
            childrenMap = this.attributeChildrenMap;
        } else {
            if (null == this.nonAttributeChildren) {
                this.nonAttributeChildren = new ArrayList<XPathNode>();
            }
            if (null == this.nonAttributeChildrenMap) {
                this.nonAttributeChildrenMap = new HashMap<XPathFragment, XPathNode>();
            }
            children = this.nonAttributeChildren;
            childrenMap = this.nonAttributeChildrenMap;
        }
        if (null == anXPathFragment) {
            if (aNodeValue.isMarshalNodeValue()) {
                xPathNode.setMarshalNodeValue(aNodeValue);
            }
            if (aNodeValue.isUnmarshalNodeValue() && xPathNode.getUnmarshalNodeValue() == null) {
                xPathNode.setUnmarshalNodeValue(aNodeValue);
            }
            xPathNode.setParent(this);
            if (aNodeValue instanceof XMLAnyAttributeMappingNodeValue) {
                this.setAnyAttributeNodeValue((XMLAnyAttributeMappingNodeValue)aNodeValue);
                this.anyAttributeNode = xPathNode;
            } else {
                if (!children.contains(xPathNode)) {
                    children.add(xPathNode);
                }
                this.setAnyNode(xPathNode);
            }
            return xPathNode;
        }
        boolean isSelfFragment = XPathFragment.SELF_FRAGMENT.equals(anXPathFragment);
        if (isSelfFragment) {
            children.add(xPathNode);
            if (null == this.selfChildren) {
                this.selfChildren = new ArrayList<XPathNode>();
            }
            this.selfChildren.add(xPathNode);
        } else {
            int index = children.indexOf(xPathNode);
            if (index >= 0) {
                xPathNode = children.get(index);
            } else {
                xPathNode.setParent(this);
                if (!children.contains(xPathNode)) {
                    children.add(xPathNode);
                }
                childrenMap.put(anXPathFragment, xPathNode);
            }
        }
        if (aNodeValue.isOwningNode(anXPathFragment)) {
            if (aNodeValue.isMarshalNodeValue()) {
                xPathNode.setMarshalNodeValue(aNodeValue);
            }
            if (aNodeValue.isUnmarshalNodeValue() && xPathNode.getUnmarshalNodeValue() == null) {
                xPathNode.setUnmarshalNodeValue(aNodeValue);
            }
        } else {
            XPathFragment nextFragment = anXPathFragment.getNextFragment();
            xPathNode.addChild(nextFragment, aNodeValue, namespaceResolver);
        }
        return xPathNode;
    }

    public boolean marshal(MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, XMLMarshaller marshaller, MarshalContext marshalContext, XPathFragment rootFragment) {
        if (null == this.marshalNodeValue || this.marshalNodeValue.isMarshalOnlyNodeValue()) {
            XPathNode xPathNode;
            int x;
            int size;
            marshalRecord.addGroupingElement(this);
            boolean hasValue = false;
            if (null != this.attributeChildren) {
                size = this.attributeChildren.size();
                for (x = 0; x < size; ++x) {
                    xPathNode = this.attributeChildren.get(x);
                    hasValue = xPathNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, ObjectMarshalContext.getInstance(), this.xPathFragment) || hasValue;
                }
            }
            if (this.anyAttributeNode != null) {
                boolean bl = hasValue = this.anyAttributeNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, ObjectMarshalContext.getInstance(), null) || hasValue;
            }
            if (null != this.nonAttributeChildren) {
                size = marshalContext.getNonAttributeChildrenSize(this);
                for (x = 0; x < size; ++x) {
                    MarshalContext childMarshalContext;
                    xPathNode = (XPathNode)marshalContext.getNonAttributeChild(x, this);
                    hasValue = xPathNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, childMarshalContext = marshalContext.getMarshalContext(x), this.xPathFragment) || hasValue;
                }
            }
            if (hasValue) {
                marshalRecord.endElement(this.xPathFragment, namespaceResolver);
            } else {
                marshalRecord.removeGroupingElement(this);
            }
            return hasValue;
        }
        return marshalContext.marshal(this.marshalNodeValue, this.xPathFragment, marshalRecord, object, session, namespaceResolver, rootFragment);
    }

    public boolean startElement(MarshalRecord marshalRecord, XPathFragment anXPathFragment, Object object, AbstractSession session, NamespaceResolver namespaceResolver, TreeObjectBuilder compositeObjectBuilder, Object compositeObject) {
        if (null == anXPathFragment) {
            return false;
        }
        marshalRecord.openStartElement(anXPathFragment, namespaceResolver);
        boolean hasValue = false;
        if (null != this.attributeChildren) {
            int size = this.attributeChildren.size();
            for (int x = 0; x < size; ++x) {
                XPathNode attributeNode = this.attributeChildren.get(x);
                hasValue = attributeNode.marshal(marshalRecord, object, session, namespaceResolver, null, ObjectMarshalContext.getInstance(), null) || hasValue;
            }
        }
        if (this.anyAttributeNode != null) {
            boolean bl = hasValue = this.anyAttributeNode.marshal(marshalRecord, object, session, namespaceResolver, null, ObjectMarshalContext.getInstance(), null) || hasValue;
        }
        if (null != compositeObjectBuilder) {
            hasValue = compositeObjectBuilder.marshalAttributes(marshalRecord, compositeObject, session) || hasValue;
        }
        marshalRecord.closeStartElement();
        return hasValue;
    }

    public boolean marshalSelfAttributes(MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, XMLMarshaller marshaller) {
        if (this.marshalNodeValue == null) {
            return false;
        }
        return this.marshalNodeValue.marshalSelfAttributes(this.xPathFragment, marshalRecord, object, session, namespaceResolver, marshaller);
    }

    public boolean isWhitespaceAware() {
        return this.unmarshalNodeValue.isWhitespaceAware();
    }
}

