/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.helper.QueryCounter;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.history.HistoricalSession;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.ProtectedValueHolder;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.EmptyRecord;
import org.eclipse.persistence.internal.sessions.IdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.SessionFinalizer;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventManager;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.factories.ReferenceMode;
import org.eclipse.persistence.sessions.server.ClientSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession
implements Session,
CommandProcessor,
Serializable,
Cloneable {
    protected transient ExceptionHandler exceptionHandler;
    protected transient IntegrityChecker integrityChecker;
    protected transient Project project;
    protected transient ConcurrencyManager transactionMutex;
    protected IdentityMapAccessor identityMapAccessor;
    protected boolean wasJTSTransactionInternallyStarted;
    protected transient Collection<Accessor> accessors;
    protected transient Platform platform;
    protected transient Map<String, List<DatabaseQuery>> queries;
    protected transient List<DatabaseQuery> jpaQueries;
    protected transient CommitManager commitManager;
    protected transient SessionProfiler profiler;
    protected transient AbstractSession broker;
    protected String name;
    protected transient int numberOfActiveUnitsOfWork;
    protected Map objectsLockedForClone;
    protected transient SessionLog sessionLog;
    protected transient String logSessionString;
    protected transient SessionEventManager eventManager;
    protected Map<Object, Object> properties;
    protected transient ExternalTransactionController externalTransactionController;
    protected transient ClassDescriptor lastDescriptorAccessed;
    protected transient Map<Class, ClassDescriptor> descriptors;
    protected boolean isInBroker;
    protected transient CommandManager commandManager;
    protected boolean shouldCheckWriteLock;
    protected boolean shouldPropagateChanges;
    protected boolean isInProfile;
    protected boolean isLoggingOff;
    protected boolean isFinalizersEnabled = false;
    protected transient ExposedNodeLinkedList activeCommandThreads;
    protected boolean isSynchronized;
    protected ReferenceMode defaultReferenceMode = null;
    protected Integer pessimisticLockTimeoutDefault;
    protected int queryTimeoutDefault;
    protected Map<String, String> staticMetamodelClasses;
    protected List<DescriptorEvent> deferredEvents;
    protected boolean isExecutingEvents = false;
    protected PartitioningPolicy partitioningPolicy;

    protected AbstractSession() {
        this.name = "";
        this.initializeIdentityMapAccessor();
        this.numberOfActiveUnitsOfWork = 0;
        this.isInBroker = false;
        this.isSynchronized = false;
    }

    protected AbstractSession(int nothing) {
    }

    public AbstractSession(Login login) {
        this(new Project(login));
    }

    public AbstractSession(Project project) {
        this();
        this.project = project;
        if (project.getDatasourceLogin() == null) {
            throw ValidationException.projectLoginIsNull(this);
        }
        for (DatabaseQuery query : project.getQueries()) {
            this.addQuery(query.getName(), query);
        }
    }

    public boolean isLoggingOff() {
        return this.isLoggingOff;
    }

    public long getNextQueryId() {
        return QueryCounter.getCount();
    }

    public UnitOfWorkImpl acquireNonSynchronizedUnitOfWork() {
        return this.acquireNonSynchronizedUnitOfWork(null);
    }

    public UnitOfWorkImpl acquireNonSynchronizedUnitOfWork(ReferenceMode referenceMode) {
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        UnitOfWorkImpl unitOfWork = new UnitOfWorkImpl(this, referenceMode);
        if (this.shouldLog(2, "transaction")) {
            this.log(2, "transaction", "acquire_unit_of_work_with_argument", String.valueOf(System.identityHashCode(unitOfWork)));
        }
        return unitOfWork;
    }

    @Override
    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        if (clause == null || clause.getValue() == null) {
            throw ValidationException.cannotAcquireHistoricalSession();
        }
        if (!(this.getProject().hasGenericHistorySupport() || this.hasBroker() || this.getPlatform() != null && this.getPlatform().isOracle())) {
            throw ValidationException.historicalSessionOnlySupportedOnOracle();
        }
        return new HistoricalSession(this, clause);
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork() {
        UnitOfWorkImpl unitOfWork = this.acquireNonSynchronizedUnitOfWork(this.getDefaultReferenceMode());
        unitOfWork.registerWithTransactionIfRequired();
        return unitOfWork;
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork(ReferenceMode referenceMode) {
        UnitOfWorkImpl unitOfWork = this.acquireNonSynchronizedUnitOfWork(referenceMode);
        unitOfWork.registerWithTransactionIfRequired();
        return unitOfWork;
    }

    public void addAlias(String alias, ClassDescriptor descriptor) {
        this.project.addAlias(alias, descriptor);
    }

    @Override
    public void addQuery(String name, DatabaseQuery query) {
        query.setName(name);
        this.addQuery(query);
    }

    @Override
    public void addJPAQuery(DatabaseQuery query) {
        this.getJPAQueries().add(query);
    }

    protected void addQuery(DatabaseQuery query) {
        Vector queriesByName = (Vector)this.getQueries().get(query.getName());
        if (queriesByName == null) {
            queriesByName = NonSynchronizedVector.newInstance();
            this.getQueries().put(query.getName(), queriesByName);
        }
        Enumeration enumtr = queriesByName.elements();
        while (enumtr.hasMoreElements()) {
            DatabaseQuery existingQuery = (DatabaseQuery)enumtr.nextElement();
            if (!Helper.areTypesAssignable(query.getArgumentTypes(), existingQuery.getArgumentTypes())) continue;
            throw ValidationException.existingQueryTypeConflict(query, existingQuery);
        }
        queriesByName.add(query);
    }

    public void addStaticMetamodelClass(String modelClassName, String metamodelClassName) {
        if (this.staticMetamodelClasses == null) {
            this.staticMetamodelClasses = new HashMap<String, String>();
        }
        this.staticMetamodelClasses.put(modelClassName, metamodelClassName);
    }

    protected void basicBeginTransaction() throws DatabaseException {
        Collection<Accessor> accessors = this.getAccessors();
        if (accessors == null) {
            return;
        }
        Accessor failedAccessor = null;
        try {
            Iterator<Accessor> i$ = accessors.iterator();
            while (i$.hasNext()) {
                Accessor accessor;
                failedAccessor = accessor = i$.next();
                this.basicBeginTransaction(0, accessor);
            }
        }
        catch (RuntimeException exception) {
            for (Accessor accessor : accessors) {
                if (accessor == failedAccessor) break;
                try {
                    accessor.rollbackTransaction(this);
                }
                catch (RuntimeException ignore) {}
            }
            throw exception;
        }
    }

    protected void basicBeginTransaction(Accessor accessor) throws DatabaseException {
        this.basicBeginTransaction(0, accessor);
    }

    protected void basicBeginTransaction(int retryCount, Accessor accessor) throws DatabaseException {
        try {
            accessor.beginTransaction(this);
        }
        catch (DatabaseException databaseException) {
            if (!this.getDatasourceLogin().shouldUseExternalTransactionController() && databaseException.isCommunicationFailure()) {
                DatabaseException exceptionToThrow = databaseException;
                this.log(5, "communication_failure_attempting_query_retry", (Object[])null, null);
                while (retryCount < this.getLogin().getQueryRetryAttemptCount()) {
                    try {
                        databaseException.getAccessor().reestablishConnection(this);
                    }
                    catch (DatabaseException ex) {
                        ++retryCount;
                        try {
                            Thread.currentThread();
                            Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                            this.log(5, "communication_failure_attempting_begintransaction_retry", (Object[])null, null);
                            continue;
                        }
                        catch (InterruptedException intEx) {}
                    }
                    break;
                }
                if (retryCount <= this.getLogin().getQueryRetryAttemptCount()) {
                    try {
                        ++retryCount;
                        try {
                            if (retryCount > 1) {
                                Thread.currentThread();
                                Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                            }
                            this.basicBeginTransaction(retryCount, accessor);
                            return;
                        }
                        catch (DatabaseException ex) {
                            exceptionToThrow = ex;
                        }
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                this.handleException(exceptionToThrow);
            }
            this.handleException(databaseException);
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    public void releaseJTSConnection() {
    }

    protected void basicCommitTransaction() throws DatabaseException {
        Collection<Accessor> accessors = this.getAccessors();
        if (accessors == null) {
            return;
        }
        RuntimeException exception = null;
        for (Accessor accessor : accessors) {
            try {
                if (exception == null) {
                    accessor.commitTransaction(this);
                    continue;
                }
                accessor.rollbackTransaction(this);
            }
            catch (RuntimeException failure) {
                exception = failure;
            }
        }
        if (exception != null) {
            this.handleException(exception);
        }
    }

    protected void basicRollbackTransaction() throws DatabaseException {
        Collection<Accessor> accessors = this.getAccessors();
        if (accessors == null) {
            return;
        }
        RuntimeException exception = null;
        for (Accessor accessor : accessors) {
            try {
                accessor.rollbackTransaction(this);
            }
            catch (RuntimeException failure) {
                exception = failure;
            }
        }
        if (exception != null) {
            this.handleException(exception);
        }
    }

    public boolean beginExternalTransaction() {
        boolean externalTransactionHasBegun = false;
        if (this.hasExternalTransactionController() && !this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().beginTransaction(this);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
            if (this.wasJTSTransactionInternallyStarted()) {
                externalTransactionHasBegun = true;
                this.log(2, "transaction", "external_transaction_has_begun_internally");
            }
        }
        return externalTransactionHasBegun;
    }

    public void beginTransaction() throws DatabaseException, ConcurrencyException {
        ConcurrencyManager mutex = this.getTransactionMutex();
        if (!mutex.isAcquired()) {
            this.beginExternalTransaction();
        }
        if (this.isClientSession()) {
            mutex.setActiveThread(Thread.currentThread());
        }
        mutex.acquire();
        if (!mutex.isNested()) {
            if (this.eventManager != null) {
                this.eventManager.preBeginTransaction();
            }
            this.basicBeginTransaction();
            if (this.eventManager != null) {
                this.eventManager.postBeginTransaction();
            }
        }
    }

    protected ClassDescriptor checkHierarchyForDescriptor(Class theClass) {
        return this.getDescriptor(theClass.getSuperclass());
    }

    @Override
    public void clearIntegrityChecker() {
        this.setIntegrityChecker(null);
    }

    public void clearLastDescriptorAccessed() {
        this.lastDescriptorAccessed = null;
    }

    public void clearDescriptors() {
        this.descriptors = null;
    }

    @Override
    public void clearProfile() {
        this.setProfiler(null);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean commitExternalTransaction() {
        boolean externalTransactionHasCommitted = false;
        if (this.hasExternalTransactionController() && this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().commitTransaction(this);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
            if (!this.wasJTSTransactionInternallyStarted()) {
                externalTransactionHasCommitted = true;
                this.log(2, "transaction", "external_transaction_has_committed_internally");
            }
        }
        return externalTransactionHasCommitted;
    }

    public void commitTransaction() throws DatabaseException, ConcurrencyException {
        ConcurrencyManager mutex = this.getTransactionMutex();
        if (!mutex.isNested()) {
            if (this.eventManager != null) {
                this.eventManager.preCommitTransaction();
            }
            this.basicCommitTransaction();
            if (this.eventManager != null) {
                this.eventManager.postCommitTransaction();
            }
        }
        mutex.release();
        if (!mutex.isAcquired()) {
            this.commitExternalTransaction();
        }
    }

    public boolean compareObjects(Object firstObject, Object secondObject) {
        if (firstObject == null && secondObject == null) {
            return true;
        }
        if (firstObject == null || secondObject == null) {
            return false;
        }
        if (!firstObject.getClass().equals(secondObject.getClass())) {
            return false;
        }
        ObjectBuilder builder = this.getDescriptor(firstObject.getClass()).getObjectBuilder();
        return builder.compareObjects(builder.unwrapObject(firstObject, this), builder.unwrapObject(secondObject, this), this);
    }

    public boolean compareObjectsDontMatch(Object firstObject, Object secondObject) {
        return !this.compareObjects(firstObject, secondObject);
    }

    @Override
    public boolean containsQuery(String queryName) {
        return this.getQueries().containsKey(queryName);
    }

    @Override
    public Object copy(Object originalObjectOrObjects) {
        return this.copy(originalObjectOrObjects, new CopyGroup());
    }

    @Override
    public Object copy(Object originalObjectOrObjects, AttributeGroup group2) {
        if (originalObjectOrObjects == null) {
            return null;
        }
        CopyGroup copyGroup = group2.toCopyGroup();
        copyGroup.setSession(this);
        if (originalObjectOrObjects instanceof Collection) {
            Collection originalCollection = (Collection)originalObjectOrObjects;
            AbstractCollection copies = originalCollection instanceof List ? new ArrayList() : new HashSet();
            Iterator it = originalCollection.iterator();
            while (it.hasNext()) {
                copies.add(this.copyInternal(it.next(), copyGroup));
            }
            return copies;
        }
        return this.copyInternal(originalObjectOrObjects, copyGroup);
    }

    public Object copyInternal(Object originalObject, CopyGroup copyGroup) {
        if (originalObject == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(originalObject);
        if (descriptor == null) {
            return originalObject;
        }
        return descriptor.getObjectBuilder().copyObject(originalObject, copyGroup);
    }

    @Override
    public Object copyObject(Object original) {
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setShouldResetPrimaryKey(true);
        return this.copy(original, copyGroup);
    }

    @Override
    public Object copyObject(Object original, ObjectCopyingPolicy policy) {
        return this.copy(original, policy);
    }

    public Vector copyReadOnlyClasses() {
        return this.getDefaultReadOnlyClasses();
    }

    public DatabaseValueHolder createCloneQueryValueHolder(ValueHolderInterface attributeValue, Object clone, AbstractRecord row, ForeignReferenceMapping mapping) {
        return new ProtectedValueHolder(attributeValue, mapping, this);
    }

    public DatabaseValueHolder createCloneTransformationValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractTransformationMapping mapping) {
        return new ProtectedValueHolder(attributeValue, mapping, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createProtectedInstanceFromCachedData(Object cached, ClassDescriptor descriptor) {
        Object object;
        block15: {
            block16: {
                Iterator iterator2;
                CacheKey localCacheKey = this.getIdentityMapAccessorInstance().getCacheKeyForObject(cached);
                if (localCacheKey != null && localCacheKey.getObject() != null) {
                    return localCacheKey.getObject();
                }
                boolean identityMapLocked = this.shouldCheckWriteLock && this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
                boolean rootOfCloneRecursion = false;
                CacheKey cacheKey = this.getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(cached);
                try {
                    Object key = null;
                    Object lockValue = null;
                    long readTime = 0L;
                    if (cacheKey != null) {
                        if (identityMapLocked) {
                            this.checkAndRefreshInvalidObject(cached, cacheKey, descriptor);
                        } else if (this.objectsLockedForClone == null) {
                            if (descriptor.shouldAcquireCascadedLocks()) {
                                this.objectsLockedForClone = this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireLocksForClone(cached, descriptor, cacheKey, this);
                            } else {
                                this.checkAndRefreshInvalidObject(cached, cacheKey, descriptor);
                                cacheKey.acquireReadLock();
                            }
                            rootOfCloneRecursion = true;
                        }
                        key = cacheKey.getKey();
                        lockValue = cacheKey.getWriteLockValue();
                        readTime = cacheKey.getReadTime();
                    }
                    if (descriptor.hasInheritance()) {
                        descriptor = this.getClassDescriptor(cached.getClass());
                    }
                    ObjectBuilder builder = descriptor.getObjectBuilder();
                    Object workingClone = builder.instantiateWorkingCopyClone(cached, this);
                    builder.populateAttributesForClone(cached, cacheKey, workingClone, this);
                    this.getIdentityMapAccessorInstance().putInIdentityMap(workingClone, key, lockValue, readTime, descriptor);
                    object = workingClone;
                    Object var15_13 = null;
                    if (!rootOfCloneRecursion) break block15;
                    if (this.objectsLockedForClone == null && cacheKey != null) {
                        cacheKey.releaseReadLock();
                        break block16;
                    }
                    iterator2 = this.objectsLockedForClone.values().iterator();
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var15_14 = null;
                        if (!rootOfCloneRecursion) break block17;
                        if (this.objectsLockedForClone == null && cacheKey != null) {
                            cacheKey.releaseReadLock();
                        } else {
                            Iterator iterator2 = this.objectsLockedForClone.values().iterator();
                            while (iterator2.hasNext()) {
                                ((CacheKey)iterator2.next()).releaseReadLock();
                            }
                            this.objectsLockedForClone = null;
                        }
                        this.executeDeferredEvents();
                    }
                    throw throwable;
                }
                while (iterator2.hasNext()) {
                    ((CacheKey)iterator2.next()).releaseReadLock();
                }
                this.objectsLockedForClone = null;
            }
            this.executeDeferredEvents();
        }
        return object;
    }

    public void checkAndRefreshInvalidObject(Object object, CacheKey cacheKey, ClassDescriptor descriptor) {
        if (this.isConsideredInvalid(object, cacheKey, descriptor)) {
            ReadObjectQuery query = new ReadObjectQuery();
            query.setReferenceClass(object.getClass());
            query.setSelectionId(cacheKey.getKey());
            query.refreshIdentityMapResult();
            query.setIsExecutionClone(true);
            this.executeQuery(query);
        }
    }

    public boolean isConsideredInvalid(Object object, CacheKey cacheKey, ClassDescriptor descriptor) {
        if (cacheKey.getObject() != null) {
            CacheInvalidationPolicy cachePolicy = descriptor.getCacheInvalidationPolicy();
            return cachePolicy.shouldRefreshInvalidObjectsOnClone() && cachePolicy.isInvalidated(cacheKey);
        }
        return false;
    }

    public void deferEvent(DescriptorEvent event) {
        if (this.deferredEvents == null) {
            this.deferredEvents = new ArrayList<DescriptorEvent>();
        }
        this.deferredEvents.add(event);
    }

    public void deleteAllObjects(Collection domainObjects) throws DatabaseException, OptimisticLockException {
        Iterator objectsEnum = domainObjects.iterator();
        while (objectsEnum.hasNext()) {
            this.deleteObject(objectsEnum.next());
        }
    }

    public void deleteAllObjects(Vector domainObjects) throws DatabaseException, OptimisticLockException {
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            this.deleteObject(objectsEnum.nextElement());
        }
    }

    public Object deleteObject(Object domainObject) throws DatabaseException, OptimisticLockException {
        DeleteObjectQuery query = new DeleteObjectQuery();
        query.setObject(domainObject);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public boolean doesObjectExist(Object object) throws DatabaseException {
        DoesExistQuery query = new DoesExistQuery();
        query.setObject(object);
        query.checkDatabaseForDoesExist();
        query.setIsExecutionClone(true);
        return (Boolean)this.executeQuery(query);
    }

    @Override
    public void dontLogMessages() {
        this.setLogLevel(8);
    }

    public void endOperationProfile(String operationName) {
        if (this.isInProfile) {
            this.getProfiler().endOperationProfile(operationName);
        }
    }

    public void endOperationProfile(String operationName, DatabaseQuery query, int weight) {
        if (this.isInProfile) {
            this.getProfiler().endOperationProfile(operationName, query, weight);
        }
    }

    public void updateProfile(String operationName, Object value) {
        if (this.isInProfile) {
            this.getProfiler().update(operationName, value);
        }
    }

    public void incrementProfile(String operationName) {
        if (this.isInProfile) {
            this.getProfiler().occurred(operationName);
        }
    }

    public void incrementProfile(String operationName, DatabaseQuery query) {
        if (this.isInProfile) {
            this.getProfiler().occurred(operationName, query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDeferredEvents() {
        if (!this.isExecutingEvents && this.deferredEvents != null) {
            this.isExecutingEvents = true;
            try {
                for (int i = 0; i < this.deferredEvents.size(); ++i) {
                    DescriptorEvent event = this.deferredEvents.get(i);
                    event.getDescriptor().getEventManager().executeEvent(event);
                }
                this.deferredEvents.clear();
                Object var4_3 = null;
                this.isExecutingEvents = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.isExecutingEvents = false;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        if (query.getAccessors() == null) {
            query.setAccessors(this.getAccessors());
        }
        try {
            Object object = this.basicExecuteCall(call, translationRow, query);
            Object var6_5 = null;
            if (call.isFinished()) {
                query.setAccessors(null);
            }
            return object;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_6 = null;
                if (!call.isFinished()) break block4;
                query.setAccessors(null);
            }
            throw throwable;
        }
    }

    @Override
    public int executeNonSelectingCall(Call call) throws DatabaseException {
        DataModifyQuery query = new DataModifyQuery();
        query.setIsExecutionClone(true);
        query.setCall(call);
        Integer value = (Integer)this.executeQuery(query);
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    public void executeNonSelectingSQL(String sqlString) throws DatabaseException {
        this.executeNonSelectingCall(new SQLCall(sqlString));
    }

    @Override
    public Object executeQuery(String queryName) throws DatabaseException {
        DatabaseQuery query = this.getQuery(queryName);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName);
        }
        return this.executeQuery(query);
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass) throws DatabaseException {
        ClassDescriptor descriptor = this.getDescriptor(domainClass);
        if (descriptor == null) {
            throw QueryException.descriptorIsMissingForNamedQuery(domainClass, queryName);
        }
        DatabaseQuery query = descriptor.getQueryManager().getQuery(queryName);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName, domainClass);
        }
        return this.executeQuery(query);
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass, Object arg1) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        return this.executeQuery(queryName, domainClass, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass, Object arg1, Object arg2) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        return this.executeQuery(queryName, domainClass, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass, Object arg1, Object arg2, Object arg3) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        argumentValues.addElement(arg3);
        return this.executeQuery(queryName, domainClass, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass, List argumentValues) throws DatabaseException {
        if (argumentValues instanceof Vector) {
            return this.executeQuery(queryName, domainClass, (Vector)argumentValues);
        }
        return this.executeQuery(queryName, domainClass, new Vector(argumentValues));
    }

    public Object executeQuery(String queryName, Class domainClass, Vector argumentValues) throws DatabaseException {
        ClassDescriptor descriptor = this.getDescriptor(domainClass);
        if (descriptor == null) {
            throw QueryException.descriptorIsMissingForNamedQuery(domainClass, queryName);
        }
        DatabaseQuery query = descriptor.getQueryManager().getQuery(queryName, argumentValues);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName, domainClass);
        }
        return this.executeQuery(query, (List)argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Object arg1) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        return this.executeQuery(queryName, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Object arg1, Object arg2) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        return this.executeQuery(queryName, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Object arg1, Object arg2, Object arg3) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        argumentValues.addElement(arg3);
        return this.executeQuery(queryName, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, List argumentValues) throws DatabaseException {
        if (argumentValues instanceof Vector) {
            return this.executeQuery(queryName, (Vector)argumentValues);
        }
        return this.executeQuery(queryName, new Vector(argumentValues));
    }

    public Object executeQuery(String queryName, Vector argumentValues) throws DatabaseException {
        DatabaseQuery query = this.getQuery(queryName, argumentValues);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName);
        }
        return this.executeQuery(query, (List)argumentValues);
    }

    @Override
    public Object executeQuery(DatabaseQuery query) throws DatabaseException {
        return this.executeQuery(query, EmptyRecord.getEmptyRecord());
    }

    @Override
    public Object executeQuery(DatabaseQuery query, List argumentValues) throws DatabaseException {
        if (query == null) {
            throw QueryException.queryNotDefined();
        }
        AbstractRecord row = query.rowFromArguments(argumentValues, this);
        return this.executeQuery(query, row);
    }

    public Object executeQuery(DatabaseQuery query, AbstractRecord row) throws DatabaseException {
        if (this.hasBroker() && (!query.isDataModifyQuery() && !query.isDataReadQuery() || query.getSessionName() != null)) {
            return this.getBroker().executeQuery(query, row);
        }
        if (query == null) {
            throw QueryException.queryNotDefined();
        }
        this.log(1, "query", "execute_query", query);
        return this.executeQuery(query, row, 0);
    }

    public Object executeQuery(DatabaseQuery query, AbstractRecord row, int retryCount) throws DatabaseException {
        try {
            if (this.eventManager != null) {
                this.eventManager.preExecuteQuery(query);
            }
            Object result = this.isInProfile() ? this.getProfiler().profileExecutionOfQuery(query, row, this) : this.internalExecuteQuery(query, row);
            if (this.eventManager != null) {
                this.eventManager.postExecuteQuery(query, result);
            }
            return result;
        }
        catch (RuntimeException exception2) {
            DatabaseException exception2;
            if (exception2 instanceof QueryException) {
                QueryException queryException = (QueryException)exception2;
                if (queryException.getQuery() == null) {
                    queryException.setQuery(query);
                }
                if (queryException.getQueryArgumentsRecord() == null) {
                    queryException.setQueryArguments(row);
                }
                if (queryException.getSession() == null) {
                    queryException.setSession(this);
                }
            } else if (exception2 instanceof DatabaseException) {
                DatabaseException databaseException = (DatabaseException)exception2;
                if (databaseException.getQuery() == null) {
                    databaseException.setQuery(query);
                }
                if (databaseException.getQueryArgumentsRecord() == null) {
                    databaseException.setQueryArguments(row);
                }
                if (databaseException.getSession() == null) {
                    databaseException.setSession(this);
                }
                if (!this.isInTransaction() && query.isReadQuery() && databaseException.isCommunicationFailure()) {
                    this.log(5, "communication_failure_attempting_query_retry", (Object[])null, null);
                    if (this.getClass().isAssignableFrom(DatabaseSessionImpl.class)) {
                        while (retryCount < this.getLogin().getQueryRetryAttemptCount()) {
                            try {
                                databaseException.getAccessor().reestablishConnection(this);
                            }
                            catch (DatabaseException ex) {
                                ++retryCount;
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                                    this.log(5, "communication_failure_attempting_query_retry", (Object[])null, null);
                                    continue;
                                }
                                catch (InterruptedException intEx) {}
                            }
                            break;
                        }
                    }
                    if (retryCount <= this.getLogin().getQueryRetryAttemptCount()) {
                        try {
                            ++retryCount;
                            try {
                                if (retryCount > 1) {
                                    Thread.currentThread();
                                    Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                                }
                                return this.executeQuery(query, row, retryCount);
                            }
                            catch (DatabaseException ex) {
                                exception2 = ex;
                            }
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.handleException(exception2);
        }
    }

    @Override
    public Vector executeSelectingCall(Call call) throws DatabaseException {
        DataReadQuery query = new DataReadQuery();
        query.setCall(call);
        query.setIsExecutionClone(true);
        return (Vector)this.executeQuery(query);
    }

    @Override
    public Vector executeSQL(String sqlString) throws DatabaseException {
        return this.executeSelectingCall(new SQLCall(sqlString));
    }

    public Accessor getAccessor() {
        Collection<Accessor> accessors = this.getAccessors();
        if (accessors == null || accessors.isEmpty()) {
            return null;
        }
        if (accessors instanceof List) {
            return (Accessor)((List)accessors).get(0);
        }
        return accessors.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Accessor> getAccessors() {
        if (this.accessors == null && this.project != null && this.project.getDatasourceLogin() != null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.accessors == null && this.project != null && this.project.getDatasourceLogin() != null) {
                    ArrayList<Accessor> newAccessors = new ArrayList<Accessor>(1);
                    newAccessors.add(this.project.getDatasourceLogin().buildAccessor());
                    this.accessors = newAccessors;
                }
            }
        }
        return this.accessors;
    }

    public Collection<Accessor> getAccessors(Call call, AbstractRecord translationRow, DatabaseQuery query) {
        List<Accessor> accessors = null;
        if (query.getPartitioningPolicy() != null && (accessors = query.getPartitioningPolicy().getConnectionsForQuery(this, query, translationRow)) != null) {
            return accessors;
        }
        ClassDescriptor descriptor = query.getDescriptor();
        if (descriptor != null && descriptor.getPartitioningPolicy() != null && (accessors = descriptor.getPartitioningPolicy().getConnectionsForQuery(this, query, translationRow)) != null) {
            return accessors;
        }
        if (this.partitioningPolicy != null && (accessors = this.partitioningPolicy.getConnectionsForQuery(this, query, translationRow)) != null) {
            return accessors;
        }
        if (accessors == null) {
            return this.getAccessors();
        }
        return accessors;
    }

    public Object basicExecuteCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        Object result = null;
        if (query.getAccessors().size() == 1) {
            result = query.getAccessor().executeCall(call, translationRow, this);
        } else {
            RuntimeException exception = null;
            for (Accessor accessor : query.getAccessors()) {
                Object object;
                block10: {
                    object = null;
                    try {
                        object = accessor.executeCall(call, translationRow, this);
                    }
                    catch (RuntimeException failed) {
                        if (exception != null) break block10;
                        exception = failed;
                    }
                }
                if (call.isOneRowReturned()) {
                    if (object == null) continue;
                    result = object;
                    break;
                }
                if (call.isNothingReturned()) {
                    if (result == null) {
                        result = object;
                        continue;
                    }
                    if (!(object instanceof Integer) || (Integer)result == 0 || (Integer)object == 0) continue;
                    result = object;
                    continue;
                }
                if (result == null) {
                    result = object;
                    continue;
                }
                if (!(object instanceof List)) break;
                ((List)result).addAll((List)object);
            }
            if (exception != null) {
                throw exception;
            }
        }
        return result;
    }

    public ExposedNodeLinkedList getActiveCommandThreads() {
        if (this.activeCommandThreads == null) {
            this.activeCommandThreads = new ExposedNodeLinkedList();
        }
        return this.activeCommandThreads;
    }

    @Override
    public Session getActiveSession() {
        Session activeSession = this.getActiveUnitOfWork();
        if (activeSession == null) {
            activeSession = this;
        }
        return activeSession;
    }

    @Override
    public UnitOfWork getActiveUnitOfWork() {
        if (this.hasExternalTransactionController()) {
            return this.getExternalTransactionController().getActiveUnitOfWork();
        }
        if (this.isClientSession()) {
            return ((ClientSession)this).getParent().getActiveUnitOfWork();
        }
        return null;
    }

    public Map getAliasDescriptors() {
        return this.project.getAliasDescriptors();
    }

    @Override
    public AsOfClause getAsOfClause() {
        return null;
    }

    public AbstractSession getBroker() {
        return this.broker;
    }

    public AbstractSession getRootSession(DatabaseQuery query) {
        ClassDescriptor descriptor = null;
        if (query != null) {
            descriptor = query.getDescriptor();
        }
        return this.getParentIdentityMapSession(descriptor, true, true);
    }

    public AbstractSession getParent() {
        return null;
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query) {
        ClassDescriptor descriptor = null;
        if (query != null) {
            descriptor = query.getDescriptor();
        }
        return this.getParentIdentityMapSession(descriptor, false, false);
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        ClassDescriptor descriptor = null;
        if (query != null) {
            descriptor = query.getDescriptor();
        }
        return this.getParentIdentityMapSession(descriptor, canReturnSelf, terminalOnly);
    }

    public AbstractSession getParentIdentityMapSession(ClassDescriptor descriptor, boolean canReturnSelf, boolean terminalOnly) {
        return this;
    }

    public Integer getPessimisticLockTimeoutDefault() {
        return this.pessimisticLockTimeoutDefault;
    }

    public int getQueryTimeoutDefault() {
        return this.queryTimeoutDefault;
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        return this;
    }

    public boolean hasCommitManager() {
        return this.commitManager != null;
    }

    public CommitManager getCommitManager() {
        if (this.hasBroker()) {
            return this.getBroker().getCommitManager();
        }
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this);
        }
        return this.commitManager;
    }

    public Vector getDefaultReadOnlyClasses() {
        if (this.hasBroker()) {
            return this.getBroker().getDefaultReadOnlyClasses();
        }
        return this.getProject().getDefaultReadOnlyClasses();
    }

    @Override
    public ClassDescriptor getClassDescriptor(Class theClass) {
        if (theClass == null) {
            return null;
        }
        return this.getDescriptor(theClass);
    }

    @Override
    public ClassDescriptor getClassDescriptor(Object domainObject) {
        if (domainObject == null) {
            return null;
        }
        return this.getDescriptor(domainObject);
    }

    @Override
    public ClassDescriptor getClassDescriptorForAlias(String alias) {
        return this.project.getDescriptorForAlias(alias);
    }

    @Override
    public ClassDescriptor getDescriptor(Class theClass) {
        if (theClass == null) {
            return null;
        }
        ClassDescriptor descriptor = this.lastDescriptorAccessed;
        if (descriptor != null && descriptor.getJavaClass() == theClass) {
            return descriptor;
        }
        descriptor = this.descriptors != null ? this.descriptors.get(theClass) : this.project.getDescriptors().get(theClass);
        if (descriptor == null) {
            if (this.hasBroker()) {
                descriptor = this.getBroker().getDescriptor(theClass);
            }
            if (descriptor == null) {
                if (this.eventManager != null) {
                    this.eventManager.missingDescriptor(theClass);
                }
                if ((descriptor = this.getDescriptors().get(theClass)) == null && !theClass.isInterface()) {
                    Class<?>[] interfaces = theClass.getInterfaces();
                    for (int index = 0; index < interfaces.length; ++index) {
                        Class<?> interfaceClass = interfaces[index];
                        descriptor = this.getDescriptor(interfaceClass);
                        if (descriptor == null) continue;
                        this.getDescriptors().put(interfaceClass, descriptor);
                        break;
                    }
                    if (descriptor == null) {
                        descriptor = this.checkHierarchyForDescriptor(theClass);
                    }
                }
            }
        }
        this.lastDescriptorAccessed = descriptor;
        return descriptor;
    }

    @Override
    public ClassDescriptor getDescriptor(Object domainObject) {
        if (domainObject == null) {
            return null;
        }
        if (this.project.hasProxyIndirection()) {
            return this.getDescriptor(ProxyIndirectionPolicy.getValueFromProxy(domainObject).getClass());
        }
        return this.getDescriptor(domainObject.getClass());
    }

    @Override
    public ClassDescriptor getDescriptorForAlias(String alias) {
        return this.project.getDescriptorForAlias(alias);
    }

    @Override
    public Map<Class, ClassDescriptor> getDescriptors() {
        return this.project.getDescriptors();
    }

    @Override
    public List<DatabaseQuery> getJPAQueries() {
        if (this.jpaQueries == null) {
            this.jpaQueries = new Vector<DatabaseQuery>();
        }
        return this.jpaQueries;
    }

    public void processJPAQueries() {
        for (DatabaseQuery jpaQuery : this.getJPAQueries()) {
            jpaQuery.checkPrepare(this, null);
            DatabaseQuery databaseQuery = (DatabaseQuery)jpaQuery.getProperty("databasequery");
            this.addQuery(databaseQuery.getName(), databaseQuery);
        }
        this.getJPAQueries().clear();
    }

    public boolean hasEventManager() {
        return this.eventManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionEventManager getEventManager() {
        if (this.eventManager == null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.eventManager == null) {
                    this.eventManager = new SessionEventManager(this);
                }
            }
        }
        return this.eventManager;
    }

    public String getExceptionHandlerClass() {
        String className = null;
        try {
            className = this.getExceptionHandler().getClass().getName();
        }
        catch (Exception exception) {
            return null;
        }
        return className;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public ExternalTransactionController getExternalTransactionController() {
        return this.externalTransactionController;
    }

    @Override
    public org.eclipse.persistence.sessions.IdentityMapAccessor getIdentityMapAccessor() {
        return this.identityMapAccessor;
    }

    public IdentityMapAccessor getIdentityMapAccessorInstance() {
        return this.identityMapAccessor;
    }

    @Override
    public IntegrityChecker getIntegrityChecker() {
        if (this.integrityChecker == null) {
            this.integrityChecker = new IntegrityChecker();
        }
        return this.integrityChecker;
    }

    @Override
    public Writer getLog() {
        return this.getSessionLog().getWriter();
    }

    public String getLogSessionString() {
        if (this.logSessionString == null) {
            StringWriter writer = new StringWriter();
            writer.write(this.getSessionTypeString());
            writer.write("(");
            writer.write(String.valueOf(System.identityHashCode(this)));
            writer.write(")");
            this.logSessionString = writer.toString();
        }
        return this.logSessionString;
    }

    public String getSessionTypeString() {
        return Helper.getShortClassName(this.getClass());
    }

    public String getStaticMetamodelClass(String modelClassName) {
        if (this.staticMetamodelClasses != null) {
            return this.staticMetamodelClasses.get(modelClassName);
        }
        return null;
    }

    @Override
    public DatabaseLogin getLogin() {
        try {
            return (DatabaseLogin)this.getDatasourceLogin();
        }
        catch (ClassCastException wrongType) {
            throw ValidationException.notSupportedForDatasource();
        }
    }

    @Override
    public Login getDatasourceLogin() {
        if (this.project == null) {
            return null;
        }
        return this.project.getDatasourceLogin();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Number getNextSequenceNumberValue(Class domainClass) {
        return (Number)this.getSequencing().getNextValue(domainClass);
    }

    public int getNumberOfActiveUnitsOfWork() {
        return this.numberOfActiveUnitsOfWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheKey getCacheKeyFromTargetSessionForMerge(Object implementation, ObjectBuilder builder, ClassDescriptor descriptor, MergeManager mergeManager) {
        Object original = null;
        Object primaryKey = builder.extractPrimaryKeyFromObject(implementation, this, true);
        if (primaryKey == null) {
            return null;
        }
        CacheKey cacheKey = null;
        if (mergeManager == null) {
            cacheKey = this.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, implementation.getClass(), descriptor);
            if (cacheKey != null) {
                cacheKey.checkReadLock();
            }
            return cacheKey;
        }
        cacheKey = this.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, implementation.getClass(), descriptor);
        if (cacheKey != null) {
            if (cacheKey.acquireReadLockNoWait()) {
                original = cacheKey.getObject();
                cacheKey.releaseReadLock();
            } else {
                if (!mergeManager.isTransitionedToDeferredLocks()) {
                    this.getIdentityMapAccessorInstance().getWriteLockManager().transitionToDeferredLocks(mergeManager);
                }
                cacheKey.acquireDeferredLock();
                original = cacheKey.getObject();
                if (original == null) {
                    ConcurrencyManager concurrencyManager = cacheKey.getMutex();
                    synchronized (concurrencyManager) {
                        if (cacheKey.isAcquired()) {
                            try {
                                cacheKey.getMutex().wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        original = cacheKey.getObject();
                    }
                }
                cacheKey.releaseDeferredLock();
            }
        }
        return cacheKey;
    }

    @Override
    public DatabasePlatform getPlatform() {
        if (this.platform == null) {
            this.platform = this.getDatasourceLogin().getPlatform();
        }
        return (DatabasePlatform)this.platform;
    }

    public ClassLoader getLoader() {
        return this.getDatasourcePlatform().getConversionManager().getLoader();
    }

    @Override
    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            this.platform = this.getDatasourceLogin().getDatasourcePlatform();
        }
        return this.platform;
    }

    @Override
    public ServerPlatform getServerPlatform() {
        return null;
    }

    public Platform getPlatform(Class domainClass) {
        if (this.platform == null) {
            this.platform = this.getDatasourcePlatform();
        }
        return this.platform;
    }

    @Override
    public SessionProfiler getProfiler() {
        return this.profiler;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>(5);
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.getProperties().get(name);
    }

    @Override
    public Map<String, List<DatabaseQuery>> getQueries() {
        if (this.queries == null) {
            this.queries = new HashMap<String, List<DatabaseQuery>>(5);
        }
        return this.queries;
    }

    public List<DatabaseQuery> getAllQueries() {
        Vector<DatabaseQuery> allQueries = new Vector<DatabaseQuery>();
        Iterator<List<DatabaseQuery>> vectors = this.getQueries().values().iterator();
        while (vectors.hasNext()) {
            allQueries.addAll((Vector)vectors.next());
        }
        return allQueries;
    }

    @Override
    public DatabaseQuery getQuery(String name) {
        return this.getQuery(name, null);
    }

    @Override
    public DatabaseQuery getQuery(String name, List arguments) {
        if (arguments instanceof Vector) {
            return this.getQuery(name, (Vector)arguments);
        }
        return this.getQuery(name, new Vector(arguments));
    }

    public DatabaseQuery getQuery(String name, Vector arguments) {
        Vector queries = (Vector)this.getQueries().get(name);
        if (queries == null || queries.isEmpty()) {
            return null;
        }
        if (queries.size() == 1) {
            return (DatabaseQuery)queries.firstElement();
        }
        int argumentTypesSize = 0;
        if (arguments != null) {
            argumentTypesSize = arguments.size();
        }
        Vector argumentTypes = new Vector(argumentTypesSize);
        for (int i = 0; i < argumentTypesSize; ++i) {
            argumentTypes.addElement(arguments.elementAt(i).getClass());
        }
        Enumeration queriesEnum = queries.elements();
        while (queriesEnum.hasMoreElements()) {
            DatabaseQuery query = (DatabaseQuery)queriesEnum.nextElement();
            if (!Helper.areTypesAssignable(argumentTypes, query.getArgumentTypes())) continue;
            return query;
        }
        return null;
    }

    public Sequencing getSequencing() {
        return null;
    }

    public AbstractSession getSessionForClass(Class domainClass) {
        if (this.hasBroker()) {
            return this.getBroker().getSessionForClass(domainClass);
        }
        return this;
    }

    @Override
    public SessionLog getSessionLog() {
        if (this.sessionLog == null) {
            this.setSessionLog(new DefaultSessionLog());
        }
        return this.sessionLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrencyManager getTransactionMutex() {
        if (this.transactionMutex == null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.transactionMutex == null) {
                    this.transactionMutex = new ConcurrencyManager();
                }
            }
        }
        return this.transactionMutex;
    }

    @Override
    public Object handleException(RuntimeException exception) throws RuntimeException {
        if (exception instanceof EclipseLinkException) {
            EclipseLinkException eclipseLinkException = (EclipseLinkException)exception;
            if (eclipseLinkException.getSession() == null) {
                eclipseLinkException.setSession(this);
            }
            if (!eclipseLinkException.hasBeenLogged()) {
                this.logThrowable(6, null, exception);
                eclipseLinkException.setHasBeenLogged(true);
            }
        } else {
            this.logThrowable(6, null, exception);
        }
        if (this.hasExceptionHandler()) {
            return this.getExceptionHandler().handleException(exception);
        }
        throw exception;
    }

    public boolean hasBroker() {
        return this.broker != null;
    }

    @Override
    public boolean hasDescriptor(Class theClass) {
        if (theClass == null) {
            return false;
        }
        return this.getDescriptors().get(theClass) != null;
    }

    @Override
    public boolean hasExceptionHandler() {
        return this.exceptionHandler != null;
    }

    @Override
    public boolean hasExternalTransactionController() {
        return this.externalTransactionController != null;
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new IdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public Object insertObject(Object domainObject) throws DatabaseException {
        InsertObjectQuery query = new InsertObjectQuery();
        query.setObject(domainObject);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord databaseRow) throws DatabaseException {
        return query.execute(this, databaseRow);
    }

    public boolean isBroker() {
        return false;
    }

    public boolean isInBroker() {
        return this.isInBroker;
    }

    public boolean isClassReadOnly(Class theClass) {
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        return this.isClassReadOnly(theClass, descriptor);
    }

    public boolean isClassReadOnly(Class theClass, ClassDescriptor descriptor) {
        if (descriptor != null && descriptor.shouldBeReadOnly()) {
            return true;
        }
        if (theClass != null) {
            return this.getDefaultReadOnlyClasses().contains(theClass);
        }
        return false;
    }

    @Override
    public boolean isClientSession() {
        return false;
    }

    public boolean isIsolatedClientSession() {
        return false;
    }

    public boolean isExclusiveIsolatedClientSession() {
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this.getAccessor() == null) {
            return false;
        }
        return this.getAccessor().isConnected();
    }

    @Override
    public boolean isDatabaseSession() {
        return false;
    }

    @Override
    public boolean isDistributedSession() {
        return false;
    }

    @Override
    public boolean isInProfile() {
        return this.isInProfile;
    }

    public void setIsInProfile(boolean inProfile) {
        this.isInProfile = inProfile;
    }

    public void setIsInBroker(boolean isInBroker) {
        this.isInBroker = isInBroker;
    }

    @Override
    public boolean isFinalizersEnabled() {
        return this.isFinalizersEnabled;
    }

    public void registerFinalizer() {
        this.setProperty("finalizer", new SessionFinalizer(this));
    }

    public boolean isHistoricalSession() {
        return false;
    }

    @Override
    public void setIsFinalizersEnabled(boolean isFinalizersEnabled) {
        this.isFinalizersEnabled = isFinalizersEnabled;
    }

    public boolean isInTransaction() {
        return this.transactionMutex != null && this.transactionMutex.isAcquired();
    }

    public boolean isProtectedSession() {
        return true;
    }

    @Override
    public boolean isRemoteSession() {
        return false;
    }

    @Override
    public boolean isRemoteUnitOfWork() {
        return false;
    }

    @Override
    public boolean isServerSession() {
        return false;
    }

    @Override
    public boolean isSessionBroker() {
        return false;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    @Override
    public boolean isUnitOfWork() {
        return false;
    }

    @Override
    public Object getId(Object domainObject) throws ValidationException {
        ClassDescriptor descriptor = this.getDescriptor(domainObject);
        return this.keyFromObject(domainObject, descriptor);
    }

    @Override
    @Deprecated
    public Vector keyFromObject(Object domainObject) throws ValidationException {
        ClassDescriptor descriptor = this.getDescriptor(domainObject);
        return (Vector)this.keyFromObject(domainObject, descriptor);
    }

    public Object keyFromObject(Object domainObject, ClassDescriptor descriptor) throws ValidationException {
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(domainObject.getClass().getName());
        }
        Object implemention = descriptor.getObjectBuilder().unwrapObject(domainObject, this);
        if (implemention == null) {
            return null;
        }
        return descriptor.getObjectBuilder().extractPrimaryKeyFromObject(implemention, this);
    }

    @Override
    public void log(SessionLogEntry entry) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            if (entry.getSession() == null) {
                entry.setSession(this);
            }
            this.getSessionLog().log(entry);
        }
    }

    @Override
    public void logMessage(String message) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(2, message, (Object[])null, null, false);
    }

    public DatabaseQuery prepareDatabaseQuery(DatabaseQuery query) {
        if (!this.isUnitOfWork() && query.isObjectLevelReadQuery()) {
            return ((ObjectLevelReadQuery)query).prepareOutsideUnitOfWork(this);
        }
        return query;
    }

    @Override
    public Vector readAllObjects(Class domainClass) throws DatabaseException {
        ReadAllQuery query = new ReadAllQuery();
        query.setIsExecutionClone(true);
        query.setReferenceClass(domainClass);
        return (Vector)this.executeQuery(query);
    }

    public Vector readAllObjects(Class domainClass, String sqlString) throws DatabaseException {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(domainClass);
        query.setSQLString(sqlString);
        query.setIsExecutionClone(true);
        return (Vector)this.executeQuery(query);
    }

    @Override
    public Vector readAllObjects(Class referenceClass, Call aCall) throws DatabaseException {
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(referenceClass);
        raq.setCall(aCall);
        raq.setIsExecutionClone(true);
        return (Vector)this.executeQuery(raq);
    }

    @Override
    public Vector readAllObjects(Class domainClass, Expression expression) throws DatabaseException {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(domainClass);
        query.setSelectionCriteria(expression);
        query.setIsExecutionClone(true);
        return (Vector)this.executeQuery(query);
    }

    @Override
    public Object readObject(Class domainClass) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    public Object readObject(Class domainClass, String sqlString) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setSQLString(sqlString);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public Object readObject(Class domainClass, Call aCall) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setCall(aCall);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public Object readObject(Class domainClass, Expression expression) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setSelectionCriteria(expression);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public Object readObject(Object object) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject(object);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    public Object refreshAndLockObject(Object object) throws DatabaseException {
        return this.refreshAndLockObject(object, (short)1);
    }

    public Object refreshAndLockObject(Object object, short lockMode) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject(object);
        query.refreshIdentityMapResult();
        query.cascadePrivateParts();
        query.setLockMode(lockMode);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public Object refreshObject(Object object) throws DatabaseException {
        return this.refreshAndLockObject(object, (short)0);
    }

    @Override
    public void release() {
    }

    public void releaseUnitOfWork(UnitOfWorkImpl unitOfWork) {
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() - 1);
    }

    @Override
    public void removeProperty(String property) {
        this.getProperties().remove(property);
    }

    @Override
    public void removeQuery(String queryName) {
        this.getQueries().remove(queryName);
    }

    public void removeQuery(String queryName, Vector argumentTypes) {
        Vector queries = (Vector)this.getQueries().get(queryName);
        if (queries == null) {
            return;
        }
        DatabaseQuery query = null;
        Enumeration enumtr = queries.elements();
        while (enumtr.hasMoreElements() && !Helper.areTypesAssignable(argumentTypes, (query = (DatabaseQuery)enumtr.nextElement()).getArgumentTypes())) {
        }
        if (query != null) {
            queries.remove(query);
        }
    }

    protected boolean rollbackExternalTransaction() {
        boolean externalTransactionHasRolledBack = false;
        if (this.hasExternalTransactionController() && this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().rollbackTransaction(this);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
            if (!this.wasJTSTransactionInternallyStarted()) {
                externalTransactionHasRolledBack = true;
                this.log(2, "transaction", "external_transaction_has_rolled_back_internally");
            }
        }
        return externalTransactionHasRolledBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() throws DatabaseException, ConcurrencyException {
        ConcurrencyManager mutex = this.getTransactionMutex();
        try {
            if (!mutex.isNested()) {
                if (this.eventManager != null) {
                    this.eventManager.preRollbackTransaction();
                }
                this.basicRollbackTransaction();
                if (this.eventManager != null) {
                    this.eventManager.postRollbackTransaction();
                }
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            mutex.release();
            if (!mutex.isAcquired()) {
                this.rollbackExternalTransaction();
            }
            throw throwable;
        }
        mutex.release();
        if (!mutex.isAcquired()) {
            this.rollbackExternalTransaction();
        }
    }

    public void setAccessor(Accessor accessor) {
        this.accessors = new ArrayList<Accessor>(1);
        this.accessors.add(accessor);
    }

    public void setBroker(AbstractSession broker) {
        this.broker = broker;
    }

    public void setCommitManager(CommitManager commitManager) {
        this.commitManager = commitManager;
    }

    public void setEventManager(SessionEventManager eventManager) {
        this.eventManager = eventManager;
        if (eventManager != null) {
            this.eventManager.setSession(this);
        }
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void setExternalTransactionController(ExternalTransactionController externalTransactionController) {
        this.externalTransactionController = externalTransactionController;
        if (externalTransactionController == null) {
            return;
        }
        externalTransactionController.setSession(this);
    }

    @Override
    public void setIntegrityChecker(IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
    }

    @Override
    public void setLog(Writer log) {
        this.getSessionLog().setWriter(log);
    }

    public void setLogin(DatabaseLogin login) {
        this.setDatasourceLogin(login);
    }

    public void setLogin(Login login) {
        this.setDatasourceLogin(login);
    }

    public void setDatasourceLogin(Login login) {
        this.getProject().setDatasourceLogin(login);
        this.platform = null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected void setNumberOfActiveUnitsOfWork(int numberOfActiveUnitsOfWork) {
        this.numberOfActiveUnitsOfWork = numberOfActiveUnitsOfWork;
    }

    public void setPessimisticLockTimeoutDefault(Integer pessimisticLockTimeoutDefault) {
        this.pessimisticLockTimeoutDefault = pessimisticLockTimeoutDefault;
    }

    @Override
    public void setQueryTimeoutDefault(int queryTimeoutDefault) {
        this.queryTimeoutDefault = queryTimeoutDefault;
    }

    @Override
    public void setProfiler(SessionProfiler profiler) {
        this.profiler = profiler;
        if (profiler != null) {
            profiler.setSession(this);
            this.setIsInProfile(this.getProfiler().getProfileWeight() != 0);
            this.getIdentityMapAccessorInstance().getIdentityMapManager().checkIsCacheAccessPreCheckRequired();
        } else {
            this.setIsInProfile(false);
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setProperties(Map<Object, Object> propertiesMap) {
        if (null == propertiesMap) {
            this.properties = propertiesMap;
        } else {
            this.properties = new HashMap<Object, Object>();
            this.properties.putAll(propertiesMap);
        }
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        this.getProperties().put(propertyName, propertyValue);
    }

    protected void setQueries(Map<String, List<DatabaseQuery>> queries) {
        this.queries = queries;
    }

    @Override
    public void setSessionLog(SessionLog sessionLog) {
        this.isLoggingOff = false;
        this.sessionLog = sessionLog;
        if (sessionLog != null && sessionLog.getSession() == null) {
            sessionLog.setSession(this);
        }
    }

    public void setSynchronized(boolean synched) {
        this.isSynchronized = synched;
    }

    protected void setTransactionMutex(ConcurrencyManager transactionMutex) {
        this.transactionMutex = transactionMutex;
    }

    public void setWasJTSTransactionInternallyStarted(boolean wasJTSTransactionInternallyStarted) {
        this.wasJTSTransactionInternallyStarted = wasJTSTransactionInternallyStarted;
    }

    @Override
    public boolean shouldLogMessages() {
        if (this.isLoggingOff) {
            return false;
        }
        return this.getLogLevel(null) != 8;
    }

    public void startOperationProfile(String operationName) {
        if (this.isInProfile) {
            this.getProfiler().startOperationProfile(operationName);
        }
    }

    public void startOperationProfile(String operationName, DatabaseQuery query, int weight) {
        if (this.isInProfile) {
            this.getProfiler().startOperationProfile(operationName, query, weight);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(this.getSessionTypeString() + "(" + Helper.cr() + "\t" + this.getAccessor() + Helper.cr() + "\t" + this.getDatasourcePlatform() + ")");
        return writer.toString();
    }

    public Object unwrapObject(Object proxy) {
        return this.getDescriptor(proxy).getObjectBuilder().unwrapObject(proxy, this);
    }

    public Object updateObject(Object domainObject) throws DatabaseException, OptimisticLockException {
        UpdateObjectQuery query = new UpdateObjectQuery();
        query.setObject(domainObject);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public void validateCache() {
        this.getIdentityMapAccessorInstance().validateCache();
    }

    public void validateQuery(DatabaseQuery query) {
    }

    public boolean verifyDelete(Object domainObject) {
        ObjectBuilder builder = this.getDescriptor(domainObject).getObjectBuilder();
        Object implementation = builder.unwrapObject(domainObject, this);
        return builder.verifyDelete(implementation, this);
    }

    public boolean wasJTSTransactionInternallyStarted() {
        return this.wasJTSTransactionInternallyStarted;
    }

    public Object wrapObject(Object implementation) {
        return this.getDescriptor(implementation).getObjectBuilder().wrapObject(implementation, this);
    }

    protected void writeAllObjectsWithChangeSet(UnitOfWorkChangeSet uowChangeSet) throws DatabaseException, OptimisticLockException {
        this.getCommitManager().commitAllObjectsWithChangeSet(uowChangeSet);
    }

    public Object writeObject(Object domainObject) throws DatabaseException, OptimisticLockException {
        WriteObjectQuery query = new WriteObjectQuery();
        query.setObject(domainObject);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    public void writesCompleted() {
        if (this.getAccessors() == null) {
            return;
        }
        for (Accessor accessor : this.getAccessors()) {
            accessor.writesCompleted(this);
        }
    }

    @Override
    public void processCommand(Object command) {
        ((Command)command).executeWithSession(this);
    }

    @Override
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public void setCommandManager(CommandManager mgr) {
        this.commandManager = mgr;
    }

    public boolean shouldPropagateChanges() {
        return this.shouldPropagateChanges;
    }

    public void setShouldPropagateChanges(boolean choice) {
        this.shouldPropagateChanges = choice;
    }

    @Override
    public boolean shouldLogMessages(int logLevel) {
        if (this.isLoggingOff) {
            return false;
        }
        if (1 == logLevel) {
            return this.getLogLevel("propagation") <= 7;
        }
        if (2 == logLevel) {
            return this.getLogLevel("propagation") <= 6;
        }
        if (3 == logLevel) {
            return this.getLogLevel("propagation") <= 2;
        }
        if (4 == logLevel) {
            return this.getLogLevel("propagation") <= 1;
        }
        return false;
    }

    @Override
    public void logMessage(int logLevel, String message) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLogMessages(logLevel)) {
            int level;
            switch (logLevel) {
                case 1: {
                    level = 7;
                    break;
                }
                case 2: {
                    level = 6;
                    break;
                }
                case 3: {
                    level = 2;
                    break;
                }
                case 4: {
                    level = 1;
                    break;
                }
                default: {
                    level = 0;
                }
            }
            this.log(level, message, null, null, false);
        }
    }

    @Override
    public int getLogLevel(String category) {
        return this.getSessionLog().getLevel(category);
    }

    @Override
    public int getLogLevel() {
        return this.getSessionLog().getLevel();
    }

    @Override
    public void setLogLevel(int level) {
        this.isLoggingOff = false;
        this.getSessionLog().setLevel(level);
    }

    public boolean shouldDisplayData() {
        return this.getSessionLog().shouldDisplayData();
    }

    @Override
    public boolean shouldLog(int Level2, String category) {
        if (this.isLoggingOff) {
            return false;
        }
        return this.getSessionLog().shouldLog(Level2, category);
    }

    public void log(int level, String category, String message) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, (Object[])null);
    }

    public void log(int level, String category, String message, Object param) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, new Object[]{param});
    }

    public void log(int level, String category, String message, Object param1, Object param2) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, new Object[]{param1, param2});
    }

    public void log(int level, String category, String message, Object param1, Object param2, Object param3) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, new Object[]{param1, param2, param3});
    }

    public void log(int level, String category, String message, Object[] params) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(level, category, message, params, null);
    }

    public void log(int level, String category, String message, Object[] params, Accessor accessor) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(level, category, message, params, accessor, true);
    }

    public void log(int level, String category, String message, Object[] params, Accessor accessor, boolean shouldTranslate) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(level, category)) {
            this.startOperationProfile("Timer:Logging");
            this.log(new SessionLogEntry(level, category, this, message, params, accessor, shouldTranslate));
            this.endOperationProfile("Timer:Logging");
        }
    }

    public void log(int level, String message, Object[] params, Accessor accessor) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(level, message, params, accessor, true);
    }

    public void log(int level, String message, Object[] params, Accessor accessor, boolean shouldTranslate) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(level, null)) {
            this.startOperationProfile("Timer:Logging");
            this.log(new SessionLogEntry(level, this, message, params, accessor, shouldTranslate));
            this.endOperationProfile("Timer:Logging");
        }
    }

    public void logThrowable(int level, String category, Throwable throwable) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(level, category)) {
            this.startOperationProfile("Timer:Logging");
            this.log(new SessionLogEntry(this, level, category, throwable));
            this.endOperationProfile("Timer:Logging");
        }
    }

    public void severe(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(7, category, message);
    }

    public void warning(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(6, category, message);
    }

    public void info(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(5, category, message);
    }

    public void config(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(4, category, message);
    }

    public void fine(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(3, category, message);
    }

    public void finer(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(2, category, message);
    }

    public void finest(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(1, category, message);
    }

    @Override
    public Object handleSevere(RuntimeException exception) throws RuntimeException {
        this.logThrowable(7, null, exception);
        if (this.hasExceptionHandler()) {
            return this.getExceptionHandler().handleException(exception);
        }
        throw exception;
    }

    public void releaseReadConnection(Accessor connection) {
    }

    public void copyDescriptorNamedQueries(boolean allowSameQueryNameDiffArgsCopyToSession) {
        for (ClassDescriptor descriptor : this.getProject().getOrderedDescriptors()) {
            Map queries = descriptor.getQueryManager().getQueries();
            if (queries == null || queries.size() <= 0) continue;
            for (Map.Entry entry : queries.entrySet()) {
                Vector thisQueries = (Vector)entry.getValue();
                if (thisQueries == null || thisQueries.size() <= 0) continue;
                for (DatabaseQuery queryToBeAdded : thisQueries) {
                    if (allowSameQueryNameDiffArgsCopyToSession) {
                        this.addQuery(queryToBeAdded);
                        continue;
                    }
                    if (this.getQuery(queryToBeAdded.getName()) == null) {
                        this.addQuery(queryToBeAdded);
                        continue;
                    }
                    this.log(6, "properties", "descriptor_named_query_cannot_be_added", new Object[]{queryToBeAdded, queryToBeAdded.getName(), queryToBeAdded.getArgumentTypes()});
                }
            }
        }
    }

    public void postAcquireConnection(Accessor accessor) {
        if (this.eventManager != null) {
            this.eventManager.postAcquireConnection(accessor);
        }
    }

    public void preReleaseConnection(Accessor accessor) {
        if (this.eventManager != null) {
            this.eventManager.preReleaseConnection(accessor);
        }
    }

    public boolean isExclusiveConnectionRequired() {
        return false;
    }

    @Override
    public ReferenceMode getDefaultReferenceMode() {
        return this.defaultReferenceMode;
    }

    @Override
    public void setDefaultReferenceMode(ReferenceMode defaultReferenceMode) {
        this.defaultReferenceMode = defaultReferenceMode;
    }

    public void load(Object objectOrCollection, AttributeGroup group2) {
        if (objectOrCollection == null || group2 == null) {
            return;
        }
        LoadGroup loadGroup = group2.toLoadGroup();
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (this.getCurrentGroup() != null) {
                    FetchGroup fetchGroup;
                    if (this.getCurrentDescriptor().hasFetchGroupManager() && (fetchGroup = this.getCurrentDescriptor().getFetchGroupManager().getObjectFetchGroup(object)) != null && !fetchGroup.getAttributeNames().containsAll(this.getCurrentGroup().getAttributeNames())) {
                        fetchGroup.onUnfetchedAttribute((FetchGroupTracker)object, null);
                    }
                    ObjectBuilder builder = this.getCurrentDescriptor().getObjectBuilder();
                    Iterator<String> it = this.getCurrentGroup().getAttributeNames().iterator();
                    while (it.hasNext()) {
                        DatabaseMapping mapping = builder.getMappingForAttributeName(it.next());
                        mapping.instantiateAttribute(object, this.session);
                    }
                }
            }
        };
        iterator.setSession(this);
        iterator.setVisitedObjects(new IdentityHashMap());
        iterator.setShouldTrackCurrentGroup(true);
        if (objectOrCollection instanceof Collection) {
            Iterator it = ((Collection)objectOrCollection).iterator();
            while (it.hasNext()) {
                iterator.startIterationOn(it.next(), loadGroup);
            }
        } else {
            iterator.startIterationOn(objectOrCollection, loadGroup);
        }
    }

    public CacheKey retrieveCacheKey(Object primaryKey, ClassDescriptor concreteDescriptor, JoinedAttributeManager joinManager, boolean requiresDeferredLocks) {
        CacheKey cacheKey;
        if (requiresDeferredLocks) {
            int counter;
            cacheKey = this.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor);
            for (counter = 0; cacheKey.getObject() == null && counter < 1000 && cacheKey.getMutex().getActiveThread() != Thread.currentThread(); ++counter) {
                cacheKey.releaseDeferredLock();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException exception) {
                    // empty catch block
                }
                cacheKey = this.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor);
            }
            if (counter == 1000) {
                throw ConcurrencyException.maxTriesLockOnBuildObjectExceded(cacheKey.getMutex().getActiveThread(), Thread.currentThread());
            }
        } else {
            cacheKey = this.getIdentityMapAccessorInstance().acquireLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor);
        }
        return cacheKey;
    }

    @Override
    public PartitioningPolicy getPartitioningPolicy() {
        return this.partitioningPolicy;
    }

    @Override
    public void setPartitioningPolicy(PartitioningPolicy partitioningPolicy) {
        this.partitioningPolicy = partitioningPolicy;
    }
}

