/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

public class DeleteObjectQuery
extends ObjectLevelModifyQuery {
    protected boolean isFullRowRequired = false;

    public DeleteObjectQuery() {
    }

    public DeleteObjectQuery(Object objectToDelete) {
        this();
        this.setObject(objectToDelete);
    }

    public DeleteObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public boolean isFullRowRequired() {
        return this.isFullRowRequired;
    }

    public void setIsFullRowRequired(boolean isFullRowRequired) {
        this.isFullRowRequired = isFullRowRequired;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        this.checkDescriptor(session);
        DescriptorQueryManager queryManager = this.descriptor.getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && queryManager.hasDeleteQuery()) {
            return queryManager.getDeleteQuery();
        }
        return null;
    }

    protected Object executeInUnitOfWorkObjectLevelModifyQuery(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        Object result = unitOfWork.processDeleteObjectQuery(this);
        if (result != null) {
            return result;
        }
        return super.executeInUnitOfWorkObjectLevelModifyQuery(unitOfWork, translationRow);
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultDeleteObjectQueryRedirector();
    }

    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        AbstractSession session = this.getSession();
        CommitManager commitManager = session.getCommitManager();
        Object object = this.getObject();
        boolean isUnitOfWork = session.isUnitOfWork();
        try {
            ClassDescriptor descriptor;
            DescriptorEventManager eventManager;
            if (commitManager.isProcessedCommit(object)) {
                return object;
            }
            commitManager.markPreModifyCommitInProgress(this.getObject());
            if (!isUnitOfWork) {
                session.beginTransaction();
            }
            if ((eventManager = (descriptor = this.descriptor).getEventManager()).hasAnyEventListeners()) {
                eventManager.executeEvent(new DescriptorEvent(2, this));
            }
            if (this.shouldCascadeParts()) {
                descriptor.getQueryManager().preDelete(this);
            }
            if (eventManager.hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(14, this);
                event.setRecord(this.getModifyRow());
                eventManager.executeEvent(event);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementDelete(this);
            }
            int rowCount = 0;
            rowCount = isUnitOfWork && ((UnitOfWorkImpl)session).hasCascadeDeleteObjects() && ((UnitOfWorkImpl)session).getCascadeDeleteObjects().contains(object) ? 1 : this.getQueryMechanism().deleteObject();
            if (rowCount < 1 && session.hasEventManager()) {
                session.getEventManager().noRowsModified(this, object);
            }
            if (descriptor.usesOptimisticLocking()) {
                descriptor.getOptimisticLockingPolicy().validateDelete(rowCount, object, this);
            }
            commitManager.markPostModifyCommitInProgress(this.getObject());
            if (this.shouldCascadeParts()) {
                descriptor.getQueryManager().postDelete(this);
            }
            if (descriptor.getHistoryPolicy() != null && descriptor.getHistoryPolicy().shouldHandleWrites()) {
                descriptor.getHistoryPolicy().postDelete(this);
            }
            if (eventManager.hasAnyEventListeners()) {
                eventManager.executeEvent(new DescriptorEvent(3, this));
            }
            if (!isUnitOfWork) {
                session.commitTransaction();
            }
            commitManager.markCommitCompleted(object);
            if (this.shouldMaintainCache()) {
                if (isUnitOfWork) {
                    ((UnitOfWorkImpl)session).addObjectDeletedDuringCommit(object, descriptor);
                } else {
                    session.getIdentityMapAccessorInstance().removeFromIdentityMap(this.getPrimaryKey(), descriptor.getJavaClass(), descriptor, object);
                }
            }
            return object;
        }
        catch (RuntimeException exception) {
            if (!isUnitOfWork) {
                session.rollbackTransaction();
            }
            commitManager.markCommitCompleted(object);
            throw exception;
        }
    }

    public boolean isDeleteObjectQuery() {
        return true;
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareDeleteObject();
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        DeleteObjectQuery customDeleteQuery = (DeleteObjectQuery)customQuery;
        customDeleteQuery.setObject(this.getObject());
        customDeleteQuery.setObjectChangeSet(this.getObjectChangeSet());
        customDeleteQuery.setCascadePolicy(this.getCascadePolicy());
        customDeleteQuery.setShouldMaintainCache(this.shouldMaintainCache());
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.translationRow == null || this.translationRow.isEmpty()) {
            this.translationRow = this.isFullRowRequired ? this.descriptor.getObjectBuilder().buildRow(this.object, this.session, DatabaseMapping.WriteType.UNDEFINED) : this.descriptor.getObjectBuilder().buildRowForTranslation(this.object, this.session);
        }
        if (this.descriptor.usesOptimisticLocking()) {
            this.descriptor.getOptimisticLockingPolicy().addLockValuesToTranslationRow(this);
        }
    }
}

