/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.server.UnicastRemoteObject;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.internal.sessions.coordination.rmi.RMIRemoteCommandConnection;
import org.eclipse.persistence.internal.sessions.coordination.rmi.RMIRemoteCommandConnectionImpl;
import org.eclipse.persistence.internal.sessions.coordination.rmi.RMIRemoteConnection;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.ServiceId;
import org.eclipse.persistence.sessions.coordination.TransportManager;

public class RMITransportManager
extends TransportManager {
    public boolean isRMIOverIIOP;

    public RMITransportManager(RemoteCommandManager rcm) {
        this.rcm = rcm;
        this.initialize();
    }

    public RemoteConnection createConnection(ServiceId connectionServiceId) {
        RemoteConnection connection = null;
        if (this.namingServiceType == 1) {
            connection = this.createConnectionFromRegistry(connectionServiceId.getId(), connectionServiceId.getURL());
        } else if (this.namingServiceType == 0) {
            connection = this.createConnectionFromJNDI(connectionServiceId.getId(), connectionServiceId.getURL());
        }
        if (connection != null) {
            connection.setServiceId(connectionServiceId);
        }
        return connection;
    }

    protected RemoteConnection createConnectionFromJNDI(String remoteObjectIdentifier, String hostURL) {
        Object[] args = new Object[]{remoteObjectIdentifier, hostURL};
        this.rcm.logDebug("looking_up_remote_conn_in_jndi", args);
        try {
            Context context = this.getRemoteHostContext(hostURL);
            if (this.isRMIOverIIOP()) {
                return new RMIRemoteConnection((RMIRemoteCommandConnection)PortableRemoteObject.narrow((Object)context.lookup(remoteObjectIdentifier), RMIRemoteCommandConnection.class));
            }
            return new RMIRemoteConnection((RMIRemoteCommandConnection)context.lookup(remoteObjectIdentifier));
        }
        catch (Exception e) {
            try {
                this.rcm.handleException(RemoteCommandManagerException.errorLookingUpRemoteConnection(remoteObjectIdentifier, hostURL, e));
            }
            catch (Exception ex2) {
                this.rcm.logDebug("unable_to_look_up_remote_conn_in_jndi", args);
            }
            return null;
        }
    }

    protected RemoteConnection createConnectionFromRegistry(String remoteObjectIdentifier, String hostURL) {
        String formattedUrl = this.formatURLforRegistry(hostURL, remoteObjectIdentifier);
        Object[] args = new Object[]{formattedUrl};
        this.rcm.logDebug("looking_up_remote_conn_in_registry", args);
        try {
            return new RMIRemoteConnection((RMIRemoteCommandConnection)Naming.lookup(formattedUrl));
        }
        catch (Exception e) {
            try {
                this.rcm.handleException(RemoteCommandManagerException.errorLookingUpRemoteConnection(remoteObjectIdentifier, hostURL, e));
            }
            catch (Exception ex2) {
                this.rcm.logDebug("unable_to_look_up_remote_conn_in_registry", args);
            }
            return null;
        }
    }

    public void createLocalConnection() {
        if (this.namingServiceType == 1) {
            this.createLocalConnectionInRegistry();
        } else if (this.namingServiceType == 0) {
            this.createLocalConnectionInJNDI();
        }
        if (this.localConnection != null) {
            this.localConnection.setServiceId(this.rcm.getServiceId());
        }
    }

    protected void createLocalConnectionInJNDI() {
        try {
            RMIRemoteCommandConnection remoteConnectionObject = this.isRMIOverIIOP() ? new org.eclipse.persistence.internal.sessions.coordination.rmi.iiop.RMIRemoteCommandConnectionImpl(this.rcm) : new RMIRemoteCommandConnectionImpl(this.rcm);
            Object[] args = new Object[]{this.rcm.getServiceId().getId()};
            this.rcm.logDebug("register_local_connection_in_jndi", args);
            this.getLocalHostContext().rebind(this.rcm.getServiceId().getId(), (Object)remoteConnectionObject);
            this.localConnection = new RMIRemoteConnection(remoteConnectionObject);
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorBindingConnection(this.rcm.getServiceId().toString(), exception));
        }
    }

    protected RemoteConnection createLocalConnectionInRegistry() {
        String fullURL = this.formatURLforRegistry(this.rcm.getServiceId().getURL(), this.rcm.getServiceId().getId());
        try {
            RMIRemoteCommandConnectionImpl remoteConnectionObject = new RMIRemoteCommandConnectionImpl(this.rcm);
            Object[] args = new Object[]{fullURL};
            this.rcm.logDebug("register_local_connection_in_registry", args);
            Naming.rebind(fullURL, remoteConnectionObject);
            this.localConnection = new RMIRemoteConnection(remoteConnectionObject);
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorBindingConnection(fullURL, exception));
        }
        return this.localConnection;
    }

    public Context getLocalHostContext() {
        return this.getContext(this.getLocalContextProperties());
    }

    private String formatURLforRegistry(String url, String serviceName) {
        if (url == null) {
            return null;
        }
        String fullURL = url;
        if (fullURL != null && (fullURL.endsWith("/") || fullURL.endsWith("\\"))) {
            fullURL = fullURL.substring(0, fullURL.length() - 1);
        }
        return fullURL + "/" + serviceName;
    }

    public String getDefaultLocalUrl() {
        try {
            String localHost = InetAddress.getLocalHost().getHostName();
            if (this.isRMIOverIIOP()) {
                return "corbaname::" + localHost + ":" + "5555#";
            }
            return "rmi://" + localHost + ":" + "23791";
        }
        catch (IOException exception) {
            throw RemoteCommandManagerException.errorGettingHostName(exception);
        }
    }

    public void initialize() {
        super.initialize();
        this.namingServiceType = 0;
    }

    public void removeLocalConnection() {
        String unbindName = null;
        try {
            RMIRemoteCommandConnection commandConnection;
            if (this.namingServiceType == 1) {
                unbindName = this.formatURLforRegistry(this.rcm.getServiceId().getURL(), this.rcm.getServiceId().getId());
                Naming.unbind(unbindName);
            } else if (this.namingServiceType == 0) {
                unbindName = this.rcm.getServiceId().getId();
                this.getLocalHostContext().unbind(unbindName);
            } else {
                return;
            }
            if (this.getConnectionToLocalHost() != null && (commandConnection = ((RMIRemoteConnection)this.getConnectionToLocalHost()).getConnection()) != null) {
                try {
                    UnicastRemoteObject.unexportObject(commandConnection, true);
                }
                catch (NoSuchObjectException noSuchObjectException) {}
            }
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorUnbindingLocalConnection(unbindName, exception));
        }
        this.localConnection = null;
    }

    public boolean isRMIOverIIOP() {
        return this.isRMIOverIIOP;
    }

    public void setIsRMIOverIIOP(boolean value) {
        this.isRMIOverIIOP = value;
    }
}

