/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;

public class TypeDefinition
extends DatabaseObjectDefinition {
    protected Vector fields = new Vector();

    public void addField(String fieldName, Class type2) {
        this.addField(new FieldDefinition(fieldName, type2));
    }

    public void addField(String fieldName, Class type2, int fieldSize) {
        this.addField(new FieldDefinition(fieldName, type2, fieldSize));
    }

    public void addField(String fieldName, Class type2, int fieldSize, int fieldSubSize) {
        this.addField(new FieldDefinition(fieldName, type2, fieldSize, fieldSubSize));
    }

    public void addField(String fieldName, String typeName) {
        this.addField(new FieldDefinition(fieldName, typeName));
    }

    public void addField(FieldDefinition field) {
        this.getFields().addElement(field);
    }

    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("CREATE TYPE " + this.getFullName() + " AS OBJECT (");
            Enumeration fieldsEnum = this.getFields().elements();
            while (fieldsEnum.hasMoreElements()) {
                FieldDefinition field = (FieldDefinition)fieldsEnum.nextElement();
                field.appendTypeString(writer, session);
                if (!fieldsEnum.hasMoreElements()) continue;
                writer.write(", ");
            }
            writer.write(")");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TYPE " + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Vector getFields() {
        return this.fields;
    }

    public void setFields(Vector fields) {
        this.fields = fields;
    }
}

