/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.AMXMBeanMetadata;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.UNCOMMITTED)
public final class Util {
    private static final String QUOTE_CHAR = "\"";
    public static final String TYPE_FIELD = "AMX_TYPE";
    static final String[] PROPERTY_PREFIX = new String[]{"get", "set", "is", "has"};
    static final Pattern TOKENIZER;

    private static void debug(String s) {
        System.out.println(s);
    }

    public static String quoteIfNeeded(String name) {
        if (name.indexOf(":") > 1) {
            return ObjectName.quote(name);
        }
        return name;
    }

    public static String unquoteIfNeeded(String name) {
        if (name != null && name.startsWith(QUOTE_CHAR) && name.endsWith(QUOTE_CHAR)) {
            return ObjectName.unquote(name);
        }
        return name;
    }

    private Util() {
    }

    public static ObjectName newObjectName(String name) {
        return JMXUtil.newObjectName(name);
    }

    public static ObjectName newObjectName(String domain, String props) {
        return Util.newObjectName(domain + ":" + props);
    }

    public static ObjectName newObjectNamePattern(String domain, String props) {
        return JMXUtil.newObjectNamePattern(domain, props);
    }

    public static ObjectName newObjectNamePattern(ObjectName objectName) {
        String props = objectName.getKeyPropertyListString();
        return Util.newObjectNamePattern(objectName.getDomain(), props);
    }

    public static String makeProp(String name, String value) {
        return JMXUtil.makeProp(name, value);
    }

    public static String makeTypeProp(String value) {
        return Util.makeProp("type", value);
    }

    public static String makeNameProp(String name) {
        return Util.makeProp("name", "" + Util.quoteIfNeeded(name));
    }

    public static String makeRequiredProps(String type2, String name) {
        String props = Util.makeTypeProp(type2);
        if (name != null && name.length() != 0 && !name.equals("")) {
            String nameProp = Util.makeNameProp(name);
            props = Util.concatenateProps(props, nameProp);
        }
        return props;
    }

    public static String getSelfProp(ObjectName objectName) {
        String type2 = objectName.getKeyProperty("type");
        String name = objectName.getKeyProperty("name");
        return Util.makeProp(type2, name);
    }

    public static String getAdditionalProps(ObjectName objectName) {
        Hashtable<String, String> allProps = objectName.getKeyPropertyList();
        allProps.remove("type");
        allProps.remove("name");
        String props = "";
        for (String key : allProps.keySet()) {
            String prop = Util.makeProp(key, allProps.get(key));
            props = Util.concatenateProps(props, prop);
        }
        return props;
    }

    public static String concatenateProps(String props1, String props2) {
        return JMXUtil.concatenateProps(props1, props2);
    }

    public static String concatenateProps(String props1, String props2, String props3) {
        return Util.concatenateProps(Util.concatenateProps(props1, props2), props3);
    }

    public static List<ObjectName> toObjectNameList(Collection<? extends AMXProxy> amxs) {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        for (AMXProxy aMXProxy : amxs) {
            objectNames.add(aMXProxy.objectName());
        }
        return Collections.checkedList(objectNames, ObjectName.class);
    }

    public static Map<String, ObjectName> toObjectNameMap(Map<String, ? extends AMXProxy> amxMap) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        for (String key : amxMap.keySet()) {
            AMXProxy value = amxMap.get(key);
            m.put(key, value.objectName());
        }
        return Collections.checkedMap(m, String.class, ObjectName.class);
    }

    public static ObjectName[] toObjectNamesArray(AMXProxy[] amx) {
        ObjectName[] objectNames = new ObjectName[amx.length];
        for (int i = 0; i < objectNames.length; ++i) {
            objectNames[i] = amx[i] == null ? null : amx[i].objectName();
        }
        return objectNames;
    }

    public static ObjectName[] toObjectNamesArray(Collection<? extends AMXProxy> amxs) {
        ObjectName[] objectNames = new ObjectName[amxs.size()];
        int i = 0;
        for (AMXProxy aMXProxy : amxs) {
            objectNames[i] = aMXProxy.objectName();
            ++i;
        }
        return objectNames;
    }

    public static <T extends AMXProxy> Map<String, T> createNameMap(Set<T> amxs) {
        HashMap<String, AMXProxy> m = new HashMap<String, AMXProxy>();
        for (AMXProxy amx : amxs) {
            String name = amx.getName();
            m.put(name, amx);
        }
        return m;
    }

    public static final Map<String, ObjectName> createObjectNameMap(Set<ObjectName> objectNames) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        for (ObjectName objectName : objectNames) {
            String name = Util.getNameProp(objectName);
            assert (!m.containsKey(name)) : "createObjectNameMap: key already present: " + name + " in " + objectName;
            m.put(name, objectName);
        }
        assert (m.keySet().size() == objectNames.size());
        return Collections.checkedMap(m, String.class, ObjectName.class);
    }

    public static <T extends AMXProxy> List<T> asProxyList(Collection<? extends AMXProxy> c, Class<T> intf) {
        ArrayList<T> list = new ArrayList<T>();
        for (AMXProxy aMXProxy : c) {
            list.add(aMXProxy.as(intf));
        }
        return list;
    }

    public static Map<String, Serializable> getAMXNotificationData(Notification notif) {
        return Collections.unmodifiableMap(JMXUtil.getUserDataMapString_Serializable(notif));
    }

    public static Serializable getAMXNotificationValue(Notification notif, String key) {
        Map<String, Serializable> data = Util.getAMXNotificationData(notif);
        if (data == null) {
            throw new IllegalArgumentException(notif.toString());
        }
        if (!data.containsKey(key)) {
            throw new IllegalArgumentException("Value not found for " + key + " in " + notif);
        }
        return data.get(key);
    }

    public static <T extends Serializable> T getAMXNotificationValue(Notification notif, String key, Class<T> theClass) {
        Serializable value = Util.getAMXNotificationValue(notif, key);
        return (T)((Serializable)theClass.cast(value));
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static AMXProxy asAMX(Object o) {
        return (AMXProxy)AMXProxy.class.cast(o);
    }

    public static <T extends AMXProxy> Set<T> filterAMX(Set<T> candidates, Class<?> desired) {
        HashSet<AMXProxy> result = new HashSet<AMXProxy>();
        for (AMXProxy amx : candidates) {
            if (!desired.isAssignableFrom(amx.getClass())) continue;
            result.add(amx);
        }
        return result;
    }

    public static Map<String, ObjectName> filterByType(ObjectName[] objectNames, String type2) {
        HashMap<String, ObjectName> m = null;
        if (objectNames != null) {
            m = new HashMap<String, ObjectName>();
            for (ObjectName o : objectNames) {
                if (!type2.equals(o.getKeyProperty("type"))) continue;
                m.put(o.getKeyProperty("name"), o);
            }
        }
        return m;
    }

    public static <T extends AMXProxy> Map<String, T> filterAMX(Map<String, T> candidates, Class<?> desired) {
        HashMap<String, AMXProxy> result = new HashMap<String, AMXProxy>();
        for (String key : candidates.keySet()) {
            AMXProxy amx = (AMXProxy)candidates.get(key);
            if (!desired.isAssignableFrom(amx.getClass())) continue;
            result.put(key, amx);
        }
        return result;
    }

    public static String getTypeProp(ObjectName objectName) {
        return objectName.getKeyProperty("type");
    }

    public static String getNameProp(ObjectName objectName) {
        return objectName.getKeyProperty("name");
    }

    public static String getParentPathProp(ObjectName objectName) {
        return objectName.getKeyProperty("pp");
    }

    public static String getParentPathProp(AMXProxy amx) {
        return Util.getParentPathProp(amx.extra().objectName());
    }

    public static ObjectName getParent(MBeanServer server, ObjectName objectName) {
        return (ObjectName)JMXUtil.getAttribute(server, objectName, "Parent");
    }

    public static String typeFromName(String s) {
        if (s.indexOf("-") >= 0) {
            return s;
        }
        String simpleName = s;
        int idx = s.lastIndexOf(".");
        if (idx >= 0) {
            simpleName = s.substring(idx + 1);
        }
        return Util.domConvertName(simpleName);
    }

    public static String deduceType(Class<?> intf) {
        String typeValue;
        if (intf == null) {
            throw new IllegalArgumentException("null interface");
        }
        String type2 = null;
        AMXMBeanMetadata meta = null;
        Object typeField = ClassUtil.getFieldValue(intf, TYPE_FIELD);
        type2 = typeField instanceof String ? (String)typeField : ((meta = intf.getAnnotation(AMXMBeanMetadata.class)) != null ? ((typeValue = meta.type()).equals("\u0000") || typeValue.length() == 0 ? Util.typeFromName(intf.getName()) : typeValue) : Util.typeFromName(intf.getName()));
        return type2;
    }

    public static ObjectName getAncestorByType(MBeanServer mbeanServer, ObjectName child, String type2) {
        ObjectName cur = child;
        while ((cur = (ObjectName)JMXUtil.getAttribute(mbeanServer, cur, "Parent")) != null && !Util.getTypeProp(cur).equals(type2)) {
        }
        return cur;
    }

    private static String domConvertName(String nameIn) {
        String name = nameIn;
        for (String p : PROPERTY_PREFIX) {
            if (!name.startsWith(p)) continue;
            name = name.substring(p.length());
            break;
        }
        StringBuilder buf = new StringBuilder(name.length() + 5);
        for (String t : TOKENIZER.split(name)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase());
        }
        return buf.toString();
    }

    private static String split(String lookback, String lookahead) {
        return "((?<=" + lookback + ")(?=" + lookahead + "))";
    }

    private static String or(String ... tokens) {
        StringBuilder buf = new StringBuilder();
        for (String t : tokens) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(t);
        }
        return buf.toString();
    }

    static {
        String pattern = Util.or(Util.split("x", "X"), Util.split("X", "Xx"), Util.split("\\d", "\\D"));
        pattern = pattern.replace("x", "\\p{Lower}").replace("X", "\\p{Upper}");
        TOKENIZER = Pattern.compile(pattern);
    }
}

