/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.container.ContainerFactory;
import com.sun.jersey.api.container.filter.LoggingFilter;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.glassfish.admin.rest.LazyJerseyInterface;
import org.glassfish.admin.rest.RestConfig;
import org.glassfish.admin.rest.RestConfigChangeListener;
import org.glassfish.admin.rest.adapter.Reloader;
import org.glassfish.admin.rest.generator.ASMResourcesGenerator;
import org.glassfish.admin.rest.provider.ActionReportResultHtmlProvider;
import org.glassfish.admin.rest.provider.ActionReportResultJsonProvider;
import org.glassfish.admin.rest.provider.ActionReportResultXmlProvider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.FormWriter;
import org.glassfish.admin.rest.provider.GetResultListHtmlProvider;
import org.glassfish.admin.rest.provider.GetResultListJsonProvider;
import org.glassfish.admin.rest.provider.GetResultListXmlProvider;
import org.glassfish.admin.rest.provider.OptionsResultJsonProvider;
import org.glassfish.admin.rest.provider.OptionsResultXmlProvider;
import org.glassfish.admin.rest.readers.FormReader;
import org.glassfish.admin.rest.readers.JsonHashMapProvider;
import org.glassfish.admin.rest.readers.JsonParameterMapProvider;
import org.glassfish.admin.rest.readers.JsonPropertyListReader;
import org.glassfish.admin.rest.readers.ParameterMapFormReader;
import org.glassfish.admin.rest.readers.XmlHashMapProvider;
import org.glassfish.admin.rest.readers.XmlPropertyListReader;
import org.glassfish.admin.rest.resources.GeneratorResource;
import org.glassfish.admin.rest.resources.MonitoringResource;
import org.glassfish.admin.rest.resources.ReloadResource;
import org.glassfish.admin.rest.resources.SessionsResource;
import org.glassfish.admin.rest.resources.StaticResource;
import org.glassfish.admin.rest.resources.StatusGenerator;
import org.glassfish.admin.rest.resources.custom.ManagementProxyResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyJerseyInit
implements LazyJerseyInterface {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GrizzlyAdapter exposeContext(Set classes, ServerContext sc, Habitat habitat) throws EndpointRegistrationException {
        Adapter adapter = null;
        Reloader r = new Reloader();
        DefaultResourceConfig rc = new DefaultResourceConfig(classes);
        ((ResourceConfig)rc).getMediaTypeMappings().put("xml", MediaType.APPLICATION_XML_TYPE);
        ((ResourceConfig)rc).getMediaTypeMappings().put("json", MediaType.APPLICATION_JSON_TYPE);
        ((ResourceConfig)rc).getMediaTypeMappings().put("html", MediaType.TEXT_HTML_TYPE);
        ((ResourceConfig)rc).getMediaTypeMappings().put("js", new MediaType("application", "x-javascript"));
        RestConfig restConf = this.getRestConfig(habitat);
        if (restConf != null) {
            if (restConf.getLogOutput().equalsIgnoreCase("true")) {
                rc.getContainerResponseFilters().add(LoggingFilter.class);
            }
            if (restConf.getLogInput().equalsIgnoreCase("true")) {
                rc.getContainerRequestFilters().add(LoggingFilter.class);
            }
            if (restConf.getWadlGeneration().equalsIgnoreCase("false")) {
                ((ResourceConfig)rc).getFeatures().put("com.sun.jersey.config.feature.DisableWADL", Boolean.TRUE);
            }
        }
        ((ResourceConfig)rc).getProperties().put("com.sun.jersey.spi.container.ContainerNotifier", r);
        ((Application)rc).getClasses().add(ReloadResource.class);
        ((Application)rc).getSingletons().add(new SingletonTypeInjectableProvider<Context, Reloader>(Reloader.class, r){});
        ((Application)rc).getSingletons().add(new SingletonTypeInjectableProvider<Context, ServerContext>(ServerContext.class, sc){});
        ((Application)rc).getSingletons().add(new SingletonTypeInjectableProvider<Context, Habitat>(Habitat.class, habitat){});
        ((Application)rc).getSingletons().add(new SingletonTypeInjectableProvider<Context, Client>(Client.class, Client.create()){});
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader apiClassLoader = sc.getCommonClassLoader();
            Thread.currentThread().setContextClassLoader(apiClassLoader);
            adapter = ContainerFactory.createContainer(Adapter.class, rc);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
        new RestConfigChangeListener(habitat, r, rc, sc);
        return (GrizzlyAdapter)adapter;
    }

    @Override
    public RestConfig getRestConfig(Habitat habitat) {
        Config config;
        if (habitat == null) {
            return null;
        }
        Domain domain = habitat.getComponent(Domain.class);
        if (domain != null && (config = domain.getConfigNamed("server-config")) != null) {
            return config.getExtensionByType(RestConfig.class);
        }
        return null;
    }

    @Override
    public void reportError(GrizzlyRequest req, GrizzlyResponse res, int statusCode, String msg) {
        try {
            BaseProvider provider;
            RestActionReporter report = new RestActionReporter();
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setActionDescription("Error");
            report.setMessage(msg);
            String type2 = LazyJerseyInit.getAcceptedMimeType(req);
            if ("xml".equals(type2)) {
                res.setContentType("application/xml");
                provider = new ActionReportResultXmlProvider();
            } else if ("json".equals(type2)) {
                res.setContentType("application/json");
                provider = new ActionReportResultJsonProvider();
            } else {
                res.setContentType("text/html");
                provider = new ActionReportResultHtmlProvider();
            }
            res.setStatus(statusCode);
            res.getOutputStream().write(provider.getContent(new ActionReportResult(report)).getBytes());
            res.getOutputStream().flush();
            res.finishResponse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getAcceptedMimeType(GrizzlyRequest req) {
        String type2 = null;
        String requestURI = req.getRequestURI();
        HashSet<String> acceptableTypes = new HashSet<String>(){
            {
                this.add("html");
                this.add("xml");
                this.add("json");
            }
        };
        if (requestURI.indexOf(46) != -1) {
            type2 = requestURI.substring(requestURI.indexOf(46) + 1);
        } else {
            String accept;
            String userAgent = req.getHeader("User-Agent");
            if (userAgent != null && (accept = req.getHeader("Accept")) != null) {
                if (accept.indexOf("html") != -1) {
                    return "html";
                }
                StringTokenizer st = new StringTokenizer(accept, ",");
                while (st.hasMoreElements()) {
                    String scheme = st.nextToken();
                    if (!acceptableTypes.contains(scheme = scheme.substring(scheme.indexOf(47) + 1))) continue;
                    type2 = scheme;
                    break;
                }
            }
        }
        return type2;
    }

    @Override
    public Set<Class<?>> getResourcesConfigForMonitoring(Habitat habitat) {
        HashSet r = new HashSet();
        r.add(MonitoringResource.class);
        r.add(ActionReportResultHtmlProvider.class);
        r.add(ActionReportResultJsonProvider.class);
        r.add(ActionReportResultXmlProvider.class);
        return r;
    }

    @Override
    public Set<Class<?>> getResourcesConfigForManagement(Habitat habitat) {
        Class<?> domainResourceClass = null;
        this.generateASM(habitat);
        try {
            domainResourceClass = Class.forName("org.glassfish.admin.rest.resources.generatedASM.DomainResource");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(LazyJerseyInit.class.getName()).log(Level.SEVERE, null, ex);
        }
        HashSet r = new HashSet();
        r.add(GeneratorResource.class);
        r.add(StatusGenerator.class);
        r.add(domainResourceClass);
        r.add(ManagementProxyResource.class);
        r.add(SessionsResource.class);
        r.add(StaticResource.class);
        r.add(FormReader.class);
        r.add(ParameterMapFormReader.class);
        r.add(JsonHashMapProvider.class);
        r.add(JsonPropertyListReader.class);
        r.add(JsonParameterMapProvider.class);
        r.add(XmlHashMapProvider.class);
        r.add(XmlPropertyListReader.class);
        r.add(ActionReportResultHtmlProvider.class);
        r.add(ActionReportResultJsonProvider.class);
        r.add(ActionReportResultXmlProvider.class);
        r.add(FormWriter.class);
        r.add(GetResultListHtmlProvider.class);
        r.add(GetResultListJsonProvider.class);
        r.add(GetResultListXmlProvider.class);
        r.add(OptionsResultJsonProvider.class);
        r.add(OptionsResultXmlProvider.class);
        return r;
    }

    private void generateASM(Habitat habitat) {
        try {
            Domain entity = habitat.getComponent(Domain.class);
            Dom dom = Dom.unwrap(entity);
            DomDocument document = dom.document;
            ConfigModel rootModel = dom.document.getRoot().model;
            ASMResourcesGenerator resourcesGenerator = new ASMResourcesGenerator();
            resourcesGenerator.generateSingle(rootModel, document);
            resourcesGenerator.endGeneration();
        }
        catch (Exception ex) {
            Logger.getLogger(GeneratorResource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

