/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.resources.TemplateExecCommand;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE})
public class SystemPropertiesCliResource
extends TemplateExecCommand {
    protected static final String TAG_SYSTEM_PROPERTY = "system-property";
    @Context
    protected ResourceContext resourceContext;
    protected Dom entity;
    protected Domain domain;

    public SystemPropertiesCliResource() {
        super(SystemPropertiesCliResource.class.getSimpleName(), "", "", "", "", true);
    }

    public void setEntity(Dom p) {
        this.entity = p;
    }

    public Dom getEntity() {
        return this.entity;
    }

    @GET
    public ActionReportResult get() {
        this.domain = this.habitat.getComponent(Domain.class);
        ParameterMap data = new ParameterMap();
        this.processCommandParams(data);
        this.addQueryString(((ContainerRequest)this.requestHeaders).getQueryParameters(), data);
        this.adjustParameters(data);
        TreeMap<String, Map<String, String>> properties = new TreeMap<String, Map<String, String>>();
        RestActionReporter actionReport = new RestActionReporter();
        Property domainProp = this.domain.getProperty("administrative.domain.name");
        String domainName = domainProp.getValue();
        PropertyBag spb = null;
        String target = this.getEntity().attribute("name");
        if ("domain".equals(target) || target.equals(domainName)) {
            spb = this.domain;
        } else {
            spb = this.domain.getConfigNamed(target);
            if (spb == null && (spb = this.domain.getClusterNamed(target)) == null) {
                spb = this.domain.getServerNamed(target);
            }
        }
        this.getSystemProperties((Map<String, Map<String, String>>)properties, (SystemPropertyBag)((Object)spb), false);
        actionReport.getExtraProperties().put("systemProperties", new ArrayList(properties.values()));
        if (properties.isEmpty()) {
            actionReport.getTopMessagePart().setMessage("Nothing to list.");
        }
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
        return results;
    }

    @POST
    public Response create(HashMap<String, String> data) {
        this.deleteExistingProperties();
        return this.saveProperties(data);
    }

    @PUT
    public Response update(HashMap<String, String> data) {
        return this.saveProperties(data);
    }

    @Path(value="{Name}/")
    @POST
    public Response getSystemPropertyResource(@PathParam(value="Name") String id, HashMap<String, String> data) {
        data.put(id, data.get("value"));
        data.remove("value");
        List<PathSegment> segments = this.uriInfo.getPathSegments(true);
        String grandParent = segments.get(segments.size() - 3).getPath();
        return this.saveProperties(grandParent, data);
    }

    protected void getSystemProperties(Map<String, Map<String, String>> properties, SystemPropertyBag spb, boolean getDefaults) {
        try {
            List<SystemProperty> sysProps = spb.getSystemProperty();
            if (!sysProps.isEmpty()) {
                for (SystemProperty prop : sysProps) {
                    Map<String, String> currValue = properties.get(prop.getName());
                    if (currValue == null) {
                        currValue = new HashMap<String, String>();
                        currValue.put("name", prop.getName());
                        if (getDefaults) {
                            currValue.put("defaultValue", prop.getValue());
                        } else {
                            currValue.put("value", prop.getValue());
                        }
                        if (prop.getDescription() != null) {
                            currValue.put("description", prop.getDescription());
                        }
                        properties.put(prop.getName(), currValue);
                        continue;
                    }
                    if (currValue.get("defaultValue") != null) continue;
                    currValue.put("defaultValue", prop.getValue());
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (spb instanceof Server) {
            Server server = (Server)spb;
            if (server.getCluster() != null) {
                this.getSystemProperties(properties, server.getCluster(), true);
            } else {
                this.getSystemProperties(properties, server.getConfig(), true);
            }
        } else if (spb instanceof Cluster) {
            String configRef = ((Cluster)spb).getConfigRef();
            this.getSystemProperties(properties, this.domain.getConfigNamed(configRef), true);
        }
    }

    protected String convertPropertyMapToString(HashMap<String, String> data) {
        StringBuilder options = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            options.append(sep).append(entry.getKey()).append("=").append(value.replaceAll(":", "\\\\:"));
            sep = ":";
        }
        return options.toString();
    }

    protected Response saveProperties(HashMap<String, String> data) {
        return this.saveProperties(null, data);
    }

    protected Response saveProperties(String parent, HashMap<String, String> data) {
        String propertiesString = this.convertPropertyMapToString(data);
        data = new HashMap();
        data.put("DEFAULT", propertiesString);
        data.put("target", parent == null ? this.getParent(this.uriInfo) : parent);
        RestActionReporter actionReport = ResourceUtil.runCommand("create-system-properties", data, this.habitat, "");
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
        int status = 200;
        if (exitCode == ActionReport.ExitCode.FAILURE) {
            status = 500;
        }
        results.setStatusCode(status);
        return Response.status(status).entity(results).build();
    }

    protected void deleteExistingProperties() {
        Dom parent = this.getEntity();
        for (Dom existingProp : parent.nodeElements(TAG_SYSTEM_PROPERTY)) {
            try {
                ConfigSupport.deleteChild((ConfigBean)parent, (ConfigBean)existingProp);
            }
            catch (TransactionFailure ex) {
                Logger.getLogger(SystemPropertiesCliResource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

