/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.connect;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.common.util.admin.AsadminInput;
import org.glassfish.common.util.admin.AuthTokenManager;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRunner {
    private static final String NL = System.getProperty("line.separator");
    private static final String AUTH_TOKEN_STDIN_LINE_PREFIX = "option._authtoken=";
    private Habitat habitat;
    private Logger logger;
    private String lastCommandRun = null;
    private int commandStatus;
    private SSHLauncher sshL = null;
    private final AuthTokenManager authTokenManager;

    public NodeRunner(Habitat habitat, Logger logger) {
        this.logger = logger;
        this.habitat = habitat;
        this.authTokenManager = habitat.getComponent(AuthTokenManager.class);
    }

    public String getLastCommandRun() {
        return this.lastCommandRun;
    }

    public boolean isSshNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        if (node.getType() == null) {
            return false;
        }
        return node.getType().equals("SSH");
    }

    public int runAdminCommandOnNode(Node node, StringBuilder output, List<String> args) throws SSHCommandExecutionException, ProcessManagerException, UnsupportedOperationException, IllegalArgumentException {
        return this.runAdminCommandOnNode(node, output, false, args);
    }

    public int runAdminCommandOnNode(Node node, StringBuilder output, boolean waitForReaderThreads, List<String> args) throws SSHCommandExecutionException, ProcessManagerException, UnsupportedOperationException, IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        ArrayList<String> stdinLines = new ArrayList<String>();
        stdinLines.add(AsadminInput.versionSpecifier());
        stdinLines.add(AUTH_TOKEN_STDIN_LINE_PREFIX + this.authTokenManager.createToken());
        args.add(0, "--_auxinput");
        args.add(1, "-");
        args.add(2, "--interactive=false");
        if (node.isLocal()) {
            return this.runAdminCommandOnLocalNode(node, output, waitForReaderThreads, args, stdinLines);
        }
        return this.runAdminCommandOnRemoteNode(node, output, args, stdinLines);
    }

    private int runAdminCommandOnLocalNode(Node node, StringBuilder output, boolean waitForReaderThreads, List<String> args, List<String> stdinLines) throws ProcessManagerException {
        ArrayList<String> fullcommand = new ArrayList<String>();
        String installDir = node.getInstallDirUnixStyle() + "/glassfish";
        if (!StringUtils.ok(installDir)) {
            throw new IllegalArgumentException("Node does not have an installDir");
        }
        File asadmin = new File(SystemPropertyConstants.getAsAdminScriptLocation(installDir));
        fullcommand.add(asadmin.getAbsolutePath());
        fullcommand.addAll(args);
        if (!asadmin.canExecute()) {
            throw new ProcessManagerException(asadmin.getAbsolutePath() + " is not executable.");
        }
        this.lastCommandRun = this.commandListToString(fullcommand);
        this.trace("Running command locally: " + this.lastCommandRun);
        ProcessManager pm = new ProcessManager(fullcommand);
        pm.setStdinLines(stdinLines);
        pm.waitForReaderThreads(waitForReaderThreads);
        pm.execute();
        String stdout = pm.getStdout();
        String stderr = pm.getStderr();
        if (output != null) {
            if (StringUtils.ok(stdout)) {
                output.append(stdout);
            }
            if (StringUtils.ok(stderr)) {
                if (output.length() > 0) {
                    output.append(NL);
                }
                output.append(stderr);
            }
        }
        return pm.getExitValue();
    }

    private int runAdminCommandOnRemoteNode(Node node, StringBuilder output, List<String> args, List<String> stdinLines) throws SSHCommandExecutionException, IllegalArgumentException, UnsupportedOperationException {
        if (!this.isSshNode(node)) {
            throw new UnsupportedOperationException("Node is not of type SSH");
        }
        String installDir = node.getInstallDirUnixStyle() + "/glassfish";
        if (!StringUtils.ok(installDir)) {
            throw new IllegalArgumentException("Node does not have an installDir");
        }
        ArrayList<String> fullcommand = new ArrayList<String>();
        fullcommand.add(installDir + "/bin/asadmin");
        fullcommand.addAll(args);
        try {
            this.lastCommandRun = this.commandListToString(fullcommand);
            this.trace("Running command on " + node.getNodeHost() + ": " + this.lastCommandRun);
            this.sshL = this.habitat.getComponent(SSHLauncher.class);
            this.sshL.init(node, this.logger);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.commandStatus = this.sshL.runCommand(fullcommand, (OutputStream)outStream, stdinLines);
            String results = outStream.toString();
            output.append(outStream.toString());
            return this.commandStatus;
        }
        catch (IOException ex) {
            String m1 = " Command execution failed. " + ex.getMessage();
            String m2 = "";
            Throwable e2 = ex.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            this.logger.severe("Command execution failed for " + this.lastCommandRun);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(StringUtils.cat(":", m1));
            cee.setSSHSettings(this.sshL.toString());
            cee.setCommandRun(this.lastCommandRun);
            throw cee;
        }
        catch (InterruptedException ei) {
            ei.printStackTrace();
            String m1 = ei.getMessage();
            String m2 = "";
            Throwable e2 = ei.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            this.logger.severe("Command interrupted " + this.lastCommandRun);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(StringUtils.cat(":", m1, m2));
            cee.setSSHSettings(this.sshL.toString());
            cee.setCommandRun(this.lastCommandRun);
            throw cee;
        }
    }

    private void trace(String s) {
        this.logger.fine(String.format("%s: %s", this.getClass().getSimpleName(), s));
    }

    private String commandListToString(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

