/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ConnectionPoolUtil {
    @Inject
    private Applications applications;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment env;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectionPoolUtil.class);

    public boolean isValidApplication(String applicationName, String poolName, ActionReport report) {
        boolean isValid = false;
        if (applicationName == null) {
            this.setAppNameNeededErrorMessage(report);
            return isValid;
        }
        Application application = this.applications.getApplication(applicationName);
        if (application != null) {
            if (application.getEnabled().equalsIgnoreCase("true")) {
                Server server = this.domain.getServerNamed(this.env.getInstanceName());
                ApplicationRef appRef = server.getApplicationRef(applicationName);
                if (appRef != null) {
                    if (appRef.getRef().equals(applicationName)) {
                        if (appRef.getEnabled().equalsIgnoreCase("false")) {
                            this.setAppDisabledErrorMessage(report, applicationName, poolName);
                        } else {
                            isValid = true;
                        }
                    }
                } else {
                    this.setAppDisabledErrorMessage(report, applicationName, poolName);
                }
            } else {
                this.setAppDisabledErrorMessage(report, applicationName, poolName);
            }
        } else {
            this.setApplNotFoundErrorMessage(report, applicationName);
        }
        return isValid;
    }

    public boolean isValidModule(String applicationName, String moduleName, String poolName, ActionReport report) {
        boolean isValid = false;
        Application application = this.applications.getApplication(applicationName);
        if (!this.isValidApplication(applicationName, poolName, report)) {
            return false;
        }
        Module module = application.getModule(moduleName);
        if (module != null) {
            isValid = true;
        } else {
            this.setModuleNotFoundErrorMessage(report, moduleName, applicationName);
        }
        return isValid;
    }

    public boolean isValidPool(Resources resources, String poolName, String prefix, ActionReport report) {
        boolean isValid = false;
        if (resources != null) {
            if (resources.getResourceByName(ResourcePool.class, poolName) != null) {
                isValid = true;
            } else {
                this.setResourceNotFoundErrorMessage(report, poolName);
            }
        } else {
            this.setResourceNotFoundErrorMessage(report, poolName);
        }
        return isValid;
    }

    private void setAppNameNeededErrorMessage(ActionReport report) {
        report.setMessage(localStrings.getLocalString("pool.util.app.name.needed", "--appname is needed when --modulename is specified"));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    private void setAppDisabledErrorMessage(ActionReport report, String applicationName, String poolName) {
        report.setMessage(localStrings.getLocalString("pool.util.app.is.not.enabled", "Application [ {0} ] in which the pool [ {1} ] is defined, is not enabled", applicationName, poolName));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    private void setApplNotFoundErrorMessage(ActionReport report, String applicationName) {
        report.setMessage(localStrings.getLocalString("pool.util.app.does.not.exist", "Application {0} does not exist.", applicationName));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    private void setModuleNotFoundErrorMessage(ActionReport report, String moduleName, String applicationName) {
        report.setMessage(localStrings.getLocalString("pool.util.module.does.not.exist", "Module {0} does not exist in application {1}.", moduleName, applicationName));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    private void setResourceNotFoundErrorMessage(ActionReport report, String poolName) {
        report.setMessage(localStrings.getLocalString("pool.util.pool.does.not-exist", "Pool {0} does not exist.", poolName));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }
}

