/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.admin.cli.CustomResourceManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-custom-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.custom.resource")
public class CreateCustomResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateCustomResource.class);
    @Param(name="restype")
    private String resType;
    @Param(name="factoryclass")
    private String factoryClass;
    @Param(optional=true, defaultValue="true")
    private Boolean enabled;
    @Param(optional=true)
    private String description;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private Domain domain;
    @Inject
    private CustomResourceManager customResMgr;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("factory-class", this.factoryClass);
        attrList.put("res-type", this.resType);
        attrList.put("enabled", this.enabled.toString());
        attrList.put("jndi-name", this.jndiName);
        attrList.put("description", this.description);
        try {
            rs = this.customResMgr.create(this.domain.getResources(), attrList, this.properties, this.target);
        }
        catch (Exception e) {
            Logger.getLogger(CreateCustomResource.class.getName()).log(Level.SEVERE, "Unable to create custom resource " + this.jndiName, e);
            String def = "Custom resource: {0} could not be created, reason: {1}";
            report.setMessage(localStrings.getLocalString("create.custom.resource.fail", def, this.jndiName) + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() == null) {
                report.setMessage(localStrings.getLocalString("create.custom.resource.fail", "Custom resource {0} creation failed", this.jndiName, ""));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        if (rs.getMessage() != null) {
            report.setMessage(rs.getMessage());
        }
        report.setActionExitCode(ec);
    }
}

